/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.handlers;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.net.URI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.azure.storage.filters.SharedKeyLiteAuthentication;
import org.jclouds.azureblob.handlers.ParseAzureBlobErrorFromXmlContent;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.config.SaxParserModule;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseAzureBlobErrorFromXmlContentTest {
    @Test
    public void test404OnContainerIsContainerNotFound() {
        this.assertCodeMakes("GET", URI.create("https://jclouds.blob.core.windows.net/adriancole-azureblob-413790770?restype=container"), 404, "Not Found", "text/html; charset=us-ascii", "<HTML><HEAD><TITLE>Not Found</TITLE>\r\n", ContainerNotFoundException.class);
    }

    @Test
    public void test404WithoutContainerIsKeyNotFound() {
        this.assertCodeMakes("GET", URI.create("https://jclouds.blob.core.windows.net/adriancole-blobstore0/apples"), 404, "Not Found", "text/html; charset=us-ascii", "<HTML><HEAD><TITLE>Not Found</TITLE>\r\n", KeyNotFoundException.class);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, String contentType, String content, Class<? extends Exception> expected) {
        ParseAzureBlobErrorFromXmlContent function = (ParseAzureBlobErrorFromXmlContent)Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                this.bind(SharedKeyLiteAuthentication.class).toInstance(EasyMock.createMock(SharedKeyLiteAuthentication.class));
            }
        }}).getInstance(ParseAzureBlobErrorFromXmlContent.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method(method).endpoint(uri).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(statusCode).message(message).payload(content)).build();
        response.getPayload().getContentMetadata().setContentType(contentType);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        command.setException(ParseAzureBlobErrorFromXmlContentTest.classEq(expected));
        EasyMock.replay((Object[])new Object[]{command});
        function.handleError(command, response);
        EasyMock.verify((Object[])new Object[]{command});
    }

    public static Exception classEq(final Class<? extends Exception> in) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("classEq(");
                buffer.append(in);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return arg.getClass() == in;
            }
        });
        return null;
    }
}

