/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.filters;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import java.io.IOException;
import java.net.URI;
import org.jclouds.ContextBuilder;
import org.jclouds.azure.storage.filters.SharedKeyLiteAuthentication;
import org.jclouds.http.HttpRequest;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class SharedKeyLiteAuthenticationTest {
    private static final String ACCOUNT = "foo";
    private Injector injector;
    private SharedKeyLiteAuthentication filter;

    @DataProvider(parallel=true)
    public Object[][] dataProvider() {
        return new Object[][]{{HttpRequest.builder().method("PUT").endpoint("http://foo.blob.core.windows.net/movies/MOV1.avi?comp=block&blockid=BlockId1&timeout=60").build()}, {HttpRequest.builder().method("PUT").endpoint("http://foo.blob.core.windows.net/movies/MOV1.avi?comp=blocklist&timeout=120").build()}, {HttpRequest.builder().method("GET").endpoint("http://foo.blob.core.windows.net/movies/MOV1.avi").build()}};
    }

    @Test(threadPoolSize=3, dataProvider="dataProvider", timeOut=3000L)
    void testIdempotent(HttpRequest request) {
        request = this.filter.filter(request);
        String signature = request.getFirstHeaderOrNull("Authorization");
        String date = request.getFirstHeaderOrNull("Date");
        int iterations = 1;
        while (request.getFirstHeaderOrNull("Date").equals(date)) {
            date = request.getFirstHeaderOrNull("Date");
            ++iterations;
            Assert.assertEquals((String)signature, (String)request.getFirstHeaderOrNull("Authorization"));
            request = this.filter.filter(request);
        }
        System.out.printf("%s: %d iterations before the timestamp updated %n", Thread.currentThread().getName(), iterations);
    }

    @Test
    void testAclQueryStringRoot() {
        URI host = URI.create("http://foo.blob.core.windows.net/?comp=list");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(host).build();
        StringBuilder builder = new StringBuilder();
        this.filter.appendUriPath(request, builder);
        Assert.assertEquals((String)builder.toString(), (String)"/?comp=list");
    }

    @Test
    void testAclQueryStringResTypeNotSignificant() {
        URI host = URI.create("http://foo.blob.core.windows.net/mycontainer?restype=container");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(host).build();
        StringBuilder builder = new StringBuilder();
        this.filter.appendUriPath(request, builder);
        Assert.assertEquals((String)builder.toString(), (String)"/mycontainer");
    }

    @Test
    void testAclQueryStringComp() {
        URI host = URI.create("http://foo.blob.core.windows.net/mycontainer?comp=list");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(host).build();
        StringBuilder builder = new StringBuilder();
        this.filter.appendUriPath(request, builder);
        Assert.assertEquals((String)builder.toString(), (String)"/mycontainer?comp=list");
    }

    @Test
    void testAclQueryStringRelativeWithExtraJunk() {
        URI host = URI.create("http://foo.blob.core.windows.net/mycontainer?comp=list&marker=marker&maxresults=1&prefix=prefix");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(host).build();
        StringBuilder builder = new StringBuilder();
        this.filter.appendUriPath(request, builder);
        Assert.assertEquals((String)builder.toString(), (String)"/mycontainer?comp=list");
    }

    @BeforeClass
    protected void createFilter() throws IOException {
        this.injector = ContextBuilder.newBuilder((String)"azureblob").endpoint("https://${jclouds.identity}.blob.core.windows.net").credentials(ACCOUNT, "credential").modules((Iterable)ImmutableSet.of((Object)new BaseRestApiTest.MockModule(), (Object)new NullLoggingModule())).buildInjector();
        this.filter = (SharedKeyLiteAuthentication)this.injector.getInstance(SharedKeyLiteAuthentication.class);
    }
}

