/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.config;

import com.google.common.base.Charsets;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.byon.Node;
import org.jclouds.byon.config.YamlNodeStoreModule;
import org.jclouds.location.Provider;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.yaml.snakeyaml.Yaml;

@Test(groups={"unit"}, singleThreaded=true)
public class YamlNodeStoreModuleTest {
    Yaml yaml = (Yaml)this.createInjector().getInstance(Yaml.class);

    @DataProvider(name="names")
    public Object[][] createData() {
        return new Object[][]{{"instance1", "bear"}, {"instance2", "apple"}, {"instance2", "francis"}, {"instance4", "robot"}};
    }

    @Test(dataProvider="names")
    public void deleteObject(String id, String name) throws InterruptedException, IOException {
        Injector injector = this.createInjector();
        Map<String, ByteSource> map = this.getMap(injector);
        this.check(map, this.getStore(injector), "i-20312", id, name);
    }

    public void testProvidedMapWithValue() throws IOException {
        ConcurrentHashMap<String, ByteSource> map = new ConcurrentHashMap<String, ByteSource>();
        map.put("test", ByteSource.wrap((byte[])"id: instance1\nname: instancename\n".getBytes()));
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", "instance1", "instancename");
        this.remove(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test");
    }

    public void testProvidedConsistentAcrossRepeatedWrites() throws IOException {
        ConcurrentHashMap<String, ByteSource> map = new ConcurrentHashMap<String, ByteSource>();
        Injector injector = this.createInjectorWithProvidedMap(map);
        Assert.assertEquals((Map)((Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, ByteSource>>(){}, (Annotation)Names.named((String)"yaml")))), map);
        LoadingCache<String, Node> store = this.getStore(injector);
        for (int i = 0; i < 10; ++i) {
            this.check(map, store, "test" + i, "instance1" + i, "instancename" + i);
        }
    }

    public void testProvidedConsistentAcrossMultipleInjectors() throws IOException {
        ConcurrentHashMap<String, ByteSource> map = new ConcurrentHashMap<String, ByteSource>();
        this.put(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", "instance1", "instancename");
        this.remove(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test");
    }

    public void testDefaultConsistentAcrossMultipleInjectors() throws IOException {
        Map<String, ByteSource> map = this.getMap(this.createInjector());
        this.put(map, this.getStore(this.createInjector()), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjector()), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjector()), "test", "instance1", "instancename");
        this.remove(map, this.getStore(this.createInjector()), "test");
    }

    protected LoadingCache<String, Node> getStore(Injector injector) {
        return (LoadingCache)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<LoadingCache<String, Node>>(){}));
    }

    protected Map<String, ByteSource> getMap(Injector injector) {
        return (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, ByteSource>>(){}, (Annotation)Names.named((String)"yaml")));
    }

    protected Injector createInjectorWithProvidedMap(Map<String, ByteSource> map) {
        return Guice.createInjector((Module[])new Module[]{new YamlNodeStoreModule(map), new AbstractModule(){

            protected void configure() {
                this.bind(ByteSource.class).annotatedWith(Provider.class).toProvider(Providers.of(null));
            }
        }});
    }

    protected Injector createInjector() {
        return Guice.createInjector((Module[])new Module[]{new YamlNodeStoreModule(), new AbstractModule(){

            protected void configure() {
                this.bind(ByteSource.class).annotatedWith(Provider.class).toProvider(Providers.of(null));
            }
        }});
    }

    protected void check(Map<String, ByteSource> map, LoadingCache<String, Node> store, String key, String id, String name) throws IOException {
        this.put(map, store, key, id, name);
        this.checkConsistent(map, store, key, id, name);
        this.remove(map, store, key);
    }

    protected void remove(Map<String, ByteSource> map, LoadingCache<String, Node> store, String key) {
        store.invalidate((Object)key);
        Assert.assertEquals((long)store.size(), (long)0L);
        map.remove(key);
        Assert.assertEquals((int)map.size(), (int)0);
        try {
            Assert.assertEquals((Object)store.getUnchecked((Object)key), null);
            Assert.fail((String)"should not work as null is invalid");
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)map.get(key), null);
    }

    protected void checkConsistent(Map<String, ByteSource> map, LoadingCache<String, Node> store, String key, String id, String name) throws IOException {
        Assert.assertEquals((int)map.size(), (int)1);
        if (store.size() == 0L) {
            store.getUnchecked((Object)key);
        }
        Assert.assertEquals((long)store.size(), (long)1L);
        Assert.assertEquals((Object)store.getUnchecked((Object)key), (Object)Node.builder().id(id).name(name).build());
        Assert.assertEquals((Object)store.getUnchecked((Object)key), (Object)Node.builder().id(id).name(name).build());
        this.checkToYaml(map, key, id, name);
        this.checkToYaml(map, key, id, name);
    }

    protected void checkToYaml(Map<String, ByteSource> map, String key, String id, String name) throws IOException {
        Assert.assertEquals((String)map.get(key).asCharSource(Charsets.UTF_8).read(), (String)String.format("id: %s\nname: %s\n", id, name));
    }

    protected void put(Map<String, ByteSource> map, LoadingCache<String, Node> store, String key, String id, String name) {
        Assert.assertEquals((long)store.size(), (long)0L);
        Assert.assertEquals((int)map.size(), (int)0);
        map.put(key, ByteSource.wrap((byte[])String.format("id: %s\nname: %s\n", id, name).getBytes()));
        store.getUnchecked((Object)key);
    }
}

