/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.config;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jclouds.byon.Node;
import org.jclouds.byon.config.CacheNodeStoreModule;
import org.jclouds.location.Provider;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="CacheNodeStoreModuleTest")
public class CacheNodeStoreModuleTest {
    @DataProvider(name="names")
    public Object[][] createData() {
        return new Object[][]{{"instance1", "bear"}, {"instance2", "apple"}, {"instance2", "francis"}, {"instance4", "robot"}};
    }

    public void testProvidedMapWithValue() throws IOException {
        ConcurrentMap map = Maps.newConcurrentMap();
        map.put("test", Node.builder().id("instance1").name("instancename").build());
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", "instance1", "instancename");
        this.remove(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test");
    }

    public void testProvidedConsistentAcrossRepeatedWrites() throws IOException {
        ConcurrentMap map = Maps.newConcurrentMap();
        Injector injector = this.createInjectorWithProvidedMap(map);
        Assert.assertEquals((Map)((LoadingCache)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<LoadingCache<String, Node>>(){}))).asMap(), (Map)map);
        LoadingCache<String, Node> store = this.getStore(injector);
        for (int i = 0; i < 10; ++i) {
            this.check(map, store, "test" + i, "instance1" + i, "instancename" + i);
        }
    }

    public void testProvidedConsistentAcrossMultipleInjectors() throws IOException {
        ConcurrentMap map = Maps.newConcurrentMap();
        this.put(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test", "instance1", "instancename");
        this.remove(map, this.getStore(this.createInjectorWithProvidedMap(map)), "test");
    }

    public void testProvidedCacheConsistentAcrossMultipleInjectors() throws IOException {
        ConcurrentMap map = Maps.newConcurrentMap();
        LoadingCache cache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)Functions.forMap((Map)map)));
        this.put(map, this.getStore(this.createInjectorWithProvidedCache((LoadingCache<String, Node>)cache)), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedCache((LoadingCache<String, Node>)cache)), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjectorWithProvidedCache((LoadingCache<String, Node>)cache)), "test", "instance1", "instancename");
        this.remove(map, this.getStore(this.createInjectorWithProvidedCache((LoadingCache<String, Node>)cache)), "test");
    }

    private LoadingCache<String, Node> getStore(Injector injector) {
        return (LoadingCache)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<LoadingCache<String, Node>>(){}));
    }

    private Injector createInjectorWithProvidedMap(Map<String, Node> map) {
        return Guice.createInjector((Module[])new Module[]{new CacheNodeStoreModule(map), new AbstractModule(){

            public void configure() {
                this.bind(ByteSource.class).annotatedWith(Provider.class).toProvider(Providers.of(null));
            }
        }});
    }

    private Injector createInjectorWithProvidedCache(LoadingCache<String, Node> cache) {
        return Guice.createInjector((Module[])new Module[]{new CacheNodeStoreModule(cache), new AbstractModule(){

            public void configure() {
                this.bind(ByteSource.class).annotatedWith(Provider.class).toProvider(Providers.of(null));
            }
        }});
    }

    private void check(Map<String, Node> map, LoadingCache<String, Node> store, String key, String id, String name) throws IOException {
        this.put(map, store, key, id, name);
        this.checkConsistent(map, store, key, id, name);
        this.remove(map, store, key);
    }

    private void remove(Map<String, Node> map, LoadingCache<String, Node> store, String key) {
        store.invalidate((Object)key);
        Assert.assertEquals((long)store.size(), (long)0L);
        map.remove(key);
        Assert.assertEquals((int)map.size(), (int)0);
        try {
            Assert.assertEquals((Object)store.getUnchecked((Object)key), null);
            Assert.fail((String)"should not work as null is invalid");
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            // empty catch block
        }
        Assert.assertEquals((Object)map.get(key), null);
    }

    private void checkConsistent(Map<String, Node> map, LoadingCache<String, Node> store, String key, String id, String name) throws IOException {
        Assert.assertEquals((int)map.size(), (int)1);
        if (store.size() == 0L) {
            store.getUnchecked((Object)key);
        }
        Assert.assertEquals((long)store.size(), (long)1L);
        Assert.assertEquals((Object)store.getUnchecked((Object)key), (Object)Node.builder().id(id).name(name).build());
        Assert.assertEquals((Object)store.getUnchecked((Object)key), (Object)Node.builder().id(id).name(name).build());
    }

    private void put(Map<String, Node> map, LoadingCache<String, Node> store, String key, String id, String name) {
        Assert.assertEquals((long)store.size(), (long)0L);
        Assert.assertEquals((int)map.size(), (int)0);
        map.put(key, Node.builder().id(id).name(name).build());
        store.getUnchecked((Object)key);
    }
}

