/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon;

import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Set;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.byon.BYONApiMetadata;
import org.jclouds.byon.Node;
import org.jclouds.byon.config.BYONComputeServiceContextModule;
import org.jclouds.byon.config.CacheNodeStoreModule;
import org.jclouds.byon.functions.NodeToNodeMetadataTest;
import org.jclouds.byon.functions.NodesFromYamlTest;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true, testName="BYONComputeServiceTest")
public class BYONComputeServiceTest {
    @Test
    public void testNodesParseNodeMap() throws Exception {
        this.assertNodesParse("foo", (ComputeServiceContext)ContextBuilder.newBuilder((ApiMetadata)((BYONApiMetadata.Builder)new BYONApiMetadata().toBuilder().defaultModule(BYONComputeServiceContextModule.class)).build()).endpoint("foo").modules((Iterable)ImmutableSet.of((Object)new CacheNodeStoreModule((Map)ImmutableMap.of((Object)NodesFromYamlTest.TEST1.getId(), (Object)NodesFromYamlTest.TEST1)))).build(ComputeServiceContext.class));
    }

    @Test
    public void testNodesParseWithFileUrl() throws Exception {
        this.assertNodesParse("file://" + this.getClass().getResource("/test1.yaml").getPath(), (ComputeServiceContext)ContextBuilder.newBuilder((ApiMetadata)new BYONApiMetadata()).endpoint("file://" + this.getClass().getResource("/test1.yaml").getPath()).build(ComputeServiceContext.class));
    }

    @Test
    public void testNodesParseWithClasspathUrl() throws Exception {
        this.assertNodesParse("classpath:///test1.yaml", (ComputeServiceContext)ContextBuilder.newBuilder((ApiMetadata)new BYONApiMetadata()).endpoint("classpath:///test1.yaml").build(ComputeServiceContext.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNodesParse(String endpoint, ComputeServiceContext context) {
        try {
            Location providerLocation = NodeToNodeMetadataTest.expectedProviderLocationFromResource(endpoint);
            Supplier<LoadingCache<String, Node>> supplier = this.supplier(context);
            Assert.assertEquals((long)((LoadingCache)supplier.get()).size(), (long)context.getComputeService().listNodes().size());
            Assert.assertEquals((Map)((LoadingCache)supplier.get()).asMap(), (Map)ImmutableMap.of((Object)NodesFromYamlTest.TEST1.getId(), (Object)NodesFromYamlTest.TEST1));
            Assert.assertEquals((String)context.getComputeService().listNodes().toString(), (String)ImmutableSet.of((Object)NodeToNodeMetadataTest.expectedNodeMetadataFromResource(endpoint)).toString());
            Assert.assertEquals((Set)context.getComputeService().listAssignableLocations(), (Set)ImmutableSet.of((Object)providerLocation));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodesWithLocations() {
        try (ComputeServiceContext context = null;){
            String endpoint = "file://" + this.getClass().getResource("/test_location.yaml").getPath();
            context = (ComputeServiceContext)ContextBuilder.newBuilder((ApiMetadata)new BYONApiMetadata()).endpoint(endpoint).build(ComputeServiceContext.class);
            Supplier<LoadingCache<String, Node>> supplier = this.supplier(context);
            Assert.assertEquals((long)((LoadingCache)supplier.get()).size(), (long)context.getComputeService().listNodes().size());
            Assert.assertEquals((Map)((LoadingCache)supplier.get()).asMap(), (Map)ImmutableMap.of((Object)NodesFromYamlTest.TEST2.getId(), (Object)NodesFromYamlTest.TEST2, (Object)NodesFromYamlTest.TEST3.getId(), (Object)NodesFromYamlTest.TEST3));
            Location providerLocation = NodeToNodeMetadataTest.expectedProviderLocationFromResource(endpoint);
            Location virginia = NodeToNodeMetadataTest.zoneCalled("virginia", providerLocation);
            Location maryland = NodeToNodeMetadataTest.zoneCalled("maryland", providerLocation);
            Assert.assertEquals((String)context.getComputeService().listNodes().toString(), (String)ImmutableSet.of((Object)NodeToNodeMetadataTest.expectedNodeMetadataFromResource(1, endpoint, virginia), (Object)NodeToNodeMetadataTest.expectedNodeMetadataFromResource(2, endpoint, maryland, 2022)).toString());
            Assert.assertEquals((Object)((NodeMetadata)NodeMetadata.class.cast(Iterables.get((Iterable)context.getComputeService().listNodes(), (int)0))).getCredentials(), (Object)LoginCredentials.builder().user("myUser").password("happy bear").authenticateSudo(true).privateKey("-----BEGIN RSA PRIVATE KEY-----\nMIIEowIBAAKCAQEAuzaE6azgUxwESX1rCGdJ5xpdrc1XC311bOGZBCE8NA+CpFh2\nu01Vfv68NC4u6LFgdXSY1vQt6hiA5TNqQk0TyVfFAunbXgTekF6XqDPQUf1nq9aZ\nlMvo4vlaLDKBkhG5HJE/pIa0iB+RMZLS0GhxsIWerEDmYdHKM25o\n-----END RSA PRIVATE KEY-----\n").build());
            Assert.assertEquals((Set)context.getComputeService().listAssignableLocations(), (Set)ImmutableSet.of((Object)virginia, (Object)maryland));
        }
    }

    private Supplier<LoadingCache<String, Node>> supplier(ComputeServiceContext context) {
        Supplier supplier = (Supplier)context.utils().injector().getInstance(Key.get((TypeLiteral)new TypeLiteral<Supplier<LoadingCache<String, Node>>>(){}));
        return supplier;
    }
}

