/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elanceodesk.workplace.notifier.model;

import hudson.model.Job;
import hudson.model.Run;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.plugins.elanceodesk.workplace.notifier.Phase;
import jenkins.plugins.elanceodesk.workplace.notifier.Utils;
import jenkins.plugins.elanceodesk.workplace.notifier.model.Changeset;
import jenkins.plugins.elanceodesk.workplace.notifier.model.ScmState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildState {
    private String fullUrl;
    private int number;
    private Phase phase;
    private String status;
    private String url;
    private String displayName;
    private ScmState scm;
    private Map<String, String> parameters;
    private List<Changeset> changeSet;
    private List<String> causes;
    private String durationString;
    private final Map<String, Map<String, String>> artifacts = new HashMap<String, Map<String, String>>();

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public void setPhase(Phase phase) {
        this.phase = phase;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFullUrl() {
        return this.fullUrl;
    }

    public void setFullUrl(String fullUrl) {
        this.fullUrl = fullUrl;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> params) {
        this.parameters = new HashMap<String, String>(params);
    }

    public Map<String, Map<String, String>> getArtifacts() {
        return this.artifacts;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ScmState getScm() {
        return this.scm;
    }

    public void setScm(ScmState scmState) {
        this.scm = scmState;
    }

    public void updateArtifacts(Job job, Run run) {
        this.updateArchivedArtifacts(run);
    }

    private void updateArchivedArtifacts(Run run) {
        List buildArtifacts = run.getArtifacts();
        if (buildArtifacts == null) {
            return;
        }
        for (Run.Artifact a : buildArtifacts) {
            String artifactUrl = Jenkins.getInstance().getRootUrl() + run.getUrl() + "artifact/" + a.getHref();
            this.updateArtifact(a.getFileName(), "archive", artifactUrl);
        }
    }

    private void updateArtifact(String fileName, String locationName, String locationUrl) {
        Utils.verifyNotEmpty(fileName, locationName, locationUrl);
        if (!this.artifacts.containsKey(fileName)) {
            this.artifacts.put(fileName, new HashMap());
        }
        if (this.artifacts.get(fileName).containsKey(locationName)) {
            throw new RuntimeException(String.format("Adding artifacts mapping '%s/%s/%s' - artifacts Map already contains mapping of location '%s': %s", fileName, locationName, locationUrl, locationName, this.artifacts));
        }
        this.artifacts.get(fileName).put(locationName, locationUrl);
    }

    public List<Changeset> getChangeSet() {
        return this.changeSet;
    }

    public void setChangeSet(List<Changeset> changeSet) {
        this.changeSet = changeSet;
    }

    public List<String> getCauses() {
        return this.causes;
    }

    public void setCauses(List<String> causes) {
        this.causes = causes;
    }

    public String getDurationString() {
        return this.durationString;
    }

    public void setDurationString(String durationString) {
        this.durationString = durationString;
    }
}

