/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elanceodesk.workplace.notifier;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormValidation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.elanceodesk.workplace.notifier.Webhook;
import jenkins.plugins.elanceodesk.workplace.notifier.WebhookJobProperty;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public final class WebhookJobPropertyDescriptor
extends JobPropertyDescriptor {
    private List<Webhook> webhooks = new ArrayList<Webhook>();

    public WebhookJobPropertyDescriptor() {
        super(WebhookJobProperty.class);
        this.load();
    }

    public boolean isEnabled() {
        return !this.webhooks.isEmpty();
    }

    public List<Webhook> getTargets() {
        return this.webhooks;
    }

    public void setWebhooks(List<Webhook> webhooks) {
        this.webhooks = new ArrayList<Webhook>(webhooks);
    }

    public boolean isApplicable(Class<? extends Job> jobType) {
        return true;
    }

    public String getDisplayName() {
        return "Job Notification";
    }

    public int getDefaultTimeout() {
        return Webhook.DEFAULT_TIMEOUT;
    }

    public WebhookJobProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        JSON webhooksData;
        ArrayList<Webhook> webhooks = new ArrayList<Webhook>();
        if (formData != null && !formData.isNullObject() && (webhooksData = (JSON)formData.get("webhooks")) != null && !webhooksData.isEmpty()) {
            if (webhooksData.isArray()) {
                JSONArray webhooksArrayData = (JSONArray)webhooksData;
                webhooks.addAll(req.bindJSONToList(Webhook.class, (Object)webhooksArrayData));
            } else {
                JSONObject webhooksObjectData = (JSONObject)webhooksData;
                webhooks.add((Webhook)req.bindJSON(Webhook.class, webhooksObjectData));
            }
        }
        WebhookJobProperty notificationProperty = new WebhookJobProperty(webhooks);
        return notificationProperty;
    }

    public FormValidation doCheckUrl(@QueryParameter(value="url", fixEmpty=true) String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)e.getMessage());
        }
        return FormValidation.ok();
    }

    public boolean configure(StaplerRequest req, JSONObject formData) {
        this.save();
        return true;
    }
}

