/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elanceodesk.workplace.notifier;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jenkins.model.Jenkins;
import jenkins.plugins.elanceodesk.workplace.notifier.HttpWorker;
import jenkins.plugins.elanceodesk.workplace.notifier.Webhook;
import jenkins.plugins.elanceodesk.workplace.notifier.WebhookJobProperty;
import jenkins.plugins.elanceodesk.workplace.notifier.model.BuildState;
import jenkins.plugins.elanceodesk.workplace.notifier.model.Changeset;
import jenkins.plugins.elanceodesk.workplace.notifier.model.JobState;
import jenkins.plugins.elanceodesk.workplace.notifier.model.ScmState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Phase {
    STARTED,
    COMPLETED;

    private final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private ExecutorService executorService = Executors.newCachedThreadPool();

    public void handle(AbstractBuild build, TaskListener listener) {
        WebhookJobProperty property = (WebhookJobProperty)build.getParent().getProperty(WebhookJobProperty.class);
        if (property == null) {
            return;
        }
        for (Webhook target : property.getWebhooks()) {
            if (!this.isRun(target, build)) continue;
            listener.getLogger().println(String.format("Notifying webhook '%s'", target));
            try {
                JobState jobState = this.buildJobState(build.getParent(), build, listener);
                HttpWorker worker = new HttpWorker(target.getUrl(), this.gson.toJson((Object)jobState), target.getTimeout(), 3, listener.getLogger());
                this.executorService.submit(worker);
            }
            catch (Throwable error) {
                error.printStackTrace(listener.error(String.format("Failed to notify webhook '%s'", target)));
                listener.getLogger().println(String.format("Failed to notify webhook '%s' - %s: %s", target, error.getClass().getName(), error.getMessage()));
            }
        }
    }

    private boolean isRun(Webhook webhook, AbstractBuild build) {
        if (this.equals((Object)STARTED) && webhook.isStartNotification()) {
            return true;
        }
        if (this.equals((Object)COMPLETED)) {
            Result result = build.getResult();
            AbstractBuild previousBuild = build.getPreviousBuild();
            Result previousResult = previousBuild != null ? previousBuild.getResult() : Result.SUCCESS;
            return result == Result.ABORTED && webhook.isNotifyAborted() || result == Result.FAILURE && webhook.isNotifyFailure() || result == Result.NOT_BUILT && webhook.isNotifyNotBuilt() || result == Result.SUCCESS && previousResult == Result.FAILURE && webhook.isNotifyBackToNormal() || result == Result.SUCCESS && webhook.isNotifySuccess() || result == Result.UNSTABLE && webhook.isNotifyUnstable();
        }
        return false;
    }

    private JobState buildJobState(Job job, AbstractBuild run, TaskListener listener) throws IOException, InterruptedException {
        List causes;
        Jenkins jenkins = Jenkins.getInstance();
        String rootUrl = jenkins.getRootUrl();
        JobState jobState = new JobState();
        BuildState buildState = new BuildState();
        ScmState scmState = new ScmState();
        ParametersAction paramsAction = (ParametersAction)run.getAction(ParametersAction.class);
        EnvVars environment = run.getEnvironment(listener);
        Result result = run.getResult();
        String status = null;
        if (result != null) {
            Result previousResult;
            status = result.toString();
            AbstractBuild previousBuild = run.getPreviousBuild();
            Result result2 = previousResult = previousBuild != null ? previousBuild.getResult() : Result.SUCCESS;
            if (result == Result.SUCCESS && previousResult == Result.FAILURE) {
                status = "BACK_TO_NORMAL";
            }
            buildState.setStatus(status);
        }
        if ((causes = run.getCauses()) != null) {
            ArrayList<String> causesStrList = new ArrayList<String>();
            for (Cause cause : causes) {
                causesStrList.add(cause.getShortDescription());
            }
            buildState.setCauses(causesStrList);
        }
        if (this.equals((Object)COMPLETED)) {
            buildState.setDurationString(run.getDurationString());
        }
        jobState.setName(job.getName());
        jobState.setUrl(job.getUrl());
        jobState.setBuild(buildState);
        buildState.setNumber(run.number);
        buildState.setUrl(run.getUrl());
        buildState.setPhase(this);
        buildState.setScm(scmState);
        if (rootUrl != null) {
            buildState.setFullUrl(rootUrl + run.getUrl());
        }
        buildState.updateArtifacts(job, (Run)run);
        if (paramsAction != null) {
            EnvVars env = new EnvVars();
            for (ParameterValue value : paramsAction.getParameters()) {
                if (value.isSensitive()) continue;
                value.buildEnvironment((Run)run, env);
            }
            buildState.setParameters((Map<String, String>)env);
        }
        if (environment.get((Object)"GIT_URL") != null) {
            scmState.setUrl((String)environment.get((Object)"GIT_URL"));
        }
        if (environment.get((Object)"GIT_BRANCH") != null) {
            scmState.setBranch((String)environment.get((Object)"GIT_BRANCH"));
        }
        if (environment.get((Object)"GIT_COMMIT") != null) {
            scmState.setCommit((String)environment.get((Object)"GIT_COMMIT"));
        }
        if (this.equals((Object)STARTED)) {
            ChangeLogSet changeLogSet = run.getChangeSet();
            ArrayList<Changeset> changesets = new ArrayList<Changeset>();
            for (Object o : changeLogSet.getItems()) {
                ChangeLogSet.Entry entry = (ChangeLogSet.Entry)o;
                listener.getLogger().println("Entry " + o);
                Changeset changeset = new Changeset(entry.getAuthor().getDisplayName(), entry.getAuthor().getId(), entry.getAffectedFiles());
                changesets.add(changeset);
            }
            buildState.setChangeSet(changesets);
        }
        return jobState;
    }
}

