/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elanceodesk.workplace.notifier;

import hudson.ProxyConfiguration;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import jenkins.model.Jenkins;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class HttpWorker
implements Runnable {
    private PrintStream logger;
    private String url;
    private String data;
    private int timeout;
    private int retries;

    public HttpWorker(String url, String data, int timeout, int retries, PrintStream logger) {
        this.url = url;
        this.data = data;
        this.timeout = timeout;
        this.logger = logger;
        this.retries = retries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int tried = 0;
        boolean success = false;
        HttpClient client = this.getHttpClient();
        client.getParams().setConnectionManagerTimeout((long)this.timeout);
        do {
            StringRequestEntity requestEntity;
            ++tried;
            try {
                requestEntity = new StringRequestEntity(this.data, "application/json", "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace(this.logger);
                break;
            }
            this.logger.println(String.format("Posting data to webhook - %s. Already Tried %s times", this.url, tried));
            PostMethod post = new PostMethod(this.url);
            try {
                post.setRequestEntity((RequestEntity)requestEntity);
                int responseCode = client.executeMethod((HttpMethod)post);
                if (responseCode != 200) {
                    String response = post.getResponseBodyAsString();
                    this.logger.println(String.format("Posting data to - %s may have failed. Webhook responded with status code - %s", this.url, responseCode));
                    this.logger.println(String.format("Message from webhook - %s", response));
                    continue;
                }
                success = true;
                this.logger.println(String.format("Posting data to webhook - %s completed ", this.url));
            }
            catch (Exception e) {
                this.logger.println(String.format("Failed to post data to webhook - %s", this.url));
                e.printStackTrace(this.logger);
            }
            finally {
                post.releaseConnection();
            }
        } while (tried < this.retries && !success);
    }

    private HttpClient getHttpClient() {
        ProxyConfiguration proxy;
        HttpClient client = new HttpClient();
        if (Jenkins.getInstance() != null && (proxy = Jenkins.getInstance().proxy) != null) {
            client.getHostConfiguration().setProxy(proxy.name, proxy.port);
            String username = proxy.getUserName();
            String password = proxy.getPassword();
            if (username != null && !"".equals(username.trim())) {
                this.logger.println("Using proxy authentication (user=" + username + ")");
                client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        return client;
    }
}

