/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.jenkins.plugins.unleash;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import hudson.maven.MavenArgumentInterceptorAction;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.util.ArgumentListBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class UnleashArgumentInterceptorAction
implements MavenArgumentInterceptorAction {
    private static final Logger LOGGER = Logger.getLogger(UnleashArgumentInterceptorAction.class.getName());
    private transient String goalsAndOptions;

    public UnleashArgumentInterceptorAction(String goalsAndOptions) {
        this.goalsAndOptions = goalsAndOptions;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    public String getGoalsAndOptions(MavenModuleSetBuild build) {
        return this.goalsAndOptions;
    }

    public ArgumentListBuilder intercept(ArgumentListBuilder mavenargs, MavenModuleSetBuild build) {
        ArgumentListBuilder returnListBuilder;
        List argumentList = mavenargs.toList();
        if (((MavenModuleSet)build.getProject()).isIncrementalBuild() && this.containsJenkinsIncrementalBuildArguments(argumentList)) {
            LOGGER.config("This Maven build seems to be configured as 'Incremental build'. This will be disabled, as always the full project will be released");
            returnListBuilder = this.removeAllIncrementalBuildArguments(mavenargs.clone());
        } else {
            returnListBuilder = mavenargs.clone();
        }
        return returnListBuilder;
    }

    private boolean containsJenkinsIncrementalBuildArguments(List<String> mavenargs) {
        boolean plArgumentExists;
        int amdIndex = mavenargs.indexOf("-amd");
        int plIndex = mavenargs.indexOf("-pl");
        boolean amdArgumentExists = amdIndex != -1;
        boolean bl = plArgumentExists = plIndex != -1;
        if (amdArgumentExists && plArgumentExists) {
            boolean amdAndPlArgumentAreInSupposedOrder = amdIndex == plIndex - 1;
            return amdAndPlArgumentAreInSupposedOrder && this.thereIsAnArgumentBehinPlArgument(mavenargs, plIndex);
        }
        return false;
    }

    private boolean thereIsAnArgumentBehinPlArgument(List<String> mavenargs, int plIndex) {
        if (mavenargs.size() >= plIndex + 1) {
            return mavenargs.get(plIndex + 1) != null;
        }
        return false;
    }

    private ArgumentListBuilder removeAllIncrementalBuildArguments(ArgumentListBuilder mavenargs) {
        LOGGER.finer("Start removing the arguments '-amd -pl <list of modules>' from argument list");
        ArgumentListBuilder returnListBuilder = new ArgumentListBuilder();
        int amdIndex = mavenargs.toList().indexOf("-amd");
        this.ensureArgumentsAndMaskHaveSaveSize(mavenargs);
        boolean[] maskArray = mavenargs.toMaskArray();
        ArrayList maskList = Lists.newArrayList();
        for (boolean b : maskArray) {
            maskList.add(b);
        }
        List oldArgumentList = mavenargs.toList();
        String removedAmd = (String)oldArgumentList.remove(amdIndex);
        Preconditions.checkArgument((boolean)"-amd".equals(removedAmd));
        maskList.remove(amdIndex);
        String removedPl = (String)oldArgumentList.remove(amdIndex);
        Preconditions.checkArgument((boolean)"-pl".equals(removedPl));
        maskList.remove(amdIndex);
        String removedModuleList = (String)oldArgumentList.remove(amdIndex);
        maskList.remove(amdIndex);
        LOGGER.finer(String.format("Removed the arguments '-amd -pl %s' from argument list", removedModuleList));
        for (int i = 0; i < oldArgumentList.size(); ++i) {
            returnListBuilder.add((String)oldArgumentList.get(i), ((Boolean)maskList.get(i)).booleanValue());
        }
        this.ensureArgumentsAndMaskHaveSaveSize(returnListBuilder);
        LOGGER.fine(String.format("Rebuild maven argument list, old size=%s; new size=%s", oldArgumentList.size(), returnListBuilder.toList().size()));
        return returnListBuilder;
    }

    private void ensureArgumentsAndMaskHaveSaveSize(ArgumentListBuilder alb) {
        if (alb.toList().size() != alb.toMaskArray().length) {
            throw new RuntimeException("could not intercept argument list: ArgumentList and Mask are out of sync ");
        }
    }
}

