/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.jenkins.plugins.unleash;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.itemis.jenkins.plugins.unleash.Messages;
import com.itemis.jenkins.plugins.unleash.UnleashArgumentsAction;
import com.itemis.jenkins.plugins.unleash.UnleashCause;
import com.itemis.jenkins.plugins.unleash.permalinks.LastFailedReleasePermalink;
import com.itemis.jenkins.plugins.unleash.permalinks.LastSuccessfulReleasePermalink;
import com.itemis.jenkins.plugins.unleash.util.MavenUtil;
import com.itemis.maven.plugins.unleash.util.MavenVersionUtil;
import com.itemis.maven.plugins.unleash.util.VersionUpgradeStrategy;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.PermalinkProjectAction;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

public class UnleashAction
implements PermalinkProjectAction {
    private static final Logger LOGGER = Logger.getLogger(UnleashAction.class.getName());
    public static final PermissionGroup PERMISSIONS = new PermissionGroup(UnleashAction.class, Messages._UnleashAction_PermissionsTitle());
    public static final Permission RELEASE_PERMISSION = new Permission(PERMISSIONS, "Release", Messages._UnleashAction_ReleasePermission_Description(), Jenkins.ADMINISTER, PermissionScope.ITEM);
    private MavenModuleSet project;
    private boolean useGlobalVersion;
    private boolean allowLocalReleaseArtifacts;
    private boolean commitBeforeTagging;
    private boolean errorLog;
    private boolean debugLog;
    private VersionUpgradeStrategy versionUpgradeStrategy;
    private String tagNamePattern;
    private String scmMessagePrefix;

    public UnleashAction(MavenModuleSet project, boolean useGlobalVersion, boolean allowLocalReleaseArtifacts, boolean commitBeforeTagging, boolean errorLog, boolean debugLog, VersionUpgradeStrategy versionUpgradeStrategy, String tagNamePattern, String scmMessagePrefix) {
        this.project = project;
        this.useGlobalVersion = useGlobalVersion;
        this.allowLocalReleaseArtifacts = allowLocalReleaseArtifacts;
        this.commitBeforeTagging = commitBeforeTagging;
        this.errorLog = errorLog;
        this.debugLog = debugLog;
        this.versionUpgradeStrategy = versionUpgradeStrategy;
        this.tagNamePattern = tagNamePattern;
        this.scmMessagePrefix = scmMessagePrefix;
    }

    public List<ParameterDefinition> getParameterDefinitions() {
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)this.project.getProperty(ParametersDefinitionProperty.class);
        List params = Collections.emptyList();
        if (property != null) {
            params = property.getParameterDefinitions();
        }
        return params;
    }

    public String getIconFileName() {
        return "/plugin/unleash/img/unleash.png";
    }

    public String getDisplayName() {
        return "Trigger Unleash Maven Plugin";
    }

    public String getUrlName() {
        return "unleash";
    }

    public List<PermalinkProjectAction.Permalink> getPermalinks() {
        return Lists.newArrayList((Object[])new PermalinkProjectAction.Permalink[]{LastSuccessfulReleasePermalink.INSTANCE, LastFailedReleasePermalink.INSTANCE});
    }

    public String computeReleaseVersion() {
        MavenModule rootModule;
        Optional<String> parsedVersion;
        String version = null;
        Optional<Model> model = MavenUtil.parseModel(this.project.getRootModule(), this.project);
        if (model.isPresent() && (parsedVersion = MavenUtil.parseVersion((Model)model.get())).isPresent()) {
            version = MavenVersionUtil.calculateReleaseVersion((String)((String)parsedVersion.get()));
        }
        if (StringUtils.isBlank(version) && (rootModule = this.project.getRootModule()) != null && StringUtils.isNotBlank((String)rootModule.getVersion())) {
            version = MavenVersionUtil.calculateReleaseVersion((String)rootModule.getVersion());
        }
        if (StringUtils.isNotBlank(version)) {
            return version;
        }
        return "NaN";
    }

    public String computeReleaseVersion(MavenModule module) {
        String version = null;
        if (module != null) {
            Optional<String> parsedVersion;
            Optional<Model> model = MavenUtil.parseModel(module, this.project);
            if (model.isPresent() && (parsedVersion = MavenUtil.parseVersion((Model)model.get())).isPresent()) {
                version = MavenVersionUtil.calculateReleaseVersion((String)((String)parsedVersion.get()));
            }
            if (StringUtils.isBlank(version) && StringUtils.isNotBlank((String)module.getVersion())) {
                version = MavenVersionUtil.calculateReleaseVersion((String)module.getVersion());
            }
        }
        if (StringUtils.isNotBlank(version)) {
            return version;
        }
        return "NaN";
    }

    public String computeNextDevelopmentVersion() {
        MavenModule rootModule;
        Optional<String> parsedVersion;
        String version = null;
        Optional<Model> model = MavenUtil.parseModel(this.project.getRootModule(), this.project);
        if (model.isPresent() && (parsedVersion = MavenUtil.parseVersion((Model)model.get())).isPresent()) {
            version = MavenVersionUtil.calculateNextSnapshotVersion((String)((String)parsedVersion.get()), (VersionUpgradeStrategy)this.versionUpgradeStrategy);
        }
        if (StringUtils.isBlank(version) && (rootModule = this.project.getRootModule()) != null && StringUtils.isNotBlank((String)rootModule.getVersion())) {
            version = MavenVersionUtil.calculateNextSnapshotVersion((String)rootModule.getVersion(), (VersionUpgradeStrategy)this.versionUpgradeStrategy);
        }
        if (StringUtils.isNotBlank(version)) {
            return version;
        }
        return "NaN";
    }

    public String computeNextDevelopmentVersion(MavenModule module) {
        String version = null;
        if (module != null) {
            Optional<String> parsedVersion;
            Optional<Model> model = MavenUtil.parseModel(this.project.getRootModule(), this.project);
            if (model.isPresent() && (parsedVersion = MavenUtil.parseVersion((Model)model.get())).isPresent()) {
                version = MavenVersionUtil.calculateNextSnapshotVersion((String)((String)parsedVersion.get()), (VersionUpgradeStrategy)this.versionUpgradeStrategy);
            }
            if (StringUtils.isBlank(version) && StringUtils.isNotBlank((String)module.getVersion())) {
                version = MavenVersionUtil.calculateNextSnapshotVersion((String)module.getVersion(), (VersionUpgradeStrategy)this.versionUpgradeStrategy);
            }
        }
        if (StringUtils.isNotBlank(version)) {
            return version;
        }
        return "NaN";
    }

    public boolean isUseGlobalVersion() {
        return this.useGlobalVersion;
    }

    public boolean isNotUseGlobalVersion() {
        return !this.useGlobalVersion;
    }

    public void setUseGlobalVersion(boolean useGlobalVersion) {
        this.useGlobalVersion = useGlobalVersion;
    }

    public boolean isAllowLocalReleaseArtifacts() {
        return this.allowLocalReleaseArtifacts;
    }

    public void setAllowLocalReleaseArtifacts(boolean allowLocalReleaseArtifacts) {
        this.allowLocalReleaseArtifacts = allowLocalReleaseArtifacts;
    }

    public boolean isCommitBeforeTagging() {
        return this.commitBeforeTagging;
    }

    public void setCommitBeforeTagging(boolean commitBeforeTagging) {
        this.commitBeforeTagging = commitBeforeTagging;
    }

    public boolean isErrorLog() {
        return this.errorLog;
    }

    public void setErrorLog(boolean errorLog) {
        this.errorLog = errorLog;
    }

    public boolean isDebugLog() {
        return this.debugLog;
    }

    public void setDebugLog(boolean debugLog) {
        this.debugLog = debugLog;
    }

    public String getTagNamePattern() {
        return this.tagNamePattern;
    }

    public void setTagNamePattern(String tagNamePattern) {
        this.tagNamePattern = tagNamePattern;
    }

    public String getScmMessagePrefix() {
        return this.scmMessagePrefix;
    }

    public void setScmMessagePrefix(String scmMessagePrefix) {
        this.scmMessagePrefix = scmMessagePrefix;
    }

    public List<MavenModule> getAllMavenModules() {
        ArrayList modules = Lists.newArrayList();
        modules.addAll(this.project.getModules());
        return modules;
    }

    @POST
    public void doSubmit(StaplerRequest2 req, StaplerResponse2 resp) throws IOException, ServletException {
        this.project.checkPermission(RELEASE_PERMISSION);
        RequestWrapper requestWrapper = new RequestWrapper(req);
        UnleashArgumentsAction arguments = new UnleashArgumentsAction();
        boolean globalVersions = requestWrapper.getBoolean("useGlobalVersion");
        arguments.setUseGlobalReleaseVersion(globalVersions);
        if (globalVersions) {
            arguments.setGlobalReleaseVersion(requestWrapper.getString("releaseVersion"));
            arguments.setGlobalDevelopmentVersion(requestWrapper.getString("developmentVersion"));
        } else {
            arguments.setGlobalReleaseVersion(this.computeReleaseVersion());
            arguments.setGlobalDevelopmentVersion(this.computeNextDevelopmentVersion());
        }
        arguments.setAllowLocalReleaseArtifacts(requestWrapper.getBoolean("allowLocalReleaseArtifacts"));
        arguments.setCommitBeforeTagging(requestWrapper.getBoolean("commitBeforeTagging"));
        arguments.setErrorLog(requestWrapper.getBoolean("errorLog"));
        arguments.setDebugLog(requestWrapper.getBoolean("debugLog"));
        arguments.setTagNamePattern(requestWrapper.getString("tagNamePattern"));
        arguments.setScmMessagePrefix(requestWrapper.getString("scmMessagePrefix"));
        ArrayList<ParameterValue> params = new ArrayList<ParameterValue>();
        JSONObject formData = req.getSubmittedForm();
        JSONArray a = JSONArray.fromObject((Object)formData.get("parameter"));
        for (Object o : a) {
            String name;
            JSONObject jo;
            if (!(o instanceof JSONObject) || (jo = (JSONObject)o).isNullObject() || (name = jo.optString("name")) == null) continue;
            ParameterDefinition d = this.getParameterDefinition(name);
            if (d == null) {
                throw new IllegalArgumentException("No such parameter definition: " + name);
            }
            ParameterValue parameterValue = d.createValue(req, jo);
            params.add(parameterValue);
        }
        if (this.project.scheduleBuild(0, (Cause)new UnleashCause(), new Action[]{new ParametersAction(params), arguments})) {
            resp.sendRedirect(req.getContextPath() + "/" + this.project.getUrl());
        } else {
            resp.sendRedirect(req.getContextPath() + "/" + this.project.getUrl() + "/" + this.getUrlName() + "/failed");
        }
    }

    public ParameterDefinition getParameterDefinition(String name) {
        for (ParameterDefinition pd : this.getParameterDefinitions()) {
            if (!pd.getName().equals(name)) continue;
            return pd;
        }
        return null;
    }

    static class RequestWrapper {
        private final StaplerRequest2 request;

        public RequestWrapper(StaplerRequest2 request) {
            this.request = request;
        }

        private String getString(String key) {
            Map parameters = this.request.getParameterMap();
            Object o = parameters.get(key);
            if (o != null) {
                Object firstParam;
                if (o instanceof String) {
                    String string = (String)o;
                    return string;
                }
                if (o.getClass().isArray() && (firstParam = ((Object[])o)[0]) instanceof String) {
                    String string = (String)firstParam;
                    return string;
                }
            }
            return null;
        }

        private boolean getBoolean(String key) {
            Map parameters = this.request.getParameterMap();
            String flag = null;
            Object o = parameters.get(key);
            if (o != null) {
                Object firstParam;
                if (o instanceof String) {
                    String string;
                    flag = string = (String)o;
                } else if (o.getClass().isArray() && (firstParam = ((Object[])o)[0]) instanceof String) {
                    String string;
                    flag = string = (String)firstParam;
                }
            }
            return Objects.equal((Object)"true", flag) || Objects.equal((Object)"on", flag);
        }
    }
}

