/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AkeylessSecretValue
extends AbstractDescribableImpl<AkeylessSecretValue> {
    private String envVar;
    private boolean isRequired = DescriptorImpl.DEFAULT_IS_REQUIRED;
    private final String secretKey;

    @DataBoundConstructor
    public AkeylessSecretValue(@NonNull String secretKey) {
        this.secretKey = Util.fixEmptyAndTrim((String)secretKey);
    }

    @DataBoundSetter
    public void setEnvVar(String envVar) {
        this.envVar = envVar;
    }

    @DataBoundSetter
    public void setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public String getEnvVar() {
        return StringUtils.isEmpty((String)this.envVar) ? this.secretKey : this.envVar;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean getIsRequired() {
        return this.isRequired;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AkeylessSecretValue> {
        public static final Boolean DEFAULT_IS_REQUIRED = true;

        public String getDisplayName() {
            return "Environment variable/vault secret value pair";
        }
    }
}

