/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless.model;

import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Saveable;
import hudson.util.FormValidation;
import io.jenkins.plugins.akeyless.model.AkeylessSecretBase;
import io.jenkins.plugins.akeyless.model.AkeylessSecretValue;
import java.util.List;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AkeylessSecret
extends AbstractDescribableImpl<AkeylessSecret>
implements AkeylessSecretBase {
    private final String path;
    private List<AkeylessSecretValue> secretValues;

    @DataBoundConstructor
    public AkeylessSecret(String path, List<AkeylessSecretValue> secretValues) {
        this.path = path;
        this.secretValues = secretValues;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public List<AkeylessSecretValue> getSecretValues() {
        return this.secretValues;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AkeylessSecret>
    implements Saveable {
        public String getDisplayName() {
            return "Akeyless Secret";
        }

        @POST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckPath(@AncestorInPath Item item, @QueryParameter String value) {
            if (item != null && !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.error((String)"You do not have permission to configure this item.");
            }
            if (!Strings.isNullOrEmpty((String)value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"This field can not be empty");
        }
    }
}

