/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import io.akeyless.client.model.Auth;
import io.jenkins.plugins.akeyless.credentials.AbstractAkeylessBaseStandardCredentials;
import io.jenkins.plugins.akeyless.credentials.AkeylessCredential;
import io.jenkins.plugins.akeyless.credentials.CredentialsPayload;
import javax.annotation.CheckForNull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AkeylessK8SCredentials
extends AbstractAkeylessBaseStandardCredentials
implements AkeylessCredential {
    @NonNull
    private String accessId = "";
    private String gatewayUrl;
    private String configName;
    private Secret serviceAccountToken;

    @DataBoundConstructor
    public AkeylessK8SCredentials(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description) {
        super(scope, id, description);
    }

    @NonNull
    public String getAccessId() {
        return this.accessId;
    }

    @DataBoundSetter
    public void setAccessId(@NonNull String accessId) {
        this.accessId = accessId;
    }

    @NonNull
    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    @DataBoundSetter
    public void setGatewayUrl(@NonNull String gatewayUrl) {
        this.gatewayUrl = gatewayUrl;
    }

    @NonNull
    public String getConfigName() {
        return this.configName;
    }

    @DataBoundSetter
    public void setConfigName(@NonNull String configName) {
        this.configName = configName;
    }

    @NonNull
    public Secret getServiceAccountToken() {
        return this.serviceAccountToken;
    }

    @DataBoundSetter
    public void setServiceAccountToken(@NonNull Secret serviceAccountToken) {
        this.serviceAccountToken = serviceAccountToken;
    }

    @Override
    public CredentialsPayload getCredentialsPayload() {
        CredentialsPayload payload = new CredentialsPayload();
        Auth auth = new Auth().accessType("k8s").accessId(this.accessId).gatewayUrl(this.gatewayUrl).k8sAuthConfigName(this.configName);
        if (this.serviceAccountToken != null) {
            auth.setK8sServiceAccountToken(this.serviceAccountToken.getPlainText());
        }
        payload.setAuth(auth);
        return payload;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Akeyless Kubernetes Credentials";
        }
    }
}

