/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless.credentials;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.properties.FolderCredentialsProvider;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import io.jenkins.plugins.akeyless.credentials.AbstractAkeylessBaseStandardCredentials;
import io.jenkins.plugins.akeyless.credentials.AkeylessCredential;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

@Extension(optional=true, ordinal=1.0)
public class AkeylessCredentialsProvider
extends CredentialsProvider {
    @Nonnull
    public <C extends Credentials> List<C> getCredentials(@Nonnull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
        return this.getCredentials(type, itemGroup, authentication, Collections.emptyList());
    }

    @Nonnull
    public <C extends Credentials> List<C> getCredentials(@Nonnull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @Nonnull List<DomainRequirement> domainRequirements) {
        CredentialsMatcher matcher = type != AkeylessCredential.class ? CredentialsMatchers.instanceOf(AbstractAkeylessBaseStandardCredentials.class) : CredentialsMatchers.always();
        ArrayList creds = new ArrayList();
        if (ACL.SYSTEM.equals(authentication)) {
            ItemGroup g = itemGroup;
            while (g instanceof AbstractFolder) {
                FolderCredentialsProvider.FolderCredentialsProperty property = (FolderCredentialsProvider.FolderCredentialsProperty)((AbstractFolder)g).getProperties().get(FolderCredentialsProvider.FolderCredentialsProperty.class);
                if (property != null) {
                    List folderCreds = DomainCredentials.getCredentials((Map)property.getDomainCredentialsMap(), type, domainRequirements, (CredentialsMatcher)matcher);
                    if (type != AkeylessCredential.class) {
                        for (Credentials c : folderCreds) {
                            ((AbstractAkeylessBaseStandardCredentials)c).setContext(g);
                        }
                    }
                    creds.addAll(folderCreds);
                }
                g = ((AbstractFolder)AbstractFolder.class.cast(g)).getParent();
            }
            List globalCreds = DomainCredentials.getCredentials((Map)SystemCredentialsProvider.getInstance().getDomainCredentialsMap(), type, domainRequirements, (CredentialsMatcher)matcher);
            if (type != AkeylessCredential.class) {
                for (Credentials c : globalCreds) {
                    ((AbstractAkeylessBaseStandardCredentials)c).setContext((ItemGroup)Jenkins.get());
                }
            }
            creds.addAll(globalCreds);
        }
        return creds;
    }
}

