/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import io.akeyless.client.model.Auth;
import io.jenkins.plugins.akeyless.credentials.AbstractAkeylessBaseStandardCredentials;
import io.jenkins.plugins.akeyless.credentials.AkeylessCredential;
import io.jenkins.plugins.akeyless.credentials.CredentialsPayload;
import javax.annotation.CheckForNull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AkeylessCertCredentials
extends AbstractAkeylessBaseStandardCredentials
implements AkeylessCredential {
    @NonNull
    private String accessId = "";
    @NonNull
    private String certificate = "";
    @NonNull
    private Secret privateKey = Secret.fromString((String)"");

    @DataBoundConstructor
    public AkeylessCertCredentials(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description) {
        super(scope, id, description);
    }

    @NonNull
    public String getAccessId() {
        return this.accessId;
    }

    @NonNull
    public String getCertificate() {
        return this.certificate;
    }

    @NonNull
    public Secret getPrivateKey() {
        return this.privateKey;
    }

    @DataBoundSetter
    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    @DataBoundSetter
    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    @DataBoundSetter
    public void setPrivateKey(Secret privateKey) {
        this.privateKey = privateKey;
    }

    public Auth getAuth() {
        Auth auth = new Auth();
        auth.setAccessId(this.accessId);
        auth.setAccessType("cert");
        auth.setCertData(this.certificate);
        auth.setKeyData(this.privateKey.getPlainText());
        return auth;
    }

    @Override
    public CredentialsPayload getCredentialsPayload() {
        CredentialsPayload payload = new CredentialsPayload();
        payload.setAuth(this.getAuth());
        return payload;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Akeyless Certificate";
        }
    }
}

