/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.akeyless.configuration;

import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.akeyless.credentials.AkeylessCredential;
import java.io.Serializable;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AkeylessConfiguration
extends AbstractDescribableImpl<AkeylessConfiguration>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_TIMEOUT = 60;
    private String akeylessUrl;
    private String akeylessCredentialId;
    private AkeylessCredential akeylessCredential;
    private Boolean disableChildPoliciesOverride;
    private String policies;
    private Boolean skipSslVerification = false;
    private Integer timeout = 60;

    @DataBoundConstructor
    public AkeylessConfiguration() {
    }

    public AkeylessConfiguration(AkeylessConfiguration toCopy) {
        this.akeylessUrl = toCopy.getAkeylessUrl();
        this.akeylessCredentialId = toCopy.getAkeylessCredentialId();
        this.akeylessCredential = toCopy.getAkeylessCredential();
        this.skipSslVerification = toCopy.skipSslVerification;
        this.policies = toCopy.policies;
        this.disableChildPoliciesOverride = toCopy.disableChildPoliciesOverride;
        this.timeout = toCopy.timeout;
    }

    public String getAkeylessUrl() {
        return this.akeylessUrl;
    }

    public String getAkeylessCredentialId() {
        return this.akeylessCredentialId;
    }

    @DataBoundSetter
    public void setAkeylessUrl(String akeylessUrl) {
        this.akeylessUrl = this.normalizeUrl(Util.fixEmptyAndTrim((String)akeylessUrl));
    }

    @DataBoundSetter
    public void setAkeylessCredentialId(String akeylessCredentialId) {
        this.akeylessCredentialId = Util.fixEmptyAndTrim((String)akeylessCredentialId);
    }

    public AkeylessCredential getAkeylessCredential() {
        return this.akeylessCredential;
    }

    @DataBoundSetter
    public void setAkeylessCredential(AkeylessCredential akeylessCredential) {
        this.akeylessCredential = akeylessCredential;
    }

    public AkeylessConfiguration mergeWithParent(AkeylessConfiguration parent) {
        if (parent == null) {
            return this;
        }
        AkeylessConfiguration result = new AkeylessConfiguration(this);
        if (StringUtils.isBlank((CharSequence)result.getAkeylessCredentialId())) {
            result.setAkeylessCredentialId(parent.getAkeylessCredentialId());
        }
        if (result.akeylessCredential == null) {
            result.setAkeylessCredential(parent.getAkeylessCredential());
        }
        if (StringUtils.isBlank((CharSequence)result.getAkeylessUrl())) {
            result.setAkeylessUrl(parent.getAkeylessUrl());
        }
        if (StringUtils.isBlank((CharSequence)result.getPolicies()) || parent.getDisableChildPoliciesOverride() != null && parent.getDisableChildPoliciesOverride().booleanValue()) {
            result.setPolicies(parent.getPolicies());
        }
        if (result.skipSslVerification == null) {
            result.setSkipSslVerification(parent.skipSslVerification);
        }
        if (result.timeout == null) {
            result.setTimeout(parent.getTimeout());
        }
        return result;
    }

    public Boolean getSkipSslVerification() {
        return this.skipSslVerification;
    }

    @DataBoundSetter
    public void setSkipSslVerification(Boolean skipSslVerification) {
        this.skipSslVerification = skipSslVerification;
    }

    public Boolean getDisableChildPoliciesOverride() {
        return this.disableChildPoliciesOverride;
    }

    @DataBoundSetter
    public void setDisableChildPoliciesOverride(Boolean disableChildPoliciesOverride) {
        this.disableChildPoliciesOverride = disableChildPoliciesOverride;
    }

    public String getPolicies() {
        return this.policies;
    }

    @DataBoundSetter
    public void setPolicies(String policies) {
        this.policies = Util.fixEmptyAndTrim((String)policies);
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    private String normalizeUrl(String url) {
        if (url == null) {
            return null;
        }
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AkeylessConfiguration> {
        public static final boolean DEFAULT_SKIP_SSL_VERIFICATION = false;

        @NonNull
        public String getDisplayName() {
            return "Akeyless Auth Method Configuration";
        }

        @POST
        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillAkeylessCredentialIdItems(@AncestorInPath Item item, @AncestorInPath Jenkins jenkins, @QueryParameter String uri) {
            AbstractIdCredentialsListBoxModel result = new StandardListBoxModel().includeEmptyValue();
            if (item != null) {
                if (!item.hasPermission(Item.CONFIGURE)) {
                    return result;
                }
            } else if (jenkins != null) {
                if (!jenkins.hasPermission(Jenkins.ADMINISTER)) {
                    return result;
                }
            } else {
                return result;
            }
            List domainRequirements = URIRequirementBuilder.fromUri((String)uri).build();
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, item, AkeylessCredential.class, domainRequirements);
        }
    }
}

