/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.createjobadvanced;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.maven.MavenModuleSet;
import hudson.maven.reporters.MavenMailer;
import hudson.model.Item;
import hudson.plugins.createjobadvanced.CreateJobAdvancedPlugin;
import hudson.plugins.createjobadvanced.JobConfigurer;

public final class MavenConfigurer
extends JobConfigurer {
    protected MavenConfigurer() {
    }

    @Override
    public final void doCreate(Item item) {
        log.finer("> " + this.getClass().getName() + ".onCreated()");
        super.doCreate(item);
        if (item instanceof MavenModuleSet) {
            MavenModuleSet mavenModuleSet = (MavenModuleSet)item;
            this.preConfigureMavenJob(mavenModuleSet);
        }
        log.finer("< " + this.getClass().getName() + ".onCreated()");
    }

    private final void preConfigureMavenJob(@Nullable MavenModuleSet mavenModuleSet) {
        CreateJobAdvancedPlugin cja = this.getPlugin();
        if (null != cja) {
            log.finer("> " + this.getClass().getName() + ".preConfigureMavenJob(MavenModuleSet)");
            mavenModuleSet.setIsArchivingDisabled(cja.isMvnArchivingDisabled());
            MavenMailer m = (MavenMailer)mavenModuleSet.getReporters().get(MavenMailer.class);
            if (m != null) {
                m.perModuleEmail = cja.isMvnPerModuleEmail();
            } else {
                mavenModuleSet.getReporters().add((Object)new MavenMailer(null, true, false, cja.isMvnPerModuleEmail()));
            }
            log.finer("< " + this.getClass().getName() + ".preConfigureMavenJob(MavenModuleSet)");
        }
    }
}

