/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.createjobadvanced;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.AbstractItem;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.plugins.createjobadvanced.CreateJobAdvancedPlugin;
import hudson.plugins.createjobadvanced.DynamicPermissionConfig;
import hudson.security.Permission;
import hudson.security.SecurityMode;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.matrixauth.PermissionEntry;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritParentStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;

public abstract class AbstractConfigurer<T extends AbstractItem, A> {
    protected static final Logger log = Logger.getLogger(CreateJobAdvancedPlugin.class.getName());

    protected void doCreate(Item item) {
        CreateJobAdvancedPlugin cja = this.getPlugin();
        if (null == cja) {
            return;
        }
        log.finest("> AbstractConfigurer.onCreated()");
        this.doRename(item);
        Jenkins jenkinsInstance = Hudson.getInstanceOrNull();
        if (jenkinsInstance == null || jenkinsInstance.getSecurity() == null || jenkinsInstance.getSecurity().equals((Object)SecurityMode.UNSECURED)) {
            log.warning("Jenkins security mode disabled.");
            log.finest("< AbstractConfigurer.onCreated()");
            return;
        }
        if (cja.isAutoOwnerRights()) {
            String sid = Hudson.getAuthentication2().getName();
            this.securityGrantPermissions(item, PermissionEntry.user((String)sid), new Permission[]{Item.CONFIGURE, Item.BUILD, Item.READ, Item.DELETE, Item.WORKSPACE});
        }
        if (cja.isAutoPublicBrowse()) {
            this.securityGrantPermissions(item, PermissionEntry.user((String)"anonymous"), new Permission[]{Item.READ, Item.WORKSPACE});
        }
        if (cja.isActiveDynamicPermissions()) {
            this.securityGrantDynamicPermissions(item, cja);
        }
        log.finest("< AbstractConfigurer.onCreated()");
    }

    protected final String doRename(Item item) {
        String resulString = item.getName();
        CreateJobAdvancedPlugin cja = this.getPlugin();
        if (null != cja && cja.isReplaceSpace() && item.getName().contains(" ")) {
            try {
                resulString = item.getName().replaceAll(" ", "-");
                this.renameJob(item, resulString);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "error during rename", e);
            }
        }
        return resulString;
    }

    protected final CreateJobAdvancedPlugin getPlugin() {
        CreateJobAdvancedPlugin result = null;
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (null != instance) {
            result = (CreateJobAdvancedPlugin)instance.getPlugin(CreateJobAdvancedPlugin.class);
        }
        return result;
    }

    private void securityGrantDynamicPermissions(Item item, CreateJobAdvancedPlugin cja) {
        Pattern pattern;
        Matcher matcher;
        boolean matchFound;
        String patternStr = cja.getExtractPattern();
        ArrayList<String> groupsList = new ArrayList<String>();
        if (patternStr != null && (matchFound = (matcher = (pattern = Pattern.compile(patternStr)).matcher(item.getName())).find())) {
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                String groupStr = matcher.group(i);
                log.log(Level.FINE, "groupStr: {0}", groupStr);
                groupsList.add(groupStr);
            }
        }
        for (DynamicPermissionConfig dpc : cja.getDynamicPermissionConfigs()) {
            MessageFormat format = new MessageFormat(dpc.getGroupFormat());
            String newName = format.format(groupsList.toArray(String[]::new));
            log.log(Level.FINEST, "add perms for group: {0}", newName);
            Set<String> permissions = dpc.getCheckedPermissionIds();
            ArrayList<Permission> permissionList = new ArrayList<Permission>();
            for (String id : permissions) {
                Permission permForId = Permission.fromId((String)id);
                permissionList.add(permForId);
            }
            this.securityGrantPermissions(item, PermissionEntry.group((String)newName), (Permission[])permissionList.toArray(Permission[]::new));
        }
    }

    protected final void securityGrantPermissions(Item item, PermissionEntry permEnt, Permission[] jenkinsPermissions) {
        Map<Permission, Set<PermissionEntry>> permissions = this.initPermissions(item);
        for (Permission perm : jenkinsPermissions) {
            this.configurePermission(permissions, perm, permEnt);
        }
        try {
            A authProperty = this.setupAuthorizationMatrixProperty(permissions);
            this.addAuthorizationMatrixProperty(item, authProperty);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "problem to add granted permissions", e);
        }
    }

    @NonNull
    protected final Map<Permission, Set<PermissionEntry>> initPermissions(@Nullable Item item) {
        A auth = this.getAuthorizationMatrixProperty(item);
        Map<Permission, Set<PermissionEntry>> permissions = this.getGrantedPermissionEntries(auth);
        this.removeProperty(item, auth);
        return permissions;
    }

    protected final void configurePermission(Map<Permission, Set<PermissionEntry>> permissions, Permission permission, PermissionEntry permissionEntry) {
        Set<PermissionEntry> sidPermissionSet = permissions.get(permission);
        if (sidPermissionSet == null) {
            HashSet<PermissionEntry> sidSet = new HashSet<PermissionEntry>();
            sidSet.add(permissionEntry);
            permissions.put(permission, sidSet);
        } else if (!sidPermissionSet.contains(permissionEntry)) {
            sidPermissionSet.add(permissionEntry);
        }
    }

    protected final A setupAuthorizationMatrixProperty(Map<Permission, Set<PermissionEntry>> permissions) throws IOException {
        A authProperty = this.createAuthorizationMatrixProperty();
        this.setInheritanceStrategy(authProperty, (InheritanceStrategy)new InheritParentStrategy());
        for (Map.Entry<Permission, Set<PermissionEntry>> entry : permissions.entrySet()) {
            Permission perm = entry.getKey();
            for (PermissionEntry permEntry : entry.getValue()) {
                if (null != perm && null != permEntry && this.showPermission(perm)) {
                    this.addPermission(authProperty, perm, permEntry);
                    continue;
                }
                if (null != perm) {
                    log.log(Level.FINER, ": {0}skip hidden permissions {1}", new Object[]{this.getClass().getName(), perm.name});
                } else {
                    log.log(Level.FINER, ": {0}skip null permission", this.getClass().getName());
                }
                if (null != permEntry) continue;
                log.log(Level.FINER, ": {0}skip null permission entry", this.getClass().getName());
            }
        }
        return authProperty;
    }

    protected abstract void setInheritanceStrategy(@Nullable A var1, @Nullable InheritanceStrategy var2);

    protected abstract void addPermission(@Nullable A var1, @Nullable Permission var2, @Nullable PermissionEntry var3);

    protected abstract boolean showPermission(@Nullable Permission var1);

    protected abstract void addAuthorizationMatrixProperty(@Nullable Item var1, @Nullable A var2) throws IOException;

    protected abstract void renameJob(@Nullable Item var1, @Nullable String var2) throws IOException;

    @Nullable
    protected abstract A createAuthorizationMatrixProperty();

    @Nullable
    protected abstract A getAuthorizationMatrixProperty(@Nullable Item var1);

    protected abstract void removeProperty(@Nullable Item var1, @Nullable A var2);

    @NonNull
    protected abstract Map<Permission, Set<PermissionEntry>> getGrantedPermissionEntries(@Nullable A var1);
}

