/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins.validation;

import com.mabl.integration.jenkins.MablRestApiClient;
import com.mabl.integration.jenkins.MablStepBuilder;
import com.mabl.integration.jenkins.domain.CreateDeploymentProperties;
import com.mabl.integration.jenkins.domain.CreateDeploymentResult;
import com.mabl.integration.jenkins.domain.ExecutionResult;
import com.mabl.integration.jenkins.domain.GetApiKeyResult;
import com.mabl.integration.jenkins.domain.GetApplicationsResult;
import com.mabl.integration.jenkins.domain.GetEnvironmentsResult;
import com.mabl.integration.jenkins.domain.GetLabelsResult;
import com.mabl.integration.jenkins.validation.MablStepBuilderValidator;
import hudson.util.FormValidation;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class MablBuildValidatorTest {
    @Test
    public void validateGoodAllFieldsForm() {
        try (MockedStatic mocked = Mockito.mockStatic(MablStepBuilder.class);){
            this.mockNoopRestApiClient((MockedStatic<MablStepBuilder>)mocked);
            FormValidation actual = MablStepBuilderValidator.validateForm((String)"sample-key-id", (String)"sample-environment-id", (String)"sample-application-id");
            Assert.assertEquals((Object)actual.kind, (Object)FormValidation.Kind.OK);
        }
    }

    @Test
    public void validateGoodEnvironmentOnlyForm() {
        try (MockedStatic mocked = Mockito.mockStatic(MablStepBuilder.class);){
            this.mockNoopRestApiClient((MockedStatic<MablStepBuilder>)mocked);
            FormValidation actual = MablStepBuilderValidator.validateForm((String)"sample-key-id", (String)"sample-environment-id", null);
            Assert.assertEquals((Object)actual.kind, (Object)FormValidation.Kind.OK);
        }
    }

    @Test
    public void validateGoodApplicationOnlyForm() {
        try (MockedStatic mocked = Mockito.mockStatic(MablStepBuilder.class);){
            this.mockNoopRestApiClient((MockedStatic<MablStepBuilder>)mocked);
            FormValidation actual = MablStepBuilderValidator.validateForm((String)"sample-key-id", null, (String)"sample-application-id");
            Assert.assertEquals((Object)actual.kind, (Object)FormValidation.Kind.OK);
        }
    }

    @Test
    public void validateBadNoEnvironmentOrApplicationForm() {
        FormValidation actual = MablStepBuilderValidator.validateForm((String)"sample-key-id", null, null);
        Assert.assertEquals((Object)FormValidation.Kind.ERROR, (Object)actual.kind);
        Assert.assertTrue((String)"application label expected", (boolean)actual.getMessage().contains("Environment ID"));
        Assert.assertTrue((String)"environment label expected", (boolean)actual.getMessage().contains("Application ID"));
    }

    @Test
    public void validateBadNoEnvironmentIdInWrongFieldApplicationForm() {
        FormValidation actual = MablStepBuilderValidator.validateForm((String)"sample-key-id", (String)"sample-a", null);
        Assert.assertEquals((Object)FormValidation.Kind.ERROR, (Object)actual.kind);
        Assert.assertTrue((String)"application label expected", (boolean)actual.getMessage().contains("Environment ID"));
        Assert.assertTrue((String)"environment label expected", (boolean)actual.getMessage().contains("Application ID"));
    }

    @Test
    public void validateBadNoApplicationIdInWrongFieldApplicationForm() {
        FormValidation actual = MablStepBuilderValidator.validateForm((String)"sample-key-id", null, (String)"sample-e");
        Assert.assertEquals((Object)FormValidation.Kind.ERROR, (Object)actual.kind);
        Assert.assertTrue((String)"application label expected", (boolean)actual.getMessage().contains("Environment ID"));
        Assert.assertTrue((String)"environment label expected", (boolean)actual.getMessage().contains("Application ID"));
    }

    @Test
    public void validateBadNoEnvironmentOrApplicationWhiteSpaceForm() {
        FormValidation actual = MablStepBuilderValidator.validateForm((String)"sample-key-id", (String)"  ", (String)"\t");
        Assert.assertEquals((Object)FormValidation.Kind.ERROR, (Object)actual.kind);
        Assert.assertTrue((String)"application label expected", (boolean)actual.getMessage().contains("Environment ID"));
        Assert.assertTrue((String)"environment label expected", (boolean)actual.getMessage().contains("Application ID"));
    }

    @Test
    public void validateBadNoRestApiKeyForm() {
        FormValidation actual = MablStepBuilderValidator.validateForm(null, null, null);
        Assert.assertEquals((Object)FormValidation.Kind.ERROR, (Object)actual.kind);
        Assert.assertTrue((String)"rest API key label expected", (boolean)actual.getMessage().contains("API Key"));
    }

    @Test
    public void validateBadRestApiKey() {
        FormValidation actual = MablStepBuilderValidator.validateForm((String)"key:invalid-key", null, null);
        Assert.assertEquals((Object)FormValidation.Kind.ERROR, (Object)actual.kind);
        Assert.assertTrue((String)"rest API key label expected", (boolean)actual.getMessage().contains("API Key"));
    }

    private void mockNoopRestApiClient(MockedStatic<MablStepBuilder> mocked) {
        mocked.when(() -> MablStepBuilder.createMablRestApiClient((String)"sample-key-id", (boolean)false, (String)"https://api.mabl.com", (String)"https://app.mabl.com")).thenReturn((Object)new MablRestApiClient(){

            public CreateDeploymentResult createDeploymentEvent(String environmentId, String applicationId, String labels, String mablBranch, CreateDeploymentProperties properties) throws IOException {
                return null;
            }

            public ExecutionResult getExecutionResults(String eventId) throws IOException {
                return null;
            }

            public GetApiKeyResult getApiKeyResult() throws IOException {
                return null;
            }

            public GetApplicationsResult getApplicationsResult(String organizationId) throws IOException {
                return null;
            }

            public GetEnvironmentsResult getEnvironmentsResult(String organizationId) throws IOException {
                return null;
            }

            public GetLabelsResult getLabelsResult(String organizationId) throws IOException {
                return null;
            }

            public String getAppBaseUrl() {
                return null;
            }

            public void checkConnection() throws IOException {
            }

            public void close() {
            }
        });
    }
}

