/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.mabl.integration.jenkins.test.output.Failure;
import com.mabl.integration.jenkins.test.output.Properties;
import com.mabl.integration.jenkins.test.output.Property;
import com.mabl.integration.jenkins.test.output.Skipped;
import com.mabl.integration.jenkins.test.output.TestCase;
import com.mabl.integration.jenkins.test.output.TestSuite;
import com.mabl.integration.jenkins.test.output.TestSuites;
import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOutputTests {
    private XStream xstream;

    @Before
    public void configureXStream() {
        this.xstream = new XStream();
        this.xstream.processAnnotations(Failure.class);
        this.xstream.processAnnotations(Properties.class);
        this.xstream.processAnnotations(Property.class);
        this.xstream.processAnnotations(Skipped.class);
        this.xstream.processAnnotations(TestCase.class);
        this.xstream.processAnnotations(TestSuite.class);
        this.xstream.processAnnotations(TestSuites.class);
    }

    @Test
    public void testTestCaseOutputNoFailure() {
        TestCase testCase = new TestCase("My Plan Name", "My Test Name", 23L, "http://myapphref.com");
        String xml = this.xstream.toXML((Object)testCase);
        Assert.assertEquals((Object)"<testcase classname=\"My Plan Name\" name=\"My Test Name\" time=\"23\" xlink:type=\"simple\" xlink:href=\"http://myapphref.com\"/>", (Object)xml);
    }

    @Test
    public void testTestCaseOutputWithFailure() {
        Failure failure = new Failure("My Reason", "My Message");
        TestCase testCase = new TestCase("My Plan Name", "My Test Name", 23L, "http://myapphref.com", failure);
        String xml = this.xstream.toXML((Object)testCase);
        Assert.assertEquals((Object)"<testcase classname=\"My Plan Name\" name=\"My Test Name\" time=\"23\" xlink:type=\"simple\" xlink:href=\"http://myapphref.com\">\n  <failure message=\"My Message\">My Reason</failure>\n</testcase>", (Object)xml);
    }

    @Test
    public void testEntireTestSuite() {
        TestSuite emptyTestSuite = new TestSuite("Empty Test Suite", 0L, "2013-05-24T10:23:58", new Properties());
        Property property1 = new Property("environment", "my env-e");
        Property property2 = new Property("application", "my app-a");
        ArrayList<Property> props = new ArrayList<Property>();
        props.add(property1);
        props.add(property2);
        Properties properties = new Properties((List)ImmutableList.copyOf(props));
        TestCase testCase1 = new TestCase("My Plan Name 1", "My Test Name 1", 11L, "http://myapphref.com");
        Failure failure = new Failure("My Reason", "My Message");
        TestCase testCase2 = new TestCase("My Plan Name 2", "My Test Name 2", 22L, "http://myapphref.com", failure);
        TestSuite testSuite1 = new TestSuite("Full Test Suite", 33L, "2013-05-24T10:23:58", properties);
        testSuite1.addToTestCases(testCase1);
        testSuite1.incrementTests();
        testSuite1.addToTestCases(testCase2);
        testSuite1.incrementTests();
        testSuite1.incrementFailures();
        ArrayList<TestSuite> suites = new ArrayList<TestSuite>();
        suites.add(emptyTestSuite);
        suites.add(testSuite1);
        TestSuites testSuites = new TestSuites((ImmutableCollection)ImmutableList.copyOf(suites));
        String xml = this.xstream.toXML((Object)testSuites);
        Assert.assertEquals((Object)"<testsuites xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n  <testsuite name=\"Empty Test Suite\" tests=\"0\" errors=\"0\" failures=\"0\" skipped=\"0\" time=\"0\" timestamp=\"2013-05-24T10:23:58\">\n    <properties/>\n  </testsuite>\n  <testsuite name=\"Full Test Suite\" tests=\"2\" errors=\"0\" failures=\"1\" skipped=\"0\" time=\"33\" timestamp=\"2013-05-24T10:23:58\">\n    <properties>\n      <property name=\"environment\" value=\"my env-e\"/>\n      <property name=\"application\" value=\"my app-a\"/>\n    </properties>\n    <testcase classname=\"My Plan Name 1\" name=\"My Test Name 1\" time=\"11\" xlink:type=\"simple\" xlink:href=\"http://myapphref.com\"/>\n    <testcase classname=\"My Plan Name 2\" name=\"My Test Name 2\" time=\"22\" xlink:type=\"simple\" xlink:href=\"http://myapphref.com\">\n      <failure message=\"My Message\">My Reason</failure>\n    </testcase>\n  </testsuite>\n</testsuites>", (Object)xml);
    }
}

