/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.mabl.integration.jenkins.MablStepBuilder;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.Permission;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class MablStepDescriptorTest {
    private MablStepBuilder.MablStepDescriptor mablStepDescriptor;

    @Before
    public void setup() {
        this.mablStepDescriptor = (MablStepBuilder.MablStepDescriptor)Mockito.mock(MablStepBuilder.MablStepDescriptor.class);
        ((MablStepBuilder.MablStepDescriptor)Mockito.doNothing().when((Object)this.mablStepDescriptor)).load();
    }

    @Test
    public void testCheckRestApiKeyIds_Blank() {
        AbstractItem item = new AbstractItem(null, "testItem"){

            public Collection<? extends Job> getAllJobs() {
                return null;
            }

            public boolean hasPermission(Permission permission) {
                return EXTENDED_READ.equals((Object)permission);
            }
        };
        Mockito.when((Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, null)).thenCallRealMethod();
        Assert.assertNotEquals((Object)FormValidation.ok(), (Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, null));
        Mockito.when((Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, "")).thenCallRealMethod();
        Assert.assertNotEquals((Object)FormValidation.ok(), (Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, ""));
    }

    @Test
    public void testCheckRestApiKeyIds_ExtendedRead() {
        AbstractItem item = new AbstractItem(null, "testItem"){

            public Collection<? extends Job> getAllJobs() {
                return null;
            }

            public boolean hasPermission(Permission permission) {
                return EXTENDED_READ.equals((Object)permission);
            }
        };
        Mockito.when((Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, "an-api-key")).thenCallRealMethod();
        Assert.assertEquals((Object)FormValidation.ok(), (Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, "an-api-key"));
    }

    @Test
    public void testCheckRestApiKeyIds_UseItem() {
        AbstractItem item = new AbstractItem(null, "testItem"){

            public Collection<? extends Job> getAllJobs() {
                return null;
            }

            public boolean hasPermission(Permission permission) {
                return CredentialsProvider.USE_ITEM.equals((Object)permission);
            }
        };
        Mockito.when((Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, "an-api-key")).thenCallRealMethod();
        Assert.assertEquals((Object)FormValidation.ok(), (Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, "an-api-key"));
    }

    @Test
    public void testCheckRestApiKeyIds_InsufficentPermissions() {
        AbstractItem item = new AbstractItem(null, "testItem"){

            public Collection<? extends Job> getAllJobs() {
                return null;
            }

            public boolean hasPermission(Permission permission) {
                return false;
            }
        };
        Mockito.when((Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, "an-api-key")).thenCallRealMethod();
        Assert.assertNotEquals((Object)FormValidation.ok(), (Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, "an-api-key"));
    }

    @Test
    public void testCheckRestApiKeyIds_ExpressionBasedCreds() {
        AbstractItem item = new AbstractItem(null, "testItem"){

            public Collection<? extends Job> getAllJobs() {
                return null;
            }

            public boolean hasPermission(Permission permission) {
                return true;
            }
        };
        Mockito.when((Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, "${invalidName}")).thenCallRealMethod();
        Assert.assertNotEquals((Object)FormValidation.ok(), (Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, "${invalidName}"));
        Mockito.when((Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, "${couldBeValid")).thenCallRealMethod();
        Assert.assertEquals((Object)FormValidation.ok(), (Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, "${couldBeValid"));
    }

    @Test
    public void testCheckMablBranch_Valid() {
        Mockito.when((Object)this.mablStepDescriptor.doCheckMablBranch(null)).thenCallRealMethod();
        Assert.assertEquals((Object)FormValidation.ok(), (Object)this.mablStepDescriptor.doCheckMablBranch(null));
        Mockito.when((Object)this.mablStepDescriptor.doCheckMablBranch("")).thenCallRealMethod();
        Assert.assertEquals((Object)FormValidation.ok(), (Object)this.mablStepDescriptor.doCheckMablBranch(""));
        Mockito.when((Object)this.mablStepDescriptor.doCheckMablBranch("A_Valid_Branch-Name")).thenCallRealMethod();
        Assert.assertEquals((Object)FormValidation.ok(), (Object)this.mablStepDescriptor.doCheckMablBranch("A_Valid_Branch-Name"));
    }

    @Test
    public void testCheckMablBranch_InValid() {
        Mockito.when((Object)this.mablStepDescriptor.doCheckMablBranch("Br@nch1nv@l1d")).thenCallRealMethod();
        Assert.assertNotEquals((Object)FormValidation.ok(), (Object)this.mablStepDescriptor.doCheckMablBranch("Br@nch1nv@l1d"));
    }

    @Test
    public void testDoFillApplicationIdItems_NoApiKey() {
        Mockito.when((Object)this.mablStepDescriptor.doFillApplicationIdItems(null, false, "https://api.mabl.com", "https://app.mabl.com")).thenCallRealMethod();
        ListBoxModel model = this.mablStepDescriptor.doFillApplicationIdItems(null, false, "https://api.mabl.com", "https://app.mabl.com");
        Assert.assertEquals((long)1L, (long)model.size());
        Assert.assertEquals((Object)"Select a valid API key", (Object)((ListBoxModel.Option)model.iterator().next()).value);
        Mockito.when((Object)this.mablStepDescriptor.doFillApplicationIdItems("", false, "https://api.mabl.com", "https://app.mabl.com")).thenCallRealMethod();
        model = this.mablStepDescriptor.doFillApplicationIdItems("", false, "https://api.mabl.com", "https://app.mabl.com");
        Assert.assertEquals((long)1L, (long)model.size());
        Assert.assertEquals((Object)"Select a valid API key", (Object)((ListBoxModel.Option)model.iterator().next()).value);
    }

    @Test
    public void testDoFillApplicationIdItems_NoSecret() {
        Mockito.when((Object)this.mablStepDescriptor.doFillApplicationIdItems("invalid-key", false, "https://api.mabl.com", "https://app.mabl.com")).thenCallRealMethod();
        try (MockedStatic mocked = Mockito.mockStatic(MablStepBuilder.class);){
            mocked.when(() -> MablStepBuilder.getRestApiSecret((String)"invalid-key")).thenReturn(null);
            ListBoxModel model = this.mablStepDescriptor.doFillApplicationIdItems("invalid-key", false, "https://api.mabl.com", "https://app.mabl.com");
            Assert.assertEquals((long)0L, (long)model.size());
        }
    }

    @Test
    public void testDoFillEnvironmentIdItems_NoApiKey() {
        Mockito.when((Object)this.mablStepDescriptor.doFillEnvironmentIdItems(null, false, "https://api.mabl.com", "https://app.mabl.com")).thenCallRealMethod();
        ListBoxModel model = this.mablStepDescriptor.doFillEnvironmentIdItems(null, false, "https://api.mabl.com", "https://app.mabl.com");
        Assert.assertEquals((long)1L, (long)model.size());
        Assert.assertEquals((Object)"Select a valid API key", (Object)((ListBoxModel.Option)model.iterator().next()).value);
        Mockito.when((Object)this.mablStepDescriptor.doFillEnvironmentIdItems("", false, "https://api.mabl.com", "https://app.mabl.com")).thenCallRealMethod();
        model = this.mablStepDescriptor.doFillEnvironmentIdItems("", false, "https://api.mabl.com", "https://app.mabl.com");
        Assert.assertEquals((long)1L, (long)model.size());
        Assert.assertEquals((Object)"Select a valid API key", (Object)((ListBoxModel.Option)model.iterator().next()).value);
    }

    @Test
    public void testDoFillEnvironmentIdItems_NoSecret() {
        Mockito.when((Object)this.mablStepDescriptor.doFillEnvironmentIdItems("invalid-key", false, "https://api.mabl.com", "https://app.mabl.com")).thenCallRealMethod();
        try (MockedStatic mocked = Mockito.mockStatic(MablStepBuilder.class);){
            mocked.when(() -> MablStepBuilder.getRestApiSecret((String)"invalid-key")).thenReturn(null);
            ListBoxModel model = this.mablStepDescriptor.doFillEnvironmentIdItems("invalid-key", false, "https://api.mabl.com", "https://app.mabl.com");
            Assert.assertEquals((long)0L, (long)model.size());
        }
    }

    @Test
    public void testProxyCredentialsIds_Blank() {
        AbstractItem item = new AbstractItem(null, "testItem"){

            public Collection<? extends Job> getAllJobs() {
                return null;
            }

            public boolean hasPermission(Permission permission) {
                return EXTENDED_READ.equals((Object)permission);
            }
        };
        Mockito.when((Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, null)).thenCallRealMethod();
        Assert.assertNotEquals((Object)FormValidation.ok(), (Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, null));
        Mockito.when((Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, "")).thenCallRealMethod();
        Assert.assertNotEquals((Object)FormValidation.ok(), (Object)this.mablStepDescriptor.doCheckRestApiKeyIds((Item)item, ""));
    }
}

