/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockClassRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.mabl.integration.jenkins.MablStepConstants;
import java.util.HashMap;
import java.util.Map;
import org.junit.ClassRule;
import org.junit.Rule;

public abstract class AbstractWiremockTest {
    private static final int BIND_PORT = 0;
    @ClassRule
    public static WireMockClassRule wireMockRule = new WireMockClassRule(0);
    @Rule
    public WireMockClassRule instanceRule = wireMockRule;
    private Map<String, String> expectedUrls = new HashMap<String, String>();

    protected String registerPostMapping(String path, String jsonResponse, String expectedUsername, String expectedPassword, String expectedBody) {
        String mappedUrl = this.generatePageUrl(path);
        this.expectedUrls.put(path, "POST");
        MappingBuilder mappingBuilder = WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)path)).willReturn(WireMock.created().withHeader("Content-Type", new String[]{"application/json"}).withBody(jsonResponse));
        mappingBuilder.withBasicAuth(expectedUsername, expectedPassword);
        mappingBuilder.withHeader("user-agent", (StringValuePattern)new EqualToPattern(MablStepConstants.PLUGIN_USER_AGENT));
        mappingBuilder.withHeader("Content-Type", (StringValuePattern)new EqualToPattern("application/json"));
        mappingBuilder.withRequestBody((ContentPattern)new EqualToPattern(expectedBody));
        WireMock.stubFor((MappingBuilder)mappingBuilder);
        return mappedUrl;
    }

    protected String registerGetMapping(String path, ResponseDefinitionBuilder responseBuilder, String jsonResponse, String expectedUsername, String expectedPassword) {
        String mappedUrl = this.generatePageUrl(path);
        this.expectedUrls.put(path, "GET");
        MappingBuilder mappingBuilder = WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)path)).willReturn(responseBuilder.withHeader("Content-Type", new String[]{"application/json"}).withBody(jsonResponse));
        mappingBuilder.withBasicAuth(expectedUsername, expectedPassword);
        mappingBuilder.withHeader("user-agent", (StringValuePattern)new EqualToPattern(MablStepConstants.PLUGIN_USER_AGENT));
        WireMock.stubFor((MappingBuilder)mappingBuilder);
        return mappedUrl;
    }

    protected String registerGetMappingWithFile(String path, ResponseDefinitionBuilder responseBuilder, String jsonResponseFile, String expectedUsername, String expectedPassword) {
        String mappedUrl = this.generatePageUrl(path);
        this.expectedUrls.put(path, "GET");
        MappingBuilder mappingBuilder = WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)path)).willReturn(responseBuilder.withHeader("Content-Type", new String[]{"application/json"}).withBodyFile(jsonResponseFile));
        mappingBuilder.withBasicAuth(expectedUsername, expectedPassword);
        mappingBuilder.withHeader("user-agent", (StringValuePattern)new EqualToPattern(MablStepConstants.PLUGIN_USER_AGENT));
        WireMock.stubFor((MappingBuilder)mappingBuilder);
        return mappedUrl;
    }

    protected void verifyExpectedUrls() {
        for (Map.Entry<String, String> expectedUrlEntry : this.expectedUrls.entrySet()) {
            String method = expectedUrlEntry.getValue();
            String url = expectedUrlEntry.getKey();
            RequestPatternBuilder builder = null;
            if ("GET".equals(method)) {
                builder = WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)url));
            } else if ("POST".equals(method)) {
                builder = WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)url));
            }
            WireMock.verify((RequestPatternBuilder)builder);
        }
    }

    private String generatePageUrl(String path) {
        return this.getBaseUrl() + path;
    }

    protected String getBaseUrl() {
        int portNumber = wireMockRule.port();
        String address = wireMockRule.getOptions().bindAddress();
        return String.format("http://%s:%d", address, portNumber);
    }
}

