/*
 * Decompiled with CFR 0.152.
 */
package tech.andrey.jenkins.missioncontrol;

import hudson.Extension;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.security.Permission;
import hudson.util.RunList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import tech.andrey.jenkins.missioncontrol.Messages;

@ExportedBean
public class MissionControlView
extends View {
    private transient int getBuildsLimit;
    private int fontSize = 16;
    private int buildQueueSize = 10;
    private int buildHistorySize = 16;
    private boolean useCondensedTables = false;
    private String statusButtonSize = "";
    private String layoutHeightRatio = "6040";
    private String filterRegex = null;

    @DataBoundConstructor
    public MissionControlView(String name) {
        super(name);
    }

    protected Object readResolve() {
        if (this.getBuildsLimit == 0) {
            this.getBuildsLimit = 250;
        }
        if (this.fontSize == 0) {
            this.fontSize = 16;
        }
        if (this.buildHistorySize == 0) {
            this.buildHistorySize = 16;
        }
        if (this.buildQueueSize == 0) {
            this.buildQueueSize = 10;
        }
        if (this.statusButtonSize == null) {
            this.statusButtonSize = "";
        }
        if (this.layoutHeightRatio == null) {
            this.layoutHeightRatio = "6040";
        }
        return this;
    }

    public Collection<TopLevelItem> getItems() {
        return new ArrayList<TopLevelItem>();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getBuildHistorySize() {
        return this.buildHistorySize;
    }

    public int getBuildQueueSize() {
        return this.buildQueueSize;
    }

    public boolean isUseCondensedTables() {
        return this.useCondensedTables;
    }

    public String getTableStyle() {
        return this.useCondensedTables ? "table-condensed" : "";
    }

    public String getStatusButtonSize() {
        return this.statusButtonSize;
    }

    public String getLayoutHeightRatio() {
        return this.layoutHeightRatio;
    }

    public String getFilterRegex() {
        return this.filterRegex;
    }

    public String getTopHalfHeight() {
        return this.layoutHeightRatio.substring(0, 2);
    }

    public String getBottomHalfHeight() {
        return this.layoutHeightRatio.substring(2, 4);
    }

    protected void submit(StaplerRequest req) throws ServletException, IOException {
        JSONObject json = req.getSubmittedForm();
        this.fontSize = json.getInt("fontSize");
        this.buildHistorySize = json.getInt("buildHistorySize");
        this.buildQueueSize = json.getInt("buildQueueSize");
        this.useCondensedTables = json.getBoolean("useCondensedTables");
        if (json.get("useRegexFilter") != null) {
            String regexToTest = req.getParameter("filterRegex");
            try {
                Pattern.compile(regexToTest);
                this.filterRegex = regexToTest;
            }
            catch (PatternSyntaxException x) {
                Logger.getLogger(ListView.class.getName()).log(Level.WARNING, "Regex filter expression is invalid", x);
            }
        } else {
            this.filterRegex = null;
        }
        this.statusButtonSize = json.getString("statusButtonSize");
        this.layoutHeightRatio = json.getString("layoutHeightRatio");
        this.save();
    }

    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public boolean contains(TopLevelItem item) {
        return false;
    }

    public boolean hasPermission(Permission p) {
        return true;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    @Exported(name="builds")
    public Collection<Build> getBuildHistory() {
        ArrayList<Build> l = new ArrayList<Build>();
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            return l;
        }
        List jobs = instance.getAllItems(Job.class);
        RunList builds = new RunList((Collection)jobs).limit(this.getBuildsLimit);
        Pattern r = this.filterRegex != null ? Pattern.compile(this.filterRegex) : null;
        for (Object b : builds) {
            Run build = (Run)b;
            Job job = build.getParent();
            if (job.getClass().getName().equals("hudson.maven.MavenModule") || r != null && !r.matcher(job.getName()).find()) continue;
            Result result = build.getResult();
            l.add(new Build(job.getName(), build.getFullDisplayName(), build.getNumber(), build.getStartTimeInMillis(), build.getDuration(), result == null ? "BUILDING" : result.toString()));
        }
        return l;
    }

    @Exported(name="allJobsStatuses")
    public Collection<JobStatus> getAllJobsStatuses() {
        ArrayList<JobStatus> statuses = new ArrayList<JobStatus>();
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            return statuses;
        }
        Pattern r = this.filterRegex != null ? Pattern.compile(this.filterRegex) : null;
        List jobs = instance.getAllItems(Job.class);
        for (Job j : jobs) {
            Result res;
            Run lb;
            if (j.getClass().getName().equals("hudson.matrix.MatrixConfiguration") || j.getClass().getName().equals("hudson.maven.MavenModule") || r != null && !r.matcher(j.getName()).find()) continue;
            String status = j.isBuilding() ? "BUILDING" : (!j.isBuildable() ? "DISABLED" : ((lb = j.getLastBuild()) == null ? "NOTBUILT" : ((res = lb.getResult()) == null ? "UNKNOWN" : res.toString())));
            statuses.add(new JobStatus(j.getFullName(), status));
        }
        return statuses;
    }

    @ExportedBean(defaultVisibility=999)
    public static class JobStatus {
        @Exported
        public String jobName;
        @Exported
        public String status;

        public JobStatus(String jobName, String status) {
            this.jobName = jobName;
            this.status = status;
        }
    }

    @ExportedBean(defaultVisibility=999)
    public static class Build {
        @Exported
        public String jobName;
        @Exported
        public String buildName;
        @Exported
        public int number;
        @Exported
        public long startTime;
        @Exported
        public long duration;
        @Exported
        public String result;

        public Build(String jobName, String buildName, int number, long startTime, long duration, String result) {
            this.jobName = jobName;
            this.buildName = buildName;
            this.number = number;
            this.startTime = startTime;
            this.duration = duration;
            this.result = result;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends ViewDescriptor {
        public String getDisplayName() {
            return Messages.MissionControlView_DisplayName();
        }
    }
}

