/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins.config;

import hudson.model.Result;
import hudson.model.Run;
import ru.yandex.qatools.allure.jenkins.config.ReportBuildPolicyDecision;

public enum ReportBuildPolicy {
    ALWAYS("For all builds", run -> true),
    UNSTABLE("For all unstable builds", run -> run != null && Result.UNSTABLE.equals(run.getResult())),
    UNSUCCESSFUL("For unsuccessful builds", new ReportBuildPolicyDecision(){

        @Override
        public boolean isNeedToBuildReport(Run run) {
            return run != null && this.isUnsuccessful(run.getResult());
        }

        private boolean isUnsuccessful(Result result) {
            return Result.UNSTABLE.equals(result) || Result.FAILURE.equals(result);
        }
    });

    private final String title;
    private final ReportBuildPolicyDecision decision;

    private ReportBuildPolicy(String title, ReportBuildPolicyDecision decision) {
        this.decision = decision;
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getValue() {
        return this.name();
    }

    public boolean isNeedToBuildReport(Run run) {
        return this.decision.isNeedToBuildReport(run);
    }
}

