/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins.callables;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import jenkins.MasterToSlaveFileCallable;
import ru.yandex.qatools.allure.jenkins.utils.TrueZipArchiver;

public class AllureReportArchive
extends MasterToSlaveFileCallable<Void> {
    private static final long serialVersionUID = 1L;
    public static final String REPORT_DIRECTORY_NOT_FOUND = "Allure report directory not found: ";
    private final String reportDirectoryPath;
    private final String archiveFileName;

    public AllureReportArchive(String reportDirectoryPath, String archiveFileName) {
        this.reportDirectoryPath = reportDirectoryPath;
        this.archiveFileName = archiveFileName;
    }

    public Void invoke(File workspaceDirectory, VirtualChannel channel) throws IOException, InterruptedException {
        FilePath workspace = new FilePath(workspaceDirectory);
        FilePath reportDirectory = workspace.child(this.reportDirectoryPath);
        if (!reportDirectory.exists()) {
            throw new IOException(REPORT_DIRECTORY_NOT_FOUND + reportDirectory.getRemote());
        }
        FilePath archiveFilePath = workspace.child(this.archiveFileName);
        if (archiveFilePath.exists()) {
            archiveFilePath.delete();
        }
        FilePath reportParentDirectory = reportDirectory.getParent();
        try (OutputStream outputStream = archiveFilePath.write();){
            Objects.requireNonNull(reportParentDirectory).archive(TrueZipArchiver.FACTORY, outputStream, reportDirectory.getName() + "/**");
        }
        return null;
    }
}

