/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.jenkins.plugins.debuilder;

import hudson.remoting.Callable;
import hudson.scm.SubversionSCM;
import hudson.scm.SvnClientManager;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import ru.yandex.jenkins.plugins.debuilder.DebianizingException;

public class SVNCommitHelper
implements Serializable,
Callable<String, DebianizingException> {
    private static final long serialVersionUID = 1L;
    private final ISVNAuthenticationProvider provider;
    private final String path;
    private final String commitMessage;

    public SVNCommitHelper(ISVNAuthenticationProvider provider, String path, String commitMessage) {
        this.provider = provider;
        this.path = path;
        this.commitMessage = commitMessage;
    }

    public String call() throws DebianizingException {
        SvnClientManager clientManager = SubversionSCM.createClientManager((ISVNAuthenticationProvider)this.provider);
        try {
            SVNCommitPacket changeset = clientManager.getCommitClient().doCollectCommitItems(new File[]{new File(this.path)}, false, true, SVNDepth.INFINITY, null);
            if (changeset != SVNCommitPacket.EMPTY) {
                SVNCommitInfo commitInfo = clientManager.getCommitClient().doCommit(changeset, false, this.commitMessage);
                if (commitInfo.getErrorMessage() != null) {
                    throw new DebianizingException(MessageFormat.format("Error while commiting <{0}>: {1}", this.path, commitInfo.getErrorMessage().toString()));
                }
                String string = Long.toString(commitInfo.getNewRevision());
                return string;
            }
            try {
                throw new DebianizingException("There was nothing to commit.");
            }
            catch (SVNException e) {
                throw new DebianizingException("SVNException: " + e.getMessage(), e);
            }
        }
        finally {
            clientManager.dispose();
        }
    }
}

