/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.jenkins.plugins.debuilder;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildBadgeAction;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.remoting.Callable;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import ru.yandex.jenkins.plugins.debuilder.DebUtils;
import ru.yandex.jenkins.plugins.debuilder.DebianBadge;
import ru.yandex.jenkins.plugins.debuilder.DebianPackageBuilder;
import ru.yandex.jenkins.plugins.debuilder.DebianPackageRepo;
import ru.yandex.jenkins.plugins.debuilder.DebianizingException;
import ru.yandex.jenkins.plugins.debuilder.GitCommitHelper;
import ru.yandex.jenkins.plugins.debuilder.SVNCommitHelper;

public class DebianPackagePublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PREFIX = "debian-package-publisher";
    private String repoId;
    private String commitMessage;
    private final boolean commitChanges;

    @DataBoundConstructor
    public DebianPackagePublisher(String repoId, String commitMessage, boolean commitChanges) {
        this.commitChanges = commitChanges;
        this.commitMessage = commitMessage;
        this.repoId = repoId;
        if (this.getRepo() == null) {
            throw new IllegalArgumentException(MessageFormat.format("Repo {0} is not found in global configuration", repoId));
        }
    }

    private DebianPackageRepo getRepo() {
        for (DebianPackageRepo repo : this.getDescriptor().getRepositories()) {
            if (!repo.getName().equals(this.repoId)) continue;
            return repo;
        }
        return null;
    }

    public static String getUsedCommitMessage(AbstractBuild build) {
        DescribableList publishersList = ((Project)build.getProject()).getPublishersList();
        for (Publisher publisher : publishersList) {
            if (!(publisher instanceof DebianPackagePublisher)) continue;
            return ((DebianPackagePublisher)publisher).commitMessage;
        }
        return "";
    }

    private String getRemoteKeyPath(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        String keysDir = "debian-package-builder-keys";
        String relativeKeyPath = new File(keysDir, this.getRepo().getKeypath()).getPath();
        File absoluteKeyPath = new File(Jenkins.getInstance().getRootDir(), relativeKeyPath);
        FilePath localKey = new FilePath(absoluteKeyPath);
        FilePath remoteKey = build.getWorkspace().createTextTempFile("private", "key", localKey.readToString());
        remoteKey.chmod(384);
        return remoteKey.getRemote();
    }

    private void generateDuploadConf(AbstractBuild<?, ?> build, DebUtils.Runner runner) throws IOException, InterruptedException, DebianizingException {
        String confTemplate = "package config;\n\n$default_host = '${name}';\n\n$cfg{'${name}'} = {\n\tlogin => '${login}',\n\tfqdn => '${fqdn}',\n\tmethod => '${method}',\n\tincoming => '${incoming}',\n\tdinstall_runs => 0,\n\toptions => '${options}',\n};\n\n1;\n";
        HashMap<String, String> values = new HashMap<String, String>();
        DebianPackageRepo repo = this.getRepo();
        values.put("name", repo.getName());
        values.put("method", repo.getMethod());
        values.put("fqdn", repo.getFqdn());
        values.put("incoming", repo.getIncoming());
        values.put("login", repo.getLogin());
        values.put("options", MessageFormat.format("-i {0} ", this.getRemoteKeyPath(build)) + repo.getOptions());
        StrSubstitutor substitutor = new StrSubstitutor(values);
        String conf = substitutor.replace(confTemplate);
        FilePath duploadConf = build.getWorkspace().createTempFile("dupload", "conf");
        duploadConf.touch(System.currentTimeMillis() / 1000L);
        duploadConf.write(conf, "UTF-8");
        String moveDupload = "if [ -e $HOME ]; then\n\tmv ''{0}'' \"$HOME/.dupload.conf\"\nelse\n\tsudo mv ''{0}'' /etc/dupload.conf\nfi";
        runner.runCommand(moveDupload, duploadConf.getRemote());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException {
        PrintStream logger = listener.getLogger();
        if (build.getResult().isWorseThan(Result.SUCCESS)) {
            logger.println(MessageFormat.format("[{0}] Aborting: {1} ", PREFIX, "Build is not success, will not execute debrelease"));
            return true;
        }
        DebUtils.Runner runner = new DebUtils.Runner(build, launcher, listener, PREFIX);
        try {
            runner.runCommand("sudo apt-get -y install dupload devscripts");
            this.generateDuploadConf(build, runner);
            ArrayList<String> builtModules = new ArrayList<String>();
            for (BuildBadgeAction action : build.getBadgeActions()) {
                if (!(action instanceof DebianBadge)) continue;
                builtModules.add(((DebianBadge)action).getModule());
            }
            boolean wereBuilds = false;
            for (String module : DebianPackageBuilder.getRemoteModules(build)) {
                if (!builtModules.contains(new FilePath(build.getWorkspace().getChannel(), module).child("debian").getRemote())) {
                    runner.announce("Module in {0} was not built - not releasing", module);
                    continue;
                }
                if (!runner.runCommandForResult("cd ''{0}'' && debrelease", module)) {
                    throw new DebianizingException("Debrelease failed");
                }
                wereBuilds = true;
            }
            if (wereBuilds && this.commitChanges) {
                String expandedCommitMessage = this.getExpandedCommitMessage(build, listener);
                this.commitChanges(build, runner, expandedCommitMessage);
            }
        }
        catch (InterruptedException e) {
            logger.println(MessageFormat.format("[{0}] Aborting: {1} ", PREFIX, e.getMessage()));
            build.setResult(Result.UNSTABLE);
        }
        catch (DebianizingException e) {
            logger.println(MessageFormat.format("[{0}] Aborting: {1} ", PREFIX, e.getMessage()));
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private String getExpandedCommitMessage(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        return env.expand(this.getCommitMessage());
    }

    private void commitChanges(AbstractBuild<?, ?> build, DebUtils.Runner runner, String commitMessage) throws DebianizingException, IOException, InterruptedException {
        SCM scm = build.getProject().getScm();
        if (scm instanceof SubversionSCM) {
            this.commitToSVN(build, runner, (SubversionSCM)scm, commitMessage);
        } else if (scm instanceof GitSCM) {
            this.commitToGitAndPush(build, runner, (GitSCM)scm, commitMessage);
        } else {
            throw new DebianizingException("SCM used is not a know one but " + scm.getType());
        }
    }

    private void commitToGitAndPush(AbstractBuild<?, ?> build, DebUtils.Runner runner, GitSCM scm, String commitMessage) throws DebianizingException {
        try {
            GitCommitHelper helper = new GitCommitHelper(build, scm, runner, commitMessage, DebianPackageBuilder.getRemoteModules(build));
            if (!((Boolean)build.getWorkspace().act((FilePath.FileCallable)helper)).booleanValue()) {
                throw new DebianizingException("Failed to commit to git");
            }
            runner.announce("Successfully commited to git");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void commitToSVN(AbstractBuild<?, ?> build, DebUtils.Runner runner, SubversionSCM svn, String commitMessage) throws DebianizingException {
        SubversionSCM.DescriptorImpl descriptor = (SubversionSCM.DescriptorImpl)Jenkins.getInstance().getDescriptor(SubversionSCM.class);
        ISVNAuthenticationProvider authenticationProvider = descriptor.createAuthenticationProvider(build.getProject());
        try {
            for (String module : DebianPackageBuilder.getRemoteModules(build)) {
                SVNCommitHelper helper = new SVNCommitHelper(authenticationProvider, module, commitMessage);
                runner.announce("Commited revision <{0}> of <{2}> with message <{1}>", runner.getChannel().call((Callable)helper), commitMessage, module);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DebianizingException("IOException: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new DebianizingException("Interrupted: " + e.getMessage(), e);
        }
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean isCommitChanges() {
        return this.commitChanges;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public String getRepoId() {
        return this.repoId;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private List<DebianPackageRepo> repos = new ArrayList<DebianPackageRepo>();

        public DescriptorImpl() {
            this.load();
        }

        public ArrayList<DebianPackageRepo> getRepositories() {
            return new ArrayList<DebianPackageRepo>(this.repos);
        }

        public ListBoxModel doFillRepoIdItems() {
            ListBoxModel model = new ListBoxModel();
            for (DebianPackageRepo repo : this.repos) {
                model.add(repo.getName(), repo.getName());
            }
            return model;
        }

        public FormValidation doCheckMethod(@QueryParameter String method) {
            if (method != "scpb") {
                return FormValidation.error((String)"This method is not supported yet");
            }
            return FormValidation.ok();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.repos = req.bindJSONToList(DebianPackageRepo.class, formData.get("repositories"));
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Publish debian packages";
        }
    }
}

