/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.jenkins.plugins.debuilder;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitSCM;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.scm.SubversionHack;
import hudson.scm.SubversionSCM;
import hudson.scm.SvnClientManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import ru.yandex.jenkins.plugins.debuilder.DebUtils;
import ru.yandex.jenkins.plugins.debuilder.DebianPackageBuilder;
import ru.yandex.jenkins.plugins.debuilder.DebianizingException;
import ru.yandex.jenkins.plugins.debuilder.VersionHelper;

public class ChangesExtractor {
    public static List<Change> getChanges(AbstractBuild build, DebUtils.Runner runner, SCM scm, String remoteDebian, String ourMessage, VersionHelper helper) throws DebianizingException, InterruptedException {
        BuildListener listener = runner.getListener();
        if (scm instanceof SubversionSCM) {
            String oldRevision = helper.getRevision();
            helper.setRevision(ChangesExtractor.getSVNRevision(build, runner, (SubversionSCM)scm, remoteDebian));
            if ("".equals(oldRevision)) {
                runner.announce("No last revision known, using changes since last successful build to populate debian/changelog");
                return ChangesExtractor.getChangesSinceLastBuild(build, ourMessage);
            }
            runner.announce("Calculating changes since revision {0}.", oldRevision);
            return ChangesExtractor.getChangesFromSubversion(build, runner, (SubversionSCM)scm, remoteDebian, oldRevision, helper.getRevision(), ourMessage);
        }
        if (scm instanceof GitSCM) {
            runner.announce("Calculating changes from git log");
            return ChangesExtractor.getChangesFromGit(build, listener, (GitSCM)scm, remoteDebian);
        }
        runner.announce("SCM in use is not Subversion nor Git (but <{0}> instead), defaulting to changes since last build", scm.getClass().getName());
        return ChangesExtractor.getChangesSinceLastBuild(build, ourMessage);
    }

    static String getSVNRevision(AbstractBuild build, DebUtils.Runner runner, SubversionSCM scm, String remoteDebian) throws DebianizingException {
        SubversionSCM.ModuleLocation location = ChangesExtractor.findOurLocation(build, scm, runner, remoteDebian);
        try {
            Map<String, Long> revisionsForBuild = SubversionHack.getRevisionsForBuild(scm, build);
            return Long.toString(revisionsForBuild.get(location.getSVNURL().toString()));
        }
        catch (IOException e) {
            throw new DebianizingException("IOException: " + e.getMessage(), e);
        }
        catch (SVNException e) {
            throw new DebianizingException("SVNException: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new DebianizingException("InterruptedException: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new DebianizingException("IllegalArgumentException: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new DebianizingException("IllegalAccessException: " + e.getMessage(), e);
        }
    }

    static SubversionSCM.ModuleLocation findOurLocation(AbstractBuild build, SubversionSCM scm, DebUtils.Runner runner, String remoteDebian) throws DebianizingException {
        for (SubversionSCM.ModuleLocation location : scm.getLocations()) {
            try {
                SubversionSCM.ModuleLocation expandedLocation = location.getExpandedLocation(build.getEnvironment((TaskListener)runner.getListener()));
                String moduleDir = expandedLocation.getLocalDir();
                if (!remoteDebian.startsWith(build.getWorkspace().child(moduleDir).getRemote())) continue;
                return expandedLocation;
            }
            catch (IOException e) {
                throw new DebianizingException("IOException: " + e.getMessage(), e);
            }
            catch (InterruptedException e) {
                throw new DebianizingException("InterruptedException: " + e.getMessage(), e);
            }
        }
        throw new DebianizingException("Can't find module location for remoteDebian " + remoteDebian);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Change> getChangesFromSubversion(AbstractBuild build, DebUtils.Runner runner, SubversionSCM scm, String remoteDebian, String latestRevision, String currentRevision, final String ourMessage) throws DebianizingException {
        final ArrayList<Change> result = new ArrayList<Change>();
        SvnClientManager manager = SubversionSCM.createClientManager((AbstractProject)build.getProject());
        try {
            SubversionSCM.ModuleLocation location = ChangesExtractor.findOurLocation(build, scm, runner, remoteDebian);
            try {
                SVNURL svnurl = location.getSVNURL();
                manager.getLogClient().doLog(svnurl, null, SVNRevision.UNDEFINED, SVNRevision.create((long)(Long.parseLong(latestRevision) + 1L)), SVNRevision.parse((String)currentRevision), false, true, 0L, new ISVNLogEntryHandler(){

                    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                        if (!logEntry.getMessage().equals(ourMessage)) {
                            result.add(new Change(logEntry.getAuthor(), logEntry.getMessage()));
                        }
                    }
                });
            }
            catch (SVNException e) {
                throw new DebianizingException("SVNException: " + e.getMessage(), e);
            }
        }
        finally {
            manager.dispose();
        }
        return result;
    }

    static List<Change> getChangesFromGit(AbstractBuild build, BuildListener listener, GitSCM scm, String remoteDebian) throws DebianizingException {
        try {
            EnvVars environment = build.getEnvironment((TaskListener)listener);
            GitClient cli = scm.createClient(listener, environment, build);
            FilePath workspace = build.getWorkspace();
            DebianPackageBuilder.DescriptorImpl descriptor = (DebianPackageBuilder.DescriptorImpl)Jenkins.getInstance().getDescriptor(DebianPackageBuilder.class);
            PersonIdent account = new PersonIdent(descriptor.getAccountName(), descriptor.getAccountEmail());
            return ChangesExtractor.getChangesFromGit(cli, workspace, remoteDebian, account);
        }
        catch (IOException e) {
            throw new DebianizingException("IOException: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new DebianizingException("InterruptedException: " + e.getMessage(), e);
        }
    }

    static List<Change> getChangesFromGit(GitClient cli, FilePath workspace, String remoteDebian, PersonIdent account) throws InterruptedException {
        String changelogPath = remoteDebian + "/changelog";
        LinkedList<Change> changesSinceLastChangelogModification = new LinkedList<Change>();
        LinkedList<Change> changesSinceLastChangelogModificationByPlugin = new LinkedList<Change>();
        boolean firstChangelogModificationFound = false;
        for (ObjectId rev : cli.revListAll()) {
            List lines = cli.showRevision(rev);
            GitChangeSet changeSet = new GitChangeSet(lines, true);
            String email = ChangesExtractor.getAuthorEmailFromGitRevision(lines);
            Change change = new Change(changeSet.getAuthorName(), changeSet.getMsg());
            for (GitChangeSet.Path path : changeSet.getPaths()) {
                String filePath = workspace.child(path.getPath()).getRemote();
                if (!filePath.equals(changelogPath)) continue;
                if (changeSet.getAuthorName().equals(account.getName()) & email.equals(account.getEmailAddress())) {
                    return changesSinceLastChangelogModificationByPlugin;
                }
                firstChangelogModificationFound = true;
            }
            if (!firstChangelogModificationFound) {
                changesSinceLastChangelogModification.addFirst(change);
            }
            changesSinceLastChangelogModificationByPlugin.addFirst(change);
        }
        return changesSinceLastChangelogModification;
    }

    static String getAuthorEmailFromGitRevision(List<String> lines) {
        Pattern pattern = Pattern.compile("^author [^<]*<(.*)> .*$");
        for (String line : lines) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return "";
    }

    static List<Change> getChangesSinceLastBuild(AbstractBuild build, String ourMessage) throws InterruptedException, DebianizingException {
        ArrayList<Change> result = new ArrayList<Change>();
        Run lastSuccessfulBuild = build.getProject().getLastSuccessfulBuild();
        int lastSuccessNumber = lastSuccessfulBuild == null ? 0 : lastSuccessfulBuild.number;
        for (int num = lastSuccessNumber + 1; num <= build.number; ++num) {
            AbstractBuild run = build.getProject().getBuildByNumber(num);
            if (run == null) continue;
            ChangeLogSet changeSet = run.getChangeSet();
            for (ChangeLogSet.Entry entry : changeSet) {
                if (entry.getMsg().equals(ourMessage)) continue;
                result.add(new Change(entry.getAuthor().getFullName(), entry.getMsg()));
            }
        }
        return result;
    }

    public static final class Change {
        private final String author;
        private final String message;

        public Change(String author, String message) {
            this.author = author;
            this.message = message;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.author + ": " + this.message;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Change)) {
                return false;
            }
            Change that = (Change)obj;
            return this.author.equals(that.author) && this.message.equals(that.message);
        }
    }
}

