/*
 * Decompiled with CFR 0.152.
 */
package ren.helloworld.upload2pgyer.helper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;
import ren.helloworld.upload2pgyer.helper.ProgressRequestBody;
import ren.helloworld.upload2pgyer.impl.Message;

public class CommonUtil {
    private static long last_time = -1L;

    public static void printHeaderInfo(Message listener) {
        CommonUtil.printMessage(listener, false, "");
        CommonUtil.printMessage(listener, false, "**************************************************************************************************");
        CommonUtil.printMessage(listener, false, "**************************************************************************************************");
        CommonUtil.printMessage(listener, false, "********************************          UPLOAD TO PGYER         ********************************");
        CommonUtil.printMessage(listener, false, "**************************************************************************************************");
        CommonUtil.printMessage(listener, false, "**************************************************************************************************\n");
    }

    public static void printMessage(Message listener, boolean needTag, String message) {
        if (listener == null) {
            return;
        }
        listener.message(needTag, message);
    }

    public static String findFile(String scandir, String wildcard, Message listener) {
        File dir = new File(scandir);
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            CommonUtil.printMessage(listener, true, "scan dir:" + dir.getAbsolutePath());
            CommonUtil.printMessage(listener, true, "scan dir isn't exist or it's not a directory!");
            return null;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(scandir);
        scanner.setIncludes(new String[]{wildcard});
        scanner.setCaseSensitive(true);
        scanner.scan();
        String[] uploadFiles = scanner.getIncludedFiles();
        if (uploadFiles == null || uploadFiles.length == 0) {
            return null;
        }
        if (uploadFiles.length == 1) {
            return new File(dir, uploadFiles[0]).getAbsolutePath();
        }
        List<String> strings = Arrays.asList(uploadFiles);
        Collections.sort(strings, new FileComparator(dir));
        String uploadFiltPath = new File(dir, strings.get(0)).getAbsolutePath();
        CommonUtil.printMessage(listener, true, "Found " + uploadFiles.length + " files, the default choice of the latest modified file!");
        CommonUtil.printMessage(listener, true, "The latest modified file is " + uploadFiltPath + "\n");
        return uploadFiltPath;
    }

    public static File write(String path, String content, String encoding) {
        try {
            File file = new File(path);
            if (!file.delete() && !file.createNewFile()) {
                return null;
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            writer.write(content);
            writer.close();
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File download(String urlString, String savePath, String fileName) {
        InputStream is = null;
        OutputStream os = null;
        try {
            int len;
            File dir = new File(savePath);
            if (!dir.exists() && !dir.mkdirs()) {
                File file = null;
                return file;
            }
            String filePath = savePath + File.separator + fileName;
            URL url = new URL(urlString);
            URLConnection con = url.openConnection();
            con.setConnectTimeout(60000);
            is = con.getInputStream();
            byte[] bs = new byte[8192];
            os = new FileOutputStream(filePath);
            while ((len = is.read(bs)) != -1) {
                os.write(bs, 0, len);
            }
            File file = new File(filePath);
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            File file = null;
            return file;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static String convertFileSize(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size >= gb) {
            return String.format("%.1f GB", Float.valueOf((float)size / (float)gb));
        }
        if (size >= mb) {
            float f = (float)size / (float)mb;
            return String.format(f > 100.0f ? "%.0f MB" : "%.1f MB", Float.valueOf(f));
        }
        if (size >= kb) {
            float f = (float)size / (float)kb;
            return String.format(f > 100.0f ? "%.0f KB" : "%.1f KB", Float.valueOf(f));
        }
        return String.format("%d B", size);
    }

    public static class FileComparator
    implements Comparator<String>,
    Serializable {
        File dir;

        public FileComparator(File dir) {
            this.dir = dir;
        }

        @Override
        public int compare(String o1, String o2) {
            File file1 = new File(this.dir, o1);
            File file2 = new File(this.dir, o2);
            if (file1.lastModified() < file2.lastModified()) {
                return 1;
            }
            if (file1.lastModified() > file2.lastModified()) {
                return -1;
            }
            return 0;
        }
    }

    public static class FileUploadProgressListener
    implements ProgressRequestBody.Listener {
        private Message listener;

        public FileUploadProgressListener(Message listener) {
            this.listener = listener;
        }

        @Override
        public void onRequestProgress(long bytesWritten, long contentLength) {
            int progress = (int)(100.0f * (float)bytesWritten / (float)contentLength);
            if (progress == 100) {
                last_time = -1L;
                this.listener.message(true, "upload progress: " + progress + " %");
                return;
            }
            if (last_time == -1L) {
                last_time = System.currentTimeMillis();
                this.listener.message(true, "upload progress: " + progress + " %");
                return;
            }
            if (System.currentTimeMillis() - last_time > 1000L) {
                last_time = System.currentTimeMillis();
                this.listener.message(true, "upload progress: " + progress + " %");
            }
        }
    }
}

