/*
 * Decompiled with CFR 0.152.
 */
package ren.helloworld.upload2pgyer.apiv2;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import ren.helloworld.upload2pgyer.apiv2.ParamsBeanV2;
import ren.helloworld.upload2pgyer.apiv2.PgyerBeanV2;
import ren.helloworld.upload2pgyer.helper.CommonUtil;
import ren.helloworld.upload2pgyer.helper.ProgressRequestBody;
import ren.helloworld.upload2pgyer.impl.Message;

public class PgyerUploadV2 {
    private static final String TAG = "[UPLOAD TO PGYER] - ";
    private static final String UPLOAD_URL = "https://www.pgyer.com/apiv2/app/upload";

    public static void main(String[] args) {
        Message listener = new Message(){

            @Override
            public void message(boolean needTag, String mesage) {
                System.out.println((needTag ? PgyerUploadV2.TAG : "") + mesage);
            }
        };
        CommonUtil.printHeaderInfo(listener);
        ParamsBeanV2 paramsBeanV2 = PgyerUploadV2.parseArgs(args, listener);
        if (paramsBeanV2 == null) {
            return;
        }
        PgyerUploadV2.upload2Pgyer(false, paramsBeanV2, listener);
    }

    private static ParamsBeanV2 parseArgs(String[] args, Message listener) {
        int length = args.length;
        if (length == 0 || length % 2 != 0) {
            CommonUtil.printMessage(listener, true, "args length is error!\n");
            return null;
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            maps.put(args[i], args[i + 1]);
        }
        if (!maps.containsKey("-apiKey")) {
            CommonUtil.printMessage(listener, true, "apiKey not found!\n");
            return null;
        }
        if (!maps.containsKey("-scanDir")) {
            CommonUtil.printMessage(listener, true, "scanDir not found!\n");
            return null;
        }
        if (!maps.containsKey("-wildcard")) {
            CommonUtil.printMessage(listener, true, "wildcard not found!\n");
            return null;
        }
        ParamsBeanV2 paramsBeanV2 = new ParamsBeanV2();
        paramsBeanV2.setApiKey((String)maps.get("-apiKey"));
        paramsBeanV2.setScandir((String)maps.get("-scanDir"));
        paramsBeanV2.setWildcard((String)maps.get("-wildcard"));
        paramsBeanV2.setBuildName(maps.containsKey("-buildName") ? (String)maps.get("-buildName") : "");
        paramsBeanV2.setQrcodePath(maps.containsKey("-qrcodePath") ? (String)maps.get("-qrcodePath") : null);
        paramsBeanV2.setEnvVarsPath(maps.containsKey("-envVarsPath") ? (String)maps.get("-envVarsPath") : null);
        paramsBeanV2.setBuildPassword(maps.containsKey("-buildPassword") ? (String)maps.get("-buildPassword") : "");
        paramsBeanV2.setBuildInstallType(maps.containsKey("-buildInstallType") ? (String)maps.get("-buildInstallType") : "1");
        paramsBeanV2.setBuildUpdateDescription(maps.containsKey("-buildUpdateDescription") ? (String)maps.get("-buildUpdateDescription") : "");
        return paramsBeanV2;
    }

    public static PgyerBeanV2 upload2Pgyer(boolean printHeader, ParamsBeanV2 paramsBeanV2, Message listener) {
        if (printHeader) {
            CommonUtil.printHeaderInfo(listener);
        }
        paramsBeanV2.setUploadFile(CommonUtil.findFile(paramsBeanV2.getScandir(), paramsBeanV2.getWildcard(), listener));
        if (paramsBeanV2.getUploadFile() == null) {
            CommonUtil.printMessage(listener, true, "The uploaded file was not found\uff0cplase check scandir or wildcard!\n");
            return null;
        }
        File uploadFile = new File(paramsBeanV2.getUploadFile());
        if (!uploadFile.exists() || !uploadFile.isFile()) {
            CommonUtil.printMessage(listener, true, "The uploaded file was not found\uff0cplase check scandir or wildcard!\n");
            return null;
        }
        String result = "";
        try {
            PgyerBeanV2 pgyerBeanV2;
            CommonUtil.printMessage(listener, true, "upload\uff1a" + uploadFile.getName() + " to " + UPLOAD_URL);
            CommonUtil.printMessage(listener, true, "upload file size: " + CommonUtil.convertFileSize(uploadFile.length()));
            if (CommonUtil.isBlank(paramsBeanV2.getBuildUpdateDescription()) || "${SCM_CHANGELOG}".equals(paramsBeanV2.getBuildUpdateDescription())) {
                paramsBeanV2.setBuildUpdateDescription("");
            }
            MediaType type = MediaType.parse((String)"application/octet-stream");
            RequestBody fileBody = RequestBody.create((MediaType)type, (File)uploadFile);
            MultipartBody requestBody = new MultipartBody.Builder().setType(MediaType.parse((String)"multipart/form-data")).addFormDataPart("_api_key", paramsBeanV2.getApiKey()).addFormDataPart("buildInstallType", paramsBeanV2.getBuildInstallType()).addFormDataPart("buildPassword", paramsBeanV2.getBuildPassword()).addFormDataPart("buildUpdateDescription", paramsBeanV2.getBuildUpdateDescription()).addFormDataPart("file", uploadFile.getName(), fileBody).addFormDataPart("buildName", paramsBeanV2.getBuildName()).build();
            Request request = new Request.Builder().url(UPLOAD_URL).post((RequestBody)new ProgressRequestBody((RequestBody)requestBody, new CommonUtil.FileUploadProgressListener(listener))).build();
            Response execute = new OkHttpClient().newCall(request).execute();
            result = execute.body().string();
            if (result != null && result.contains("\"data\":[]")) {
                result = result.replace("\"data\":[]", "\"data\":{}");
            }
            if ((pgyerBeanV2 = (PgyerBeanV2)new Gson().fromJson(result, new TypeToken<PgyerBeanV2>(){}.getType())).getCode() != 0) {
                CommonUtil.printMessage(listener, true, "Upload failed with pgyer api v2!");
                CommonUtil.printMessage(listener, true, "error code\uff1a" + pgyerBeanV2.getCode());
                CommonUtil.printMessage(listener, true, "error message\uff1a" + pgyerBeanV2.getMessage() + "\n");
                return null;
            }
            pgyerBeanV2.getData().setAppPgyerURL("https://www.pgyer.com/" + pgyerBeanV2.getData().getBuildShortcutUrl());
            pgyerBeanV2.getData().setAppBuildURL("https://www.pgyer.com/" + pgyerBeanV2.getData().getBuildKey());
            pgyerBeanV2.getData().setBuildIcon("https://www.pgyer.com/image/view/app_icons/" + pgyerBeanV2.getData().getBuildIcon());
            CommonUtil.printMessage(listener, true, "Uploaded successfully!\n");
            PgyerUploadV2.printResultInfo(pgyerBeanV2, listener);
            PgyerUploadV2.writeEnvVars(paramsBeanV2, pgyerBeanV2, listener);
            PgyerUploadV2.downloadQrcode(paramsBeanV2, pgyerBeanV2, listener);
            return pgyerBeanV2;
        }
        catch (IOException e) {
            listener.message(true, "pgyer result: " + result);
            listener.message(true, "ERROR: " + e.getMessage() + "\n");
            return null;
        }
    }

    private static void downloadQrcode(ParamsBeanV2 paramsBeanV2, PgyerBeanV2 pgyerBeanV2, Message listener) {
        if (paramsBeanV2.getQrcodePath() == null) {
            return;
        }
        if (CommonUtil.replaceBlank(paramsBeanV2.getQrcodePath()).length() == 0) {
            return;
        }
        CommonUtil.printMessage(listener, true, "Downloading the qr code\u2026\u2026");
        File qrcode = new File(paramsBeanV2.getQrcodePath());
        if (!qrcode.getParentFile().exists() && !qrcode.getParentFile().mkdirs()) {
            CommonUtil.printMessage(listener, true, "Oh, my god, download the qr code failed\u2026\u2026\n");
            return;
        }
        File file = CommonUtil.download(pgyerBeanV2.getData().getBuildQRCodeURL(), qrcode.getParentFile().getAbsolutePath(), qrcode.getName());
        if (file != null) {
            CommonUtil.printMessage(listener, true, "Download the qr code successfully! " + file + "\n");
        } else {
            CommonUtil.printMessage(listener, true, "Oh, my god, download the qr code failed\u2026\u2026\n");
        }
    }

    private static void writeEnvVars(ParamsBeanV2 paramsBeanV2, PgyerBeanV2 pgyerBeanV2, Message listener) {
        if (paramsBeanV2.getEnvVarsPath() == null) {
            return;
        }
        if (CommonUtil.replaceBlank(paramsBeanV2.getEnvVarsPath()).length() == 0) {
            return;
        }
        CommonUtil.printMessage(listener, true, "Writing the environment variable to the file\u2026\u2026");
        File envVars = new File(paramsBeanV2.getEnvVarsPath());
        if (!envVars.getParentFile().exists() && !envVars.getParentFile().mkdirs()) {
            CommonUtil.printMessage(listener, true, "Oh my god, the environment variable writes failed\u2026\u2026\n");
            return;
        }
        File file = CommonUtil.write(envVars.getAbsolutePath(), PgyerUploadV2.getEnvVarsInfo(pgyerBeanV2), "utf-8");
        if (file != null) {
            CommonUtil.printMessage(listener, true, "The environment variable is written successfully! " + file + "\n");
        } else {
            CommonUtil.printMessage(listener, true, "Oh my god, the environment variable writes failed\u2026\u2026\n");
        }
    }

    private static void printResultInfo(PgyerBeanV2 pgyerBeanV2, Message listener) {
        PgyerBeanV2.DataBean data = pgyerBeanV2.getData();
        CommonUtil.printMessage(listener, true, "Build Key\uff1a" + data.getBuildKey());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u7c7b\u578b\uff1a" + data.getBuildType());
        CommonUtil.printMessage(listener, true, "\u662f\u5426\u662f\u7b2c\u4e00\u4e2aApp\uff1a" + data.getBuildType());
        CommonUtil.printMessage(listener, true, "\u662f\u5426\u662f\u6700\u65b0\u7248\uff1a" + data.getBuildIsLastest());
        CommonUtil.printMessage(listener, true, "\u6587\u4ef6\u5927\u5c0f\uff1a" + data.getBuildFileSize());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u540d\u79f0\uff1a" + data.getBuildName());
        CommonUtil.printMessage(listener, true, "\u7248\u672c\u53f7\uff1a" + data.getBuildVersion());
        CommonUtil.printMessage(listener, true, "\u7248\u672c\u7f16\u53f7\uff1a" + data.getBuildVersionNo());
        CommonUtil.printMessage(listener, true, "build\u53f7\uff1a" + data.getBuildBuildVersion());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u7a0b\u5e8f\u5305\u540d\uff1a" + data.getBuildIdentifier());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u7684Icon\u56fe\u6807key\uff1a" + data.getBuildIcon());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u4ecb\u7ecd\uff1a" + data.getBuildDescription());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u66f4\u65b0\u8bf4\u660e\uff1a" + data.getBuildUpdateDescription());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u622a\u56fe\u7684key\uff1a" + data.getBuildScreenshots());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u77ed\u94fe\u63a5\uff1a" + data.getBuildShortcutUrl());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u4e8c\u7ef4\u7801\u5730\u5740\uff1a" + data.getBuildQRCodeURL());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u4e0a\u4f20\u65f6\u95f4\uff1a" + data.getBuildCreated());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u66f4\u65b0\u65f6\u95f4\uff1a" + data.getBuildUpdated());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u4e3b\u9875\uff1a" + data.getAppPgyerURL());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u6784\u5efa\u4e3b\u9875\uff1a" + data.getAppBuildURL());
        CommonUtil.printMessage(listener, false, "");
    }

    private static String getEnvVarsInfo(PgyerBeanV2 pgyerBeanV2) {
        StringBuffer sb = new StringBuffer();
        sb.append("buildKey").append("=").append(pgyerBeanV2.getData().getBuildKey()).append("\n");
        sb.append("buildType").append("=").append(pgyerBeanV2.getData().getBuildType()).append("\n");
        sb.append("buildIsFirst").append("=").append(pgyerBeanV2.getData().getBuildIsFirst()).append("\n");
        sb.append("buildIsLastest").append("=").append(pgyerBeanV2.getData().getBuildIsLastest()).append("\n");
        sb.append("buildFileName").append("=").append(pgyerBeanV2.getData().getBuildFileName()).append("\n");
        sb.append("buildFileSize").append("=").append(pgyerBeanV2.getData().getBuildFileSize()).append("\n");
        sb.append("buildName").append("=").append(pgyerBeanV2.getData().getBuildName()).append("\n");
        sb.append("buildVersion").append("=").append(pgyerBeanV2.getData().getBuildVersion()).append("\n");
        sb.append("buildVersionNo").append("=").append(pgyerBeanV2.getData().getBuildVersionNo()).append("\n");
        sb.append("buildBuildVersion").append("=").append(pgyerBeanV2.getData().getBuildBuildVersion()).append("\n");
        sb.append("buildIdentifier").append("=").append(pgyerBeanV2.getData().getBuildIdentifier()).append("\n");
        sb.append("buildIcon").append("=").append(pgyerBeanV2.getData().getBuildIcon()).append("\n");
        sb.append("buildDescription").append("=").append(pgyerBeanV2.getData().getBuildDescription()).append("\n");
        sb.append("buildUpdateDescription").append("=").append(pgyerBeanV2.getData().getBuildUpdateDescription()).append("\n");
        sb.append("buildScreenshots").append("=").append(pgyerBeanV2.getData().getBuildScreenshots()).append("\n");
        sb.append("buildShortcutUrl").append("=").append(pgyerBeanV2.getData().getBuildShortcutUrl()).append("\n");
        sb.append("buildCreated").append("=").append(pgyerBeanV2.getData().getBuildCreated()).append("\n");
        sb.append("buildUpdated").append("=").append(pgyerBeanV2.getData().getBuildUpdated()).append("\n");
        sb.append("buildQRCodeURL").append("=").append(pgyerBeanV2.getData().getBuildQRCodeURL()).append("\n");
        sb.append("appPgyerURL").append("=").append(pgyerBeanV2.getData().getAppPgyerURL()).append("\n");
        sb.append("appBuildURL").append("=").append(pgyerBeanV2.getData().getAppBuildURL()).append("\n");
        return sb.toString();
    }
}

