/*
 * Decompiled with CFR 0.152.
 */
package ren.helloworld.upload2pgyer.apiv1;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import ren.helloworld.upload2pgyer.apiv1.ParamsBeanV1;
import ren.helloworld.upload2pgyer.apiv1.PgyerBeanV1;
import ren.helloworld.upload2pgyer.helper.CommonUtil;
import ren.helloworld.upload2pgyer.helper.ProgressRequestBody;
import ren.helloworld.upload2pgyer.impl.Message;

public class PgyerUploadV1 {
    private static final String TAG = "[UPLOAD TO PGYER] - ";
    private static final String UPLOAD_URL = "https://qiniu-storage.pgyer.com/apiv1/app/upload";

    public static void main(String[] args) {
        Message listener = new Message(){

            @Override
            public void message(boolean needTag, String mesage) {
                System.out.println((needTag ? PgyerUploadV1.TAG : "") + mesage);
            }
        };
        CommonUtil.printHeaderInfo(listener);
        ParamsBeanV1 paramsBeanV1 = PgyerUploadV1.parseArgs(args, listener);
        if (paramsBeanV1 == null) {
            return;
        }
        PgyerUploadV1.upload2Pgyer(false, paramsBeanV1, listener);
    }

    private static ParamsBeanV1 parseArgs(String[] args, Message listener) {
        int length = args.length;
        if (length == 0 || length % 2 != 0) {
            CommonUtil.printMessage(listener, true, "args length is error!\n");
            return null;
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            maps.put(args[i], args[i + 1]);
        }
        if (!maps.containsKey("-uKey")) {
            CommonUtil.printMessage(listener, true, "uKey not found!\n");
            return null;
        }
        if (!maps.containsKey("-apiKey")) {
            CommonUtil.printMessage(listener, true, "apiKey not found!\n");
            return null;
        }
        if (!maps.containsKey("-scanDir")) {
            CommonUtil.printMessage(listener, true, "scanDir not found!\n");
            return null;
        }
        if (!maps.containsKey("-wildcard")) {
            CommonUtil.printMessage(listener, true, "wildcard not found!\n");
            return null;
        }
        ParamsBeanV1 paramsBeanV1 = new ParamsBeanV1();
        paramsBeanV1.setUkey((String)maps.get("-uKey"));
        paramsBeanV1.setApiKey((String)maps.get("-apiKey"));
        paramsBeanV1.setScandir((String)maps.get("-scanDir"));
        paramsBeanV1.setWildcard((String)maps.get("-wildcard"));
        paramsBeanV1.setPassword(maps.containsKey("-password") ? (String)maps.get("-password") : "");
        paramsBeanV1.setQrcodePath(maps.containsKey("-qrcodePath") ? (String)maps.get("-qrcodePath") : null);
        paramsBeanV1.setEnvVarsPath(maps.containsKey("-envVarsPath") ? (String)maps.get("-envVarsPath") : null);
        paramsBeanV1.setInstallType(maps.containsKey("-installType") ? (String)maps.get("-installType") : "1");
        paramsBeanV1.setUpdateDescription(maps.containsKey("-updateDescription") ? (String)maps.get("-updateDescription") : "");
        return paramsBeanV1;
    }

    public static PgyerBeanV1 upload2Pgyer(boolean printHeader, ParamsBeanV1 paramsBeanV1, Message listener) {
        if (printHeader) {
            CommonUtil.printHeaderInfo(listener);
        }
        paramsBeanV1.setUploadFile(CommonUtil.findFile(paramsBeanV1.getScandir(), paramsBeanV1.getWildcard(), listener));
        if (paramsBeanV1.getUploadFile() == null) {
            CommonUtil.printMessage(listener, true, "The uploaded file was not found\uff0cplase check scandir or wildcard!\n");
            return null;
        }
        File uploadFile = new File(paramsBeanV1.getUploadFile());
        if (!uploadFile.exists() || !uploadFile.isFile()) {
            CommonUtil.printMessage(listener, true, "The uploaded file was not found\uff0cplase check scandir or wildcard!\n");
            return null;
        }
        String result = "";
        try {
            PgyerBeanV1 pgyerBeanV1;
            CommonUtil.printMessage(listener, true, "upload\uff1a" + uploadFile.getName() + " to " + UPLOAD_URL);
            CommonUtil.printMessage(listener, true, "upload file size: " + CommonUtil.convertFileSize(uploadFile.length()));
            if (CommonUtil.isBlank(paramsBeanV1.getUpdateDescription()) || "${SCM_CHANGELOG}".equals(paramsBeanV1.getUpdateDescription())) {
                paramsBeanV1.setUpdateDescription("");
            }
            MediaType type = MediaType.parse((String)"application/octet-stream");
            RequestBody fileBody = RequestBody.create((MediaType)type, (File)uploadFile);
            MultipartBody requestBody = new MultipartBody.Builder().setType(MediaType.parse((String)"multipart/form-data")).addFormDataPart("uKey", paramsBeanV1.getUkey()).addFormDataPart("_api_key", paramsBeanV1.getApiKey()).addFormDataPart("installType", paramsBeanV1.getInstallType()).addFormDataPart("password", paramsBeanV1.getPassword()).addFormDataPart("updateDescription", paramsBeanV1.getUpdateDescription()).addFormDataPart("file", uploadFile.getName(), fileBody).build();
            Request request = new Request.Builder().url(UPLOAD_URL).post((RequestBody)new ProgressRequestBody((RequestBody)requestBody, new CommonUtil.FileUploadProgressListener(listener))).build();
            Response execute = new OkHttpClient().newCall(request).execute();
            result = execute.body().string();
            if (result != null && result.contains("\"data\":[]")) {
                result = result.replace("\"data\":[]", "\"data\":{}");
            }
            if ((pgyerBeanV1 = (PgyerBeanV1)new Gson().fromJson(result, new TypeToken<PgyerBeanV1>(){}.getType())).getCode() != 0) {
                CommonUtil.printMessage(listener, true, "Upload failed!");
                CommonUtil.printMessage(listener, true, "error code\uff1a" + pgyerBeanV1.getCode());
                CommonUtil.printMessage(listener, true, "error message\uff1a" + pgyerBeanV1.getMessage() + "\n");
                return null;
            }
            pgyerBeanV1.getData().setAppPgyerURL("https://www.pgyer.com/" + pgyerBeanV1.getData().getAppShortcutUrl());
            pgyerBeanV1.getData().setAppBuildURL("https://www.pgyer.com/" + pgyerBeanV1.getData().getAppKey());
            pgyerBeanV1.getData().setAppIcon("https://www.pgyer.com/image/view/app_icons/" + pgyerBeanV1.getData().getAppIcon());
            CommonUtil.printMessage(listener, true, "Uploaded successfully!\n");
            PgyerUploadV1.printResultInfo(pgyerBeanV1, listener);
            PgyerUploadV1.writeEnvVars(paramsBeanV1, pgyerBeanV1, listener);
            PgyerUploadV1.downloadQrcode(paramsBeanV1, pgyerBeanV1, listener);
            return pgyerBeanV1;
        }
        catch (IOException e) {
            listener.message(true, "pgyer result: " + result);
            listener.message(true, "ERROR: " + e.getMessage() + "\n");
            return null;
        }
    }

    private static void downloadQrcode(ParamsBeanV1 paramsBeanV1, PgyerBeanV1 pgyerBeanV1, Message listener) {
        if (paramsBeanV1.getQrcodePath() == null) {
            return;
        }
        if (CommonUtil.replaceBlank(paramsBeanV1.getQrcodePath()).length() == 0) {
            return;
        }
        CommonUtil.printMessage(listener, true, "Downloading the qr code\u2026\u2026");
        File qrcode = new File(paramsBeanV1.getQrcodePath());
        if (!qrcode.getParentFile().exists() && !qrcode.getParentFile().mkdirs()) {
            CommonUtil.printMessage(listener, true, "Oh, my god, download the qr code failed\u2026\u2026\n");
            return;
        }
        File file = CommonUtil.download(pgyerBeanV1.getData().getAppQRCodeURL(), qrcode.getParentFile().getAbsolutePath(), qrcode.getName());
        if (file != null) {
            CommonUtil.printMessage(listener, true, "Download the qr code successfully! " + file + "\n");
        } else {
            CommonUtil.printMessage(listener, true, "Oh, my god, download the qr code failed\u2026\u2026\n");
        }
    }

    private static void writeEnvVars(ParamsBeanV1 paramsBeanV1, PgyerBeanV1 pgyerBeanV1, Message listener) {
        if (paramsBeanV1.getEnvVarsPath() == null) {
            return;
        }
        if (CommonUtil.replaceBlank(paramsBeanV1.getEnvVarsPath()).length() == 0) {
            return;
        }
        CommonUtil.printMessage(listener, true, "Writing the environment variable to the file\u2026\u2026");
        File envVars = new File(paramsBeanV1.getEnvVarsPath());
        if (!envVars.getParentFile().exists() && !envVars.getParentFile().mkdirs()) {
            CommonUtil.printMessage(listener, true, "Oh my god, the environment variable writes failed\u2026\u2026\n");
            return;
        }
        File file = CommonUtil.write(envVars.getAbsolutePath(), PgyerUploadV1.getEnvVarsInfo(pgyerBeanV1), "utf-8");
        if (file != null) {
            CommonUtil.printMessage(listener, true, "The environment variable is written successfully! " + file + "\n");
        } else {
            CommonUtil.printMessage(listener, true, "Oh my god, the environment variable writes failed\u2026\u2026\n");
        }
    }

    private static void printResultInfo(PgyerBeanV1 pgyerBeanV1, Message listener) {
        PgyerBeanV1.DataBean data = pgyerBeanV1.getData();
        CommonUtil.printMessage(listener, true, "App Key\uff1a" + data.getAppKey());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u7c7b\u578b\uff1a" + data.getAppType());
        CommonUtil.printMessage(listener, true, "\u662f\u5426\u662f\u6700\u65b0\u7248\uff1a" + data.getAppIsLastest());
        CommonUtil.printMessage(listener, true, "\u6587\u4ef6\u5927\u5c0f\uff1a" + data.getAppFileSize());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u540d\u79f0\uff1a" + data.getAppName());
        CommonUtil.printMessage(listener, true, "\u7248\u672c\u53f7\uff1a" + data.getAppVersion());
        CommonUtil.printMessage(listener, true, "\u7248\u672c\u7f16\u53f7\uff1a" + data.getAppVersionNo());
        CommonUtil.printMessage(listener, true, "build\u53f7\uff1a" + data.getAppBuildVersion());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u7a0b\u5e8f\u5305\u540d\uff1a" + data.getAppIdentifier());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u7684Icon\u56fe\u6807key\uff1a" + data.getAppIcon());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u4ecb\u7ecd\uff1a" + data.getAppDescription());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u66f4\u65b0\u8bf4\u660e\uff1a" + data.getAppUpdateDescription());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u622a\u56fe\u7684key\uff1a" + data.getAppScreenshots());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u77ed\u94fe\u63a5\uff1a" + data.getAppShortcutUrl());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u4e8c\u7ef4\u7801\u5730\u5740\uff1a" + data.getAppQRCodeURL());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u4e0a\u4f20\u65f6\u95f4\uff1a" + data.getAppCreated());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u66f4\u65b0\u65f6\u95f4\uff1a" + data.getAppUpdated());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u4e3b\u9875\uff1a" + data.getAppPgyerURL());
        CommonUtil.printMessage(listener, true, "\u5e94\u7528\u6784\u5efa\u4e3b\u9875\uff1a" + data.getAppBuildURL());
        CommonUtil.printMessage(listener, false, "");
    }

    private static String getEnvVarsInfo(PgyerBeanV1 pgyerBeanV1) {
        StringBuffer sb = new StringBuffer();
        sb.append("appKey").append("=").append(pgyerBeanV1.getData().getAppKey()).append("\n");
        sb.append("appType").append("=").append(pgyerBeanV1.getData().getAppType()).append("\n");
        sb.append("appIsLastest").append("=").append(pgyerBeanV1.getData().getAppIsLastest()).append("\n");
        sb.append("appFileSize").append("=").append(pgyerBeanV1.getData().getAppFileSize()).append("\n");
        sb.append("appName").append("=").append(pgyerBeanV1.getData().getAppName()).append("\n");
        sb.append("appVersion").append("=").append(pgyerBeanV1.getData().getAppVersion()).append("\n");
        sb.append("appVersionNo").append("=").append(pgyerBeanV1.getData().getAppVersionNo()).append("\n");
        sb.append("appBuildVersion").append("=").append(pgyerBeanV1.getData().getAppBuildVersion()).append("\n");
        sb.append("appIdentifier").append("=").append(pgyerBeanV1.getData().getAppIdentifier()).append("\n");
        sb.append("appIcon").append("=").append(pgyerBeanV1.getData().getAppIcon()).append("\n");
        sb.append("appDescription").append("=").append(pgyerBeanV1.getData().getAppDescription()).append("\n");
        sb.append("appUpdateDescription").append("=").append(pgyerBeanV1.getData().getAppUpdateDescription()).append("\n");
        sb.append("appScreenshots").append("=").append(pgyerBeanV1.getData().getAppScreenshots()).append("\n");
        sb.append("appShortcutUrl").append("=").append(pgyerBeanV1.getData().getAppShortcutUrl()).append("\n");
        sb.append("appCreated").append("=").append(pgyerBeanV1.getData().getAppCreated()).append("\n");
        sb.append("appUpdated").append("=").append(pgyerBeanV1.getData().getAppUpdated()).append("\n");
        sb.append("appQRCodeURL").append("=").append(pgyerBeanV1.getData().getAppQRCodeURL()).append("\n");
        sb.append("appPgyerURL").append("=").append(pgyerBeanV1.getData().getAppPgyerURL()).append("\n");
        sb.append("appBuildURL").append("=").append(pgyerBeanV1.getData().getAppBuildURL()).append("\n");
        return sb.toString();
    }
}

