/*
 * Decompiled with CFR 0.152.
 */
package ren.helloworld.upload2pgyer;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import ren.helloworld.upload2pgyer.apiv1.ParamsBeanV1;
import ren.helloworld.upload2pgyer.helper.PgyerV1Helper;

public class UploadPublisher
extends Recorder {
    private String uKey;
    private String apiKey;
    private String scanDir;
    private String wildcard;
    private String installType;
    private String password;
    private String updateDescription;
    private String qrcodePath;
    private String envVarsPath;

    @DataBoundConstructor
    public UploadPublisher(String uKey, String apiKey, String scanDir, String wildcard, String installType, String password, String updateDescription, String qrcodePath, String envVarsPath) {
        this.uKey = uKey;
        this.apiKey = apiKey;
        this.scanDir = scanDir;
        this.wildcard = wildcard;
        this.installType = installType;
        this.password = password;
        this.updateDescription = updateDescription;
        this.qrcodePath = qrcodePath;
        this.envVarsPath = envVarsPath;
    }

    public String getuKey() {
        return this.uKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getScanDir() {
        return this.scanDir;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getInstallType() {
        return this.installType;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUpdateDescription() {
        return this.updateDescription;
    }

    public String getQrcodePath() {
        return this.qrcodePath;
    }

    public String getEnvVarsPath() {
        return this.envVarsPath;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ParamsBeanV1 bean = new ParamsBeanV1();
        bean.setApiKey(this.apiKey);
        bean.setUkey(this.uKey);
        bean.setScandir(this.scanDir);
        bean.setWildcard(this.wildcard);
        bean.setInstallType(this.installType);
        bean.setPassword(this.password);
        bean.setUpdateDescription(this.updateDescription);
        bean.setQrcodePath(this.qrcodePath);
        bean.setEnvVarsPath(this.envVarsPath);
        return PgyerV1Helper.upload(build, listener, bean);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Symbol(value={"upload-pgyer"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckUKey(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a uKey");
            }
            if (!value.matches("[A-Za-z0-9]{32}")) {
                return FormValidation.warning((String)"Is this correct?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApiKey(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a api_key");
            }
            if (!value.matches("[A-Za-z0-9]{32}")) {
                return FormValidation.warning((String)"Is this correct?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckScanDir(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set upload ipa or apk file base dir name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckWildcard(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set upload ipa or apk file wildcard");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckInstallType(@QueryParameter int value) throws IOException, ServletException {
            if (value < 1 || value > 3) {
                return FormValidation.error((String)"application installation, the value is (1,2,3).");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a password");
            }
            if (value.length() < 6) {
                return FormValidation.warning((String)"Isn't the password too short?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Upload to pgyer with apiV1";
        }
    }
}

