/*
 * Decompiled with CFR 0.152.
 */
package ren.helloworld.upload2pgyer;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import ren.helloworld.upload2pgyer.apiv2.ParamsBeanV2;
import ren.helloworld.upload2pgyer.helper.PgyerV2Helper;

public class UploadBuilderV2
extends Builder {
    private String apiKey;
    private String scanDir;
    private String wildcard;
    private String buildInstallType;
    private String buildPassword;
    private String buildUpdateDescription;
    private String buildName;
    private String qrcodePath;
    private String envVarsPath;

    @DataBoundConstructor
    public UploadBuilderV2(String apiKey, String scanDir, String wildcard, String buildName, String buildInstallType, String buildPassword, String buildUpdateDescription, String qrcodePath, String envVarsPath) {
        this.apiKey = apiKey;
        this.scanDir = scanDir;
        this.wildcard = wildcard;
        this.buildName = buildName;
        this.buildPassword = buildPassword;
        this.buildInstallType = buildInstallType;
        this.buildUpdateDescription = buildUpdateDescription;
        this.qrcodePath = qrcodePath;
        this.envVarsPath = envVarsPath;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getScanDir() {
        return this.scanDir;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getBuildInstallType() {
        return this.buildInstallType;
    }

    public String getBuildPassword() {
        return this.buildPassword;
    }

    public String getBuildUpdateDescription() {
        return this.buildUpdateDescription;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public String getQrcodePath() {
        return this.qrcodePath;
    }

    public String getEnvVarsPath() {
        return this.envVarsPath;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ParamsBeanV2 paramsBeanV2 = new ParamsBeanV2();
        paramsBeanV2.setApiKey(this.apiKey);
        paramsBeanV2.setScandir(this.scanDir);
        paramsBeanV2.setWildcard(this.wildcard);
        paramsBeanV2.setBuildPassword(this.buildPassword);
        paramsBeanV2.setBuildInstallType(this.buildInstallType);
        paramsBeanV2.setBuildUpdateDescription(this.buildUpdateDescription);
        paramsBeanV2.setBuildName(this.buildName);
        paramsBeanV2.setQrcodePath(this.qrcodePath);
        paramsBeanV2.setEnvVarsPath(this.envVarsPath);
        return PgyerV2Helper.upload(build, listener, paramsBeanV2);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"upload-pgyer-v2"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckApiKey(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a api_key");
            }
            if (!value.matches("[A-Za-z0-9]{32}")) {
                return FormValidation.warning((String)"Is this correct?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckScanDir(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set upload ipa or apk file base dir name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckWildcard(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set upload ipa or apk file wildcard");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBuildInstallType(@QueryParameter int value) throws IOException, ServletException {
            if (value < 1 || value > 3) {
                return FormValidation.error((String)"application installation, the value is (1,2,3).");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBuildPassword(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a password");
            }
            if (value.length() < 6) {
                return FormValidation.warning((String)"Isn't the password too short?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Upload to pgyer with apiV2";
        }
    }
}

