/*
 * Decompiled with CFR 0.152.
 */
package ren.helloworld.upload2pgyer;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import ren.helloworld.upload2pgyer.apiv1.ParamsBeanV1;
import ren.helloworld.upload2pgyer.helper.PgyerV1Helper;

public class UploadBuilder
extends Builder {
    private String uKey;
    private String apiKey;
    private String scanDir;
    private String wildcard;
    private String installType;
    private String password;
    private String updateDescription;
    private String qrcodePath;
    private String envVarsPath;

    @DataBoundConstructor
    public UploadBuilder(String uKey, String apiKey, String scanDir, String wildcard, String installType, String password, String updateDescription, String qrcodePath, String envVarsPath) {
        this.uKey = uKey;
        this.apiKey = apiKey;
        this.scanDir = scanDir;
        this.wildcard = wildcard;
        this.installType = installType;
        this.password = password;
        this.updateDescription = updateDescription;
        this.qrcodePath = qrcodePath;
        this.envVarsPath = envVarsPath;
    }

    public String getuKey() {
        return this.uKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getScanDir() {
        return this.scanDir;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getInstallType() {
        return this.installType;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUpdateDescription() {
        return this.updateDescription;
    }

    public String getQrcodePath() {
        return this.qrcodePath;
    }

    public String getEnvVarsPath() {
        return this.envVarsPath;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ParamsBeanV1 paramsBeanV1 = new ParamsBeanV1();
        paramsBeanV1.setUkey(this.uKey);
        paramsBeanV1.setApiKey(this.apiKey);
        paramsBeanV1.setScandir(this.scanDir);
        paramsBeanV1.setWildcard(this.wildcard);
        paramsBeanV1.setInstallType(this.installType);
        paramsBeanV1.setPassword(this.password);
        paramsBeanV1.setUpdateDescription(this.updateDescription);
        paramsBeanV1.setQrcodePath(this.qrcodePath);
        paramsBeanV1.setEnvVarsPath(this.envVarsPath);
        return PgyerV1Helper.upload(build, listener, paramsBeanV1);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"upload-pgyer"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckUKey(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a uKey");
            }
            if (!value.matches("[A-Za-z0-9]{32}")) {
                return FormValidation.warning((String)"Is this correct?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApiKey(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a api_key");
            }
            if (!value.matches("[A-Za-z0-9]{32}")) {
                return FormValidation.warning((String)"Is this correct?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckScanDir(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set upload ipa or apk file base dir name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckWildcard(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set upload ipa or apk file wildcard");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckInstallType(@QueryParameter int value) throws IOException, ServletException {
            if (value < 1 || value > 3) {
                return FormValidation.error((String)"application installation, the value is (1,2,3).");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a password");
            }
            if (value.length() < 6) {
                return FormValidation.warning((String)"Isn't the password too short?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Upload to pgyer with apiV1";
        }
    }
}

