/*
 * Decompiled with CFR 0.152.
 */
package redhat.jenkins.plugins.crda.utils;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.io.IOException;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import redhat.jenkins.plugins.crda.credentials.CRDAKey;
import redhat.jenkins.plugins.crda.utils.CRDAInstallation;
import redhat.jenkins.plugins.crda.utils.CommandExecutor;

public class Utils {
    public static String doInstall(String cliVersion, PrintStream logger) {
        CRDAInstallation cri = new CRDAInstallation();
        return cri.install(cliVersion, logger);
    }

    public static String doExecute(String cmd, PrintStream logger, Map<String, String> envs) {
        return new CommandExecutor().execute(cmd, logger, envs);
    }

    public static boolean isJSONValid(String test) {
        try {
            new JSONObject(test);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(test);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public static boolean urlExists(String urlStr) {
        int responseCode = 404;
        try {
            URL url = new URL(urlStr);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            responseCode = huc.getResponseCode();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 200 == responseCode;
    }

    public static String getOperatingSystem() {
        String os = System.getProperty("os.name");
        return os;
    }

    public static boolean isWindows() {
        String os = Utils.getOperatingSystem();
        return os.toLowerCase().contains("win");
    }

    public static boolean isLinux() {
        String os = Utils.getOperatingSystem();
        return os.toLowerCase().contains("lin");
    }

    public static boolean isMac() {
        String os = Utils.getOperatingSystem();
        return os.toLowerCase().contains("mac");
    }

    public static String getCRDACredential(String id) throws IOException, InterruptedException {
        CRDAKey crdaKey = (CRDAKey)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(CRDAKey.class, (ItemGroup)Jenkins.getInstanceOrNull(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)id));
        return crdaKey != null ? crdaKey.getKey().getPlainText() : null;
    }

    public static boolean is32() {
        return System.getProperty("sun.arch.data.model").equals("32");
    }

    public static boolean is64() {
        return System.getProperty("sun.arch.data.model").equals("64");
    }
}

