/*
 * Decompiled with CFR 0.152.
 */
package redhat.jenkins.plugins.crda.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import redhat.jenkins.plugins.crda.utils.CommandExecutor;
import redhat.jenkins.plugins.crda.utils.Utils;

public class CRDAInstallation {
    private Boolean isWindows;
    private Boolean isMac = Utils.isMac();

    public CRDAInstallation() {
        this.isWindows = Utils.isWindows();
    }

    private Boolean downloadFile(String fromUrl, String dirPath, String localFileName, PrintStream logger) throws IOException, SecurityException {
        int numRead;
        File theDir = new File(dirPath);
        Boolean success = false;
        if (!theDir.exists() && !(success = Boolean.valueOf(theDir.mkdirs())).booleanValue()) {
            logger.println("Directory creation failed.");
            return success;
        }
        File localFile = new File(localFileName);
        if (localFile.exists() && !(success = Boolean.valueOf(localFile.delete())).booleanValue()) {
            logger.println("Deletion of existing file failed.");
            return success;
        }
        success = localFile.createNewFile();
        if (!success.booleanValue()) {
            logger.println("New file creation failed.");
            return success;
        }
        URL url = new URL(fromUrl);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localFileName));
        URLConnection conn = url.openConnection();
        InputStream in = conn.getInputStream();
        byte[] buffer = new byte[1024];
        while ((numRead = in.read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, numRead);
        }
        if (in != null) {
            in.close();
        }
        if (out != null) {
            ((OutputStream)out).close();
        }
        return success;
    }

    private String getCliJarName(String version) {
        String name = "Linux_64bit.tar.gz";
        if (this.isWindows.booleanValue()) {
            name = "Windows_64bit.tar.gz";
        } else if (this.isMac.booleanValue()) {
            name = "macOS_64bit.tar.gz";
        }
        return "crda_" + version + "_" + name;
    }

    private String getFileLocation() {
        String baseDir = System.getenv("HOME") + File.separator + ".crda";
        return baseDir;
    }

    private Boolean isVersionCorrect(String fileLoc, String cliVersion, PrintStream logger) {
        String results = new CommandExecutor().execute("crda version".replace("crda", fileLoc), logger);
        Pattern pattern = Pattern.compile("^v[0-9]+\\.[0-9]+\\.[0-9]+.*", 2);
        Matcher matcher = pattern.matcher(results);
        if (matcher.find()) {
            String curVer = results.split("-")[0].replace("v", "");
            if (curVer.startsWith(cliVersion)) {
                logger.println("CRDA CLI version is up to date as per the requirement " + cliVersion);
                return true;
            }
            logger.println("CRDA CLI version " + curVer + " is currently installed. Will be updated with " + cliVersion);
            return false;
        }
        logger.println("Cannot verify current installed CRDA CLI version");
        return false;
    }

    private Boolean isCliInstalled(String fileLoc, String cliVersion, PrintStream logger) {
        File localFile = new File(fileLoc = fileLoc + File.separator + "crda");
        if (localFile.exists()) {
            if (this.isVersionCorrect(fileLoc, cliVersion, logger).booleanValue()) {
                return true;
            }
            Boolean delStatus = localFile.delete();
            if (delStatus.booleanValue()) {
                logger.println("Current CRDA CLI successfully deleted");
            }
            return false;
        }
        return false;
    }

    public void extractArtifact(String destDir, String fileZip) {
        TarGZipUnArchiver ua = new TarGZipUnArchiver(new File(fileZip));
        ua.setDestDirectory(new File(destDir));
        ua.enableLogging((Logger)new ConsoleLogger(5, "console"));
        ua.extract();
    }

    public String install(String cliVersion, PrintStream logger) {
        CRDAInstallation cr = new CRDAInstallation();
        String url = "https://github.com/fabric8-analytics/cli-tools/releases/download/version/clijar";
        url = url.replace("version", "v" + cliVersion);
        String filename = cr.getCliJarName(cliVersion);
        url = url.replace("clijar", filename);
        String fileLoc = cr.getFileLocation();
        String fileZip = fileLoc + File.separator + filename;
        if (!cr.isCliInstalled(fileLoc, cliVersion, logger).booleanValue()) {
            logger.println("Installation step for CRDA CLI in progress.");
            try {
                Boolean success = cr.downloadFile(url, fileLoc, fileZip, logger);
                if (!success.booleanValue()) {
                    logger.println("Download step for CRDA CLI failed.");
                    return "Failed";
                }
                cr.extractArtifact(fileLoc, fileZip);
                logger.println("Installation of CRDA CLI finished.");
            }
            catch (IOException e) {
                logger.println(e);
            }
            catch (SecurityException e) {
                logger.println(e);
            }
        } else {
            logger.println("CRDA CLI already installed.Ready to use.");
        }
        return fileLoc + File.separator;
    }
}

