/*
 * Decompiled with CFR 0.152.
 */
package redhat.jenkins.plugins.crda.task;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import redhat.jenkins.plugins.crda.action.CRDAAction;
import redhat.jenkins.plugins.crda.credentials.CRDAKey;
import redhat.jenkins.plugins.crda.task.Messages;
import redhat.jenkins.plugins.crda.utils.Utils;

public class CRDABuilder
extends Builder
implements SimpleBuildStep {
    private String file;
    private String crdaKeyId;
    private String cliVersion;
    private boolean consentTelemetry = false;

    @DataBoundConstructor
    public CRDABuilder(String file, String crdaKeyId, String cliVersion, boolean consentTelemetry) {
        this.file = file;
        this.crdaKeyId = crdaKeyId;
        this.cliVersion = cliVersion;
        this.consentTelemetry = consentTelemetry;
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    public String getCliVersion() {
        return this.cliVersion;
    }

    @DataBoundSetter
    public void setCliVersion(String cliVersion) {
        this.cliVersion = cliVersion;
    }

    public String getCrdaKeyId() {
        return this.crdaKeyId;
    }

    @DataBoundSetter
    public void setCrdaKeyId(String crdaKeyId) {
        this.crdaKeyId = crdaKeyId;
    }

    public boolean getConsentTelemetry() {
        return this.consentTelemetry;
    }

    @DataBoundSetter
    public void setConsentTelemetry(boolean consentTelemetry) {
        this.consentTelemetry = consentTelemetry;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String baseDir;
        PrintStream logger = listener.getLogger();
        logger.println("----- CRDA Analysis Begins -----");
        String crdaUuid = Utils.getCRDACredential(this.getCrdaKeyId());
        String cliVersion = this.getCliVersion();
        if (cliVersion == null) {
            cliVersion = "0.2.0";
            logger.println("No CRDA Cli version provided. Taking the default version " + cliVersion);
        }
        if (cliVersion.startsWith("v")) {
            cliVersion = cliVersion.replace("v", "");
        }
        if ((baseDir = Utils.doInstall(cliVersion, logger)).equals("Failed")) {
            logger.println("Error during installation process.");
            return;
        }
        String cmd = "crda analyse filepath -j -c --client jenkins".replace("filepath", this.getFile());
        cmd = baseDir + cmd;
        logger.println("Contribution towards anonymous usage stats is set to " + this.getConsentTelemetry());
        logger.println("Analysis Begins");
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("CRDA_KEY", crdaUuid);
        envs.put("CONSENT_TELEMETRY", String.valueOf(this.getConsentTelemetry()));
        String results = Utils.doExecute(cmd, logger, envs);
        if (results.equals("") || results.equals("0") || !Utils.isJSONValid(results)) {
            logger.println("Analysis returned no results.");
            return;
        }
        logger.println("....Analysis Summary....");
        JSONObject res = new JSONObject(results);
        Iterator keys = res.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            logger.println("\t" + key.replace("_", " ") + " : " + res.get(key));
        }
        logger.println("Click on the CRDA Stack Report icon to view the detailed report.");
        logger.println("----- CRDA Analysis Ends -----");
        run.addAction((Action)new CRDAAction(crdaUuid, res));
    }

    @Extension
    public static final class BuilderDescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public BuilderDescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckFile(@QueryParameter String file) throws IOException, ServletException {
            if (file.length() == 0) {
                return FormValidation.error((String)Messages.CRDABuilder_DescriptorImpl_errors_missingFileName());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCrdaKeyId(@QueryParameter String crdaKeyId) throws IOException, ServletException {
            int len = crdaKeyId.length();
            if (len == 0) {
                return FormValidation.error((String)Messages.CRDABuilder_DescriptorImpl_errors_missingUuid());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCliVersion(@QueryParameter String cliVersion) throws IOException, ServletException {
            int len = cliVersion.length();
            if (len == 0) {
                return FormValidation.ok();
            }
            if (!Utils.urlExists("https://github.com/fabric8-analytics/cli-tools/releases/version".replace("version", cliVersion))) {
                return FormValidation.error((String)Messages.CRDABuilder_DescriptorImpl_errors_incorrectCli());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCrdaKeyIdItems(@AncestorInPath Item item, @QueryParameter String crdaKeyId) {
            Jenkins jenkins;
            StandardListBoxModel model = new StandardListBoxModel();
            if (item == null ? !(jenkins = Jenkins.getInstance()).hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return model.includeCurrentValue(crdaKeyId);
            }
            return model.includeEmptyValue().includeAs(ACL.SYSTEM, item, CRDAKey.class).includeCurrentValue(crdaKeyId);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.CRDABuilder_DescriptorImpl_DisplayName();
        }
    }
}

