/*
 * Decompiled with CFR 0.152.
 */
package redhat.jenkins.plugins.crda.step;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletException;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import redhat.jenkins.plugins.crda.action.CRDAAction;
import redhat.jenkins.plugins.crda.task.CRDABuilder;
import redhat.jenkins.plugins.crda.utils.Utils;

public final class CRDAStep
extends Step {
    private String file;
    private String crdaKeyId;
    private String cliVersion;
    private boolean consentTelemetry = false;

    @DataBoundConstructor
    public CRDAStep(String file, String crdaKeyId, String cliVersion, boolean consentTelemetry) {
        this.file = file;
        this.crdaKeyId = crdaKeyId;
        this.cliVersion = cliVersion;
        this.consentTelemetry = consentTelemetry;
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    public String getCliVersion() {
        return this.cliVersion;
    }

    @DataBoundSetter
    public void setCliVersion(String cliVersion) {
        this.cliVersion = cliVersion;
    }

    public String getCrdaKeyId() {
        return this.crdaKeyId;
    }

    @DataBoundSetter
    public void setCrdaKeyId(String crdaKeyId) {
        this.crdaKeyId = crdaKeyId;
    }

    public boolean getConsentTelemetry() {
        return this.consentTelemetry;
    }

    @DataBoundSetter
    public void setConsentTelemetry(boolean consentTelemetry) {
        this.consentTelemetry = consentTelemetry;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Extension
    @Symbol(value={"crdaAnalysis"})
    public static class DescriptorImpl
    extends StepDescriptor {
        private final CRDABuilder.BuilderDescriptorImpl builderDescriptor = new CRDABuilder.BuilderDescriptorImpl();

        public ListBoxModel doFillCrdaKeyIdItems(@AncestorInPath Item item, @QueryParameter String crdaKeyId) {
            return this.builderDescriptor.doFillCrdaKeyIdItems(item, crdaKeyId);
        }

        public FormValidation doCheckCrdaKeyId(@QueryParameter String crdaKeyId) throws IOException, ServletException {
            return this.builderDescriptor.doCheckCrdaKeyId(crdaKeyId);
        }

        public FormValidation doCheckFile(@QueryParameter String file) throws IOException, ServletException {
            return this.builderDescriptor.doCheckFile(file);
        }

        public FormValidation doCheckCliVersion(@QueryParameter String cliVersion) throws IOException, ServletException {
            return this.builderDescriptor.doCheckCliVersion(cliVersion);
        }

        public String getFunctionName() {
            return "crdaAnalysis";
        }

        public String getDisplayName() {
            return "Invoke Red Hat Codeready Dependency Analysis (CRDA)";
        }

        public Set<Class<?>> getRequiredContext() {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(FilePath.class, Run.class, TaskListener.class)));
        }
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<String> {
        private final transient CRDAStep step;
        private static final long serialVersionUID = 1L;

        protected Execution(CRDAStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected String run() throws Exception {
            PrintStream logger = ((TaskListener)this.getContext().get(TaskListener.class)).getLogger();
            logger.println("----- CRDA Analysis Begins -----");
            String crdaUuid = "";
            String filePath = this.step.getFile();
            if (filePath == null) {
                logger.println("Filepath for the manifest file not provided. Please configure the build properly and retry.");
                return "1";
            }
            crdaUuid = Utils.getCRDACredential(this.step.crdaKeyId);
            if (crdaUuid == null) {
                logger.println("CRDA Key id '" + this.step.crdaKeyId + "' was not found in the credentials. Please configure the build properly and retry.");
                return "1";
            }
            if (crdaUuid.equals("")) {
                logger.println("CRDA Key id '" + this.step.crdaKeyId + "' was not found in the credentials. Please configure the build properly and retry.");
                return "1";
            }
            String cliVersion = this.step.getCliVersion();
            if (cliVersion == null) {
                cliVersion = "0.2.0";
                logger.println("No CRDA Cli version provided. Taking the default version " + cliVersion);
            } else if (!Utils.urlExists("https://github.com/fabric8-analytics/cli-tools/releases/version".replace("version", cliVersion))) {
                cliVersion = "0.2.0";
                logger.println("No such version of CRDA CLI exist. Taking default version " + cliVersion);
            } else {
                cliVersion = cliVersion.replace("v", "");
            }
            String baseDir = Utils.doInstall(cliVersion, logger);
            if (baseDir.equals("Failed")) {
                return "1";
            }
            logger.println("Contribution towards anonymous usage stats is set to " + this.step.getConsentTelemetry());
            String cmd = "crda analyse filepath -j -c --client jenkins".replace("filepath", filePath);
            cmd = baseDir + cmd;
            logger.println("Analysis Begins");
            HashMap<String, String> envs = new HashMap<String, String>();
            envs.put("CRDA_KEY", crdaUuid);
            envs.put("CONSENT_TELEMETRY", String.valueOf(this.step.getConsentTelemetry()));
            String results = Utils.doExecute(cmd, logger, envs);
            if (results.equals("") || results.equals("0") || !Utils.isJSONValid(results)) {
                logger.println("Analysis returned no results.");
                return "1";
            }
            logger.println("....Analysis Summary....");
            JSONObject res = new JSONObject(results);
            Iterator keys = res.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                logger.println("\t" + key.replace("_", " ") + " : " + res.get(key));
            }
            logger.println("Click on the CRDA Stack Report icon to view the detailed report.");
            Run run = (Run)this.getContext().get(Run.class);
            run.addAction((Action)new CRDAAction(crdaUuid, res));
            logger.println("----- CRDA Analysis Ends -----");
            return res.getInt("total_vulnerabilities") == 0 ? "0" : "2";
        }
    }
}

