/*
 * Decompiled with CFR 0.152.
 */
package pl.damianszczepanik.jenkins.buildhistorymanager.model.conditions;

import hudson.FilePath;
import hudson.Util;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.RuleConfiguration;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.conditions.Condition;

public class TokenMacroCondition
extends Condition {
    private static final Logger LOG = Logger.getLogger(TokenMacroCondition.class.getName());
    private String template;
    private String value;

    @DataBoundConstructor
    public TokenMacroCondition(String template, String value) {
        this.template = Util.fixNull((String)template);
        this.value = Util.fixNull((String)value);
    }

    public String getTemplate() {
        return this.template;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean matches(Run<?, ?> run, RuleConfiguration configuration) {
        try {
            File workspace = run.getRootDir();
            String evaluatedMacro = TokenMacro.expandAll(run, (FilePath)new FilePath(workspace), null, (String)this.template);
            LOG.log(Level.INFO, () -> String.format("Evaluated macro '%s' to '%s'", this.template, evaluatedMacro));
            return StringUtils.defaultString((String)this.value).equals(evaluatedMacro);
        }
        catch (IOException | InterruptedException | MacroEvaluationException e) {
            LOG.log(Level.WARNING, () -> this.lambda$matches$1(run, (Exception)e));
            return false;
        }
    }

    private /* synthetic */ String lambda$matches$1(Run run, Exception e) {
        return String.format("Exception when processing template '%s' for build #%d: %s", this.template, run.getNumber(), e.getMessage());
    }
}

