/*
 * Decompiled with CFR 0.152.
 */
package pl.damianszczepanik.jenkins.buildhistorymanager;

import hudson.Util;
import hudson.model.Job;
import hudson.model.Run;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.BuildDiscarder;
import org.kohsuke.stapler.DataBoundConstructor;
import pl.damianszczepanik.jenkins.buildhistorymanager.model.Rule;

public class BuildHistoryManager
extends BuildDiscarder {
    private static final Logger LOG = Logger.getLogger(BuildHistoryManager.class.getName());
    private final List<Rule> rules;

    @DataBoundConstructor
    public BuildHistoryManager(List<Rule> rules) {
        this.rules = Util.fixNull(rules);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public synchronized void perform(Job<?, ?> job) throws IOException, InterruptedException {
        String uniquePerformName = job.getFullName();
        BuildHistoryManager.log(uniquePerformName, "Start evaluating build history for build " + job.getFullName());
        for (Rule rule : this.rules) {
            rule.initialize(uniquePerformName);
        }
        for (Run run = job.getLastCompletedBuild(); run != null; run = run.getPreviousCompletedBuild()) {
            BuildHistoryManager.log(uniquePerformName, "Processing build #" + run.getNumber());
            if (run.isKeepLog()) {
                BuildHistoryManager.log(uniquePerformName, "Build #" + run.getNumber() + " is marked as keep forever -> skip processing");
                continue;
            }
            this.processRules(run, uniquePerformName);
        }
    }

    private void processRules(Run<?, ?> run, String uniquePerformName) throws IOException, InterruptedException {
        for (int i = 0; i < this.rules.size(); ++i) {
            Rule rule = this.rules.get(i);
            BuildHistoryManager.log(uniquePerformName, "Processing rule no " + (i + 1));
            if (!rule.validateConditions(run)) continue;
            BuildHistoryManager.log(uniquePerformName, "Processing actions for rule no " + (i + 1));
            rule.performActions(run);
            if (!rule.getContinueAfterMatch()) break;
        }
    }

    private static void log(String jobName, String message) {
        LOG.log(Level.FINE, () -> String.format("[%s] %s", jobName, message));
    }
}

