/*
 * Decompiled with CFR 0.152.
 */
package org.openshift.jenkins.plugins.openshiftlogin;

import hudson.EnvVars;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftOAuth2SecurityRealm;

public class OpenShiftSetOAuth {
    static final Logger LOGGER = Logger.getLogger(OpenShiftSetOAuth.class.getName());
    static final String OPENSHIFT_ENABLE_OAUTH = "OPENSHIFT_ENABLE_OAUTH";

    static boolean setOauth() {
        SecurityRealm priorSecurityRealm;
        Jenkins jenkins = Jenkins.getInstance();
        String enabled = (String)EnvVars.masterEnvVars.get(OPENSHIFT_ENABLE_OAUTH);
        if (jenkins != null && enabled != null && !enabled.equalsIgnoreCase("false") && !((priorSecurityRealm = jenkins.getSecurityRealm()) instanceof OpenShiftOAuth2SecurityRealm)) {
            LOGGER.info("OpenShift OAuth: enable oauth set to " + enabled);
            LOGGER.info("OpenShift OAuth: configured security realm on startup: " + priorSecurityRealm);
            try {
                boolean inOpenShiftPod;
                OpenShiftOAuth2SecurityRealm osrealm;
                block7: {
                    osrealm = new OpenShiftOAuth2SecurityRealm(null, null, null, null, null, null);
                    inOpenShiftPod = false;
                    try {
                        inOpenShiftPod = osrealm.populateDefaults();
                    }
                    catch (Throwable t) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block7;
                        LOGGER.log(Level.FINE, "OpenShiftItemListener", t);
                    }
                }
                LOGGER.info("OpenShift OAuth: running in OpenShift pod with required OAuth features: " + inOpenShiftPod);
                if (inOpenShiftPod) {
                    jenkins.setSecurityRealm((SecurityRealm)osrealm);
                    LOGGER.info("OpenShift OAuth: Jenkins security realm set to OpenShift OAuth");
                    return true;
                }
            }
            catch (IOException iOException) {
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
        }
        return false;
    }
}

