/*
 * Decompiled with CFR 0.152.
 */
package org.openshift.jenkins.plugins.openshiftlogin;

import hudson.EnvVars;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import org.openshift.jenkins.plugins.openshiftlogin.OAuthSession;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftOAuth2SecurityRealm;

public class OpenShiftPermissionFilter
implements Filter {
    private static final String LAST_SELF_SAR_POLL_TIME = "self-sar-time";
    private static final long SELF_SAR_POLL_INTERVAL = 300000L;
    private static final String OPENSHIFT_PERMISSIONS_POLL_INTERVAL = "OPENSHIFT_PERMISSIONS_POLL_INTERVAL";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block10: {
            try {
                OAuthSession oauth;
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                HttpSession s = httpRequest.getSession(false);
                if (s == null || (oauth = (OAuthSession)s.getAttribute(OAuthSession.SESSION_NAME)) == null || oauth.getCredential() == null) break block10;
                try {
                    Long lastPermissionPoll = (Long)s.getAttribute(OAuthSession.SESSION_NAME + LAST_SELF_SAR_POLL_TIME);
                    if (lastPermissionPoll == null) {
                        lastPermissionPoll = new Long(System.currentTimeMillis());
                        s.setAttribute(OAuthSession.SESSION_NAME + LAST_SELF_SAR_POLL_TIME, (Object)new Long(System.currentTimeMillis()));
                    }
                    long interval = 300000L;
                    String var = (String)EnvVars.masterEnvVars.get(OPENSHIFT_PERMISSIONS_POLL_INTERVAL);
                    if (var != null) {
                        try {
                            interval = Long.parseLong(var);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (System.currentTimeMillis() - lastPermissionPoll > interval * 1000L) {
                        OpenShiftOAuth2SecurityRealm secRealm = (OpenShiftOAuth2SecurityRealm)Jenkins.getInstance().getSecurityRealm();
                        secRealm.updateAuthorizationStrategy(oauth);
                        s.setAttribute(OAuthSession.SESSION_NAME + LAST_SELF_SAR_POLL_TIME, (Object)new Long(System.currentTimeMillis()));
                    }
                }
                catch (Throwable t) {
                    OpenShiftOAuth2SecurityRealm.LOGGER.log(Level.SEVERE, "filter", t);
                }
            }
            finally {
                chain.doFilter(request, response);
            }
        }
    }

    public void destroy() {
    }
}

