/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import edu.umd.cs.findbugs.annotations.NonNull;
import jakarta.servlet.ServletContext;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.XMLOutputFactory;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.jelly.CustomJellyContext;
import org.kohsuke.stapler.jelly.HTMLWriterOutput;
import org.kohsuke.stapler.jelly.ScriptInvoker;

public class DefaultScriptInvoker
implements ScriptInvoker,
XMLOutputFactory {
    @Override
    public void invokeScript(StaplerRequest2 req, StaplerResponse2 rsp, Script script, Object it) throws IOException, JellyTagException {
        XMLOutput xmlOutput = this.createXMLOutput(req, rsp, script, it);
        this.invokeScript(req, rsp, script, it, xmlOutput);
        xmlOutput.flush();
        xmlOutput.close();
    }

    @Override
    public void invokeScript(StaplerRequest2 req, StaplerResponse2 rsp, Script script, Object it, XMLOutput out) throws IOException, JellyTagException {
        JellyContext context = this.createContext(req, rsp, script, it);
        this.exportVariables(req, rsp, script, it, context);
        script.run(context, out);
    }

    protected XMLOutput createXMLOutput(StaplerRequest2 req, StaplerResponse2 rsp, Script script, Object it) throws IOException {
        String ct = rsp.getContentType();
        HTMLWriterOutput output = ct != null && !ct.startsWith("text/html") ? XMLOutput.createXMLOutput((OutputStream)this.createOutputStream(req, rsp, script, it)) : HTMLWriterOutput.create(this.createOutputStream(req, rsp, script, it));
        return output;
    }

    protected OutputStream createOutputStream(StaplerRequest2 req, StaplerResponse2 rsp, Script script, Object it) throws IOException {
        final LazyOutputStreamSupplier out = new LazyOutputStreamSupplier(() -> {
            req.getWebApp().getDispatchValidator().requireDispatchAllowed(req, rsp);
            return new BufferedOutputStream((OutputStream)rsp.getOutputStream());
        });
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                out.get().write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                out.get().write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                out.get().write(b, off, len);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                out.get().close();
            }
        };
    }

    protected void exportVariables(StaplerRequest2 req, StaplerResponse2 rsp, Script script, Object it, JellyContext context) {
        Enumeration en = req.getAttributeNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            context.setVariable(name, req.getAttribute(name));
        }
        context.setVariable("request", (Object)StaplerRequest.fromStaplerRequest2((StaplerRequest2)req));
        context.setVariable("response", (Object)StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
        context.setVariable("request2", (Object)req);
        context.setVariable("response2", (Object)rsp);
        context.setVariable("it", it);
        ServletContext servletContext = req.getServletContext();
        context.setVariable("servletContext", (Object)servletContext);
        context.setVariable("app", servletContext.getAttribute("app"));
        context.setVariable("requestScope", (Object)context.getVariables());
        context.setVariable("org.apache.commons.jelly.tags.fmt.locale", (Object)req.getLocale());
    }

    protected JellyContext createContext(StaplerRequest2 req, StaplerResponse2 rsp, Script script, Object it) {
        CustomJellyContext context = new CustomJellyContext();
        context.setClassLoader(req.getWebApp().getClassLoader());
        context.setVariable(XMLOutputFactory.class.getName(), this);
        return context;
    }

    public XMLOutput createXMLOutput(Writer writer, boolean escapeText) {
        String ct;
        StaplerResponse2 rsp = Stapler.getCurrentResponse2();
        String string = ct = rsp != null ? rsp.getContentType() : "?";
        if (ct != null && !ct.startsWith("text/html")) {
            return XMLOutput.createXMLOutput((Writer)writer, (boolean)escapeText);
        }
        return HTMLWriterOutput.create(writer, escapeText);
    }

    private static class LazyOutputStreamSupplier
    implements OutputStreamSupplier {
        private final OutputStreamSupplier supplier;
        private volatile OutputStream out;

        private LazyOutputStreamSupplier(OutputStreamSupplier supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NonNull
        public OutputStream get() throws IOException {
            if (this.out == null) {
                LazyOutputStreamSupplier lazyOutputStreamSupplier = this;
                synchronized (lazyOutputStreamSupplier) {
                    if (this.out == null) {
                        this.out = this.supplier.get();
                    }
                }
            }
            return this.out;
        }
    }

    private static interface OutputStreamSupplier {
        @NonNull
        public OutputStream get() throws IOException;
    }
}

