/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.bind.Bound;
import org.kohsuke.stapler.bind.BoundObjectTable;
import org.kohsuke.stapler.jelly.AbstractStaplerTag;
import org.kohsuke.stapler.jelly.AdjunctTag;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BindTag
extends AbstractStaplerTag {
    private String varName;
    private Object javaObject;

    public void setVar(String varName) {
        this.varName = varName;
    }

    public void setValue(Object o) {
        this.javaObject = o;
    }

    public void doTag(XMLOutput out) throws JellyTagException {
        AdjunctTag a = new AdjunctTag();
        a.setContext(this.getContext());
        a.setIncludes("org.kohsuke.stapler.bind");
        a.doTag(out);
        try {
            if (this.javaObject == null) {
                if (this.varName == null) {
                    out.write("null");
                } else {
                    this.writeScriptTag(out, null);
                }
            } else {
                Bound h = WebApp.getCurrent().boundObjectTable.bind(this.javaObject);
                if (this.varName == null) {
                    out.write(h.getProxyScript());
                } else if (!BoundObjectTable.isValidJavaScriptIdentifier((String)this.varName)) {
                    out.startElement("script");
                    out.write(this.varName + "=" + h.getProxyScript() + ";");
                    out.endElement("script");
                } else {
                    this.writeScriptTag(out, h);
                }
            }
        }
        catch (SAXException e) {
            throw new JellyTagException((Throwable)e);
        }
    }

    private void writeScriptTag(XMLOutput out, @CheckForNull Bound bound) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        if (bound == null) {
            attributes.addAttribute("", "src", "src", "", Bound.getProxyScriptURL((String)this.varName, null));
        } else {
            attributes.addAttribute("", "src", "src", "", bound.getProxyScriptURL(this.varName));
        }
        attributes.addAttribute("", "type", "type", "", "text/javascript");
        out.startElement("script", (Attributes)attributes);
        out.endElement("script");
    }
}

