/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly.groovy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.xml.QName;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.beanutils.ConvertingWrapDynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.jelly.DynaTag;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.ConstantExpression;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.impl.TagScript;
import org.apache.commons.jelly.impl.TextScript;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXContentHandler;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.adjunct.AdjunctManager;
import org.kohsuke.stapler.framework.adjunct.AdjunctsInPage;
import org.kohsuke.stapler.framework.adjunct.NoSuchAdjunctException;
import org.kohsuke.stapler.jelly.CustomTagLibrary;
import org.kohsuke.stapler.jelly.JellyClassLoaderTearOff;
import org.kohsuke.stapler.jelly.JellyClassTearOff;
import org.kohsuke.stapler.jelly.groovy.GroovyClosureScript;
import org.kohsuke.stapler.jelly.groovy.Namespace;
import org.kohsuke.stapler.jelly.groovy.TagLibraryUri;
import org.kohsuke.stapler.jelly.groovy.TypedTagLibrary;
import org.kohsuke.stapler.lang.Klass;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class JellyBuilder
extends GroovyObjectSupport {
    private XMLOutput output;
    private JellyContext context;
    private final Map<Class, GroovyClosureScript> taglibs = new HashMap<Class, GroovyClosureScript>();
    private final StaplerRequest request;
    private StaplerResponse response;
    private String rootURL;
    private final AdjunctManager adjunctManager;
    private final AttributesImpl attributes = new AttributesImpl();
    private static final Script NULL_SCRIPT = new Script(){

        public Script compile() {
            return this;
        }

        public void run(JellyContext context, XMLOutput output) {
        }
    };
    private static final Object MISSING = new Object();

    public JellyBuilder(JellyContext context, XMLOutput output) {
        this.context = context;
        this.output = output;
        this.request = Stapler.getCurrentRequest();
        this.adjunctManager = AdjunctManager.get((ServletContext)this.request.getServletContext());
    }

    public Namespace namespace(String nsUri, String prefix) {
        return new Namespace(this, nsUri, prefix);
    }

    public Namespace namespace(String nsUri) {
        return this.namespace(nsUri, null);
    }

    public <T extends TypedTagLibrary> T namespace(Class<T> type) {
        TagLibraryUri a = type.getAnnotation(TagLibraryUri.class);
        if (a == null) {
            throw new IllegalArgumentException(type + " doesn't have @TagLibraryUri annotation");
        }
        return this.namespace(a.value(), null).createInvoker(type);
    }

    public XMLOutput getOutput() {
        return this.output;
    }

    public JellyContext getContext() {
        return this.context;
    }

    public void include(Object it, String view) throws IOException, JellyException {
        this._include(it, this.request.getWebApp().getKlass(it), view);
    }

    public void include(Class clazz, String view) throws IOException, JellyException {
        this._include(null, Klass.java((Class)clazz), view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _include(Object it, Klass clazz, String view) throws IOException, JellyException {
        JellyClassTearOff t = (JellyClassTearOff)this.request.getWebApp().getMetaClass(clazz).loadTearOff(JellyClassTearOff.class);
        Script s = (Script)t.findScript(view);
        if (s == null) {
            throw new IllegalArgumentException("No such view: " + view + " for " + clazz);
        }
        JellyContext context = new JellyContext(this.getContext());
        if (it != null) {
            context.setVariable("it", it);
        }
        context.setVariable("from", it);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        if (clazz.clazz instanceof Class) {
            Thread.currentThread().setContextClassLoader(((Class)clazz.clazz).getClassLoader());
        }
        try {
            s.run(context, this.output);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public Object methodMissing(String name, Object args) {
        this.doInvokeMethod(new QName("", name), args);
        return null;
    }

    protected void doInvokeMethod(QName name, Object args) {
        List list = InvokerHelper.asList((Object)args);
        Map attributes = Collections.EMPTY_MAP;
        Closure closure = null;
        String innerText = null;
        switch (list.size()) {
            case 0: {
                break;
            }
            case 1: {
                Object object = list.get(0);
                if (object instanceof Map) {
                    attributes = (Map)object;
                    break;
                }
                if (object instanceof Closure) {
                    closure = (Closure)object;
                    break;
                }
                if (object == null) break;
                innerText = object.toString();
                break;
            }
            case 2: {
                Object object1 = list.get(0);
                Object object2 = list.get(1);
                if (object1 instanceof Map) {
                    attributes = (Map)object1;
                    if (object2 instanceof Closure) {
                        closure = (Closure)object2;
                        break;
                    }
                    if (object2 == null) break;
                    innerText = object2.toString();
                    break;
                }
                innerText = object1.toString();
                if (object2 instanceof Closure) {
                    closure = (Closure)object2;
                    break;
                }
                if (object2 instanceof Map) {
                    attributes = (Map)object2;
                    break;
                }
                throw new MissingMethodException(name.toString(), ((Object)((Object)this)).getClass(), list.toArray());
            }
            case 3: {
                Object arg0 = list.get(0);
                Object arg1 = list.get(1);
                Object arg2 = list.get(2);
                if (arg0 instanceof Map && arg2 instanceof Closure) {
                    closure = (Closure)arg2;
                    attributes = (Map)arg0;
                    innerText = arg1.toString();
                    break;
                }
                if (arg1 instanceof Map && arg2 instanceof Closure) {
                    closure = (Closure)arg2;
                    attributes = (Map)arg1;
                    innerText = arg0.toString();
                    break;
                }
                throw new MissingMethodException(name.toString(), ((Object)((Object)this)).getClass(), list.toArray());
            }
            default: {
                throw new MissingMethodException(name.toString(), ((Object)((Object)this)).getClass(), list.toArray());
            }
        }
        if (this.isTag(name)) {
            try {
                TagScript tagScript = this.createTagScript(name, attributes);
                if (tagScript != null) {
                    Script body = NULL_SCRIPT;
                    if (closure != null) {
                        final Closure theClosure = closure;
                        body = new Script(){

                            public Script compile() throws JellyException {
                                return this;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run(JellyContext context, XMLOutput output) throws JellyTagException {
                                JellyContext oldc = JellyBuilder.this.setContext(context);
                                XMLOutput oldo = JellyBuilder.this.setOutput(output);
                                try {
                                    theClosure.setDelegate((Object)JellyBuilder.this);
                                    theClosure.call();
                                }
                                finally {
                                    JellyBuilder.this.setContext(oldc);
                                    JellyBuilder.this.setOutput(oldo);
                                }
                            }
                        };
                    } else if (innerText != null) {
                        body = new TextScript(innerText);
                    }
                    tagScript.setTagBody(body);
                    tagScript.run(this.context, this.output);
                    return;
                }
            }
            catch (JellyException e) {
                throw new RuntimeException(e);
            }
        }
        this.attributes.clear();
        for (Map.Entry e : attributes.entrySet()) {
            Object v = e.getValue();
            if (v == null) continue;
            String attName = e.getKey().toString();
            this.attributes.addAttribute("", attName, attName, "CDATA", v.toString());
        }
        try {
            this.output.startElement(name.getNamespaceURI(), name.getLocalPart(), name.getQualifiedName(), (Attributes)this.attributes);
            if (closure != null) {
                closure.setDelegate((Object)this);
                closure.call();
            }
            if (innerText != null) {
                this.text(innerText);
            }
            this.output.endElement(name.getNamespaceURI(), name.getLocalPart(), name.getQualifiedName());
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isTag(QName name) {
        return name.getNamespaceURI().length() > 0;
    }

    private TagScript createTagScript(QName n, Map<?, ?> attributes) throws JellyException {
        TagLibrary lib = this.context.getTagLibrary(n.getNamespaceURI());
        if (lib != null) {
            String localName = n.getLocalPart();
            TagScript tagScript = lib.createTagScript(localName, null);
            if (tagScript == null) {
                tagScript = lib.createTagScript(localName.replace('_', '-'), null);
            }
            if (tagScript != null) {
                if (attributes != null) {
                    for (Map.Entry<?, ?> e : attributes.entrySet()) {
                        Object v = e.getValue();
                        if (v == null) continue;
                        if (v instanceof GString) {
                            v = v.toString();
                        }
                        tagScript.addAttribute(e.getKey().toString(), (Expression)new ConstantExpression(v));
                    }
                }
                return tagScript;
            }
        }
        return null;
    }

    private void configureTag(Tag tag, Map attributes) throws JellyException {
        if (tag instanceof DynaTag) {
            DynaTag dynaTag = (DynaTag)tag;
            for (Map.Entry o : attributes.entrySet()) {
                Map.Entry entry = o;
                String name = (String)entry.getKey();
                if (name.equals("xmlns")) continue;
                Object value = this.getValue(entry, dynaTag.getAttributeType(name));
                dynaTag.setAttribute(name, value);
            }
        } else {
            ConvertingWrapDynaBean dynaBean = new ConvertingWrapDynaBean((Object)tag);
            for (Map.Entry o : attributes.entrySet()) {
                Map.Entry entry = o;
                String name = (String)entry.getKey();
                if (name.equals("xmlns")) continue;
                DynaProperty property = dynaBean.getDynaClass().getDynaProperty(name);
                if (property == null) {
                    throw new JellyException("This tag does not understand the '" + name + "' attribute");
                }
                dynaBean.set(name, this.getValue(entry, property.getType()));
            }
        }
    }

    private Object getValue(Map.Entry entry, Class type) {
        Object value = entry.getValue();
        if (type == Expression.class) {
            value = new ConstantExpression(entry.getValue());
        }
        return value;
    }

    private Attributes toAttributes(Map attributes) {
        AttributesImpl atts = new AttributesImpl();
        for (Map.Entry o : attributes.entrySet()) {
            Map.Entry e = o;
            if (e.getKey().toString().equals("xmlns")) continue;
            atts.addAttribute("", e.getKey().toString(), e.getKey().toString(), null, e.getValue().toString());
        }
        return atts;
    }

    JellyContext setContext(JellyContext newValue) {
        JellyContext old = this.context;
        this.context = newValue;
        return old;
    }

    public XMLOutput setOutput(XMLOutput newValue) {
        XMLOutput old = this.output;
        this.output = newValue;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object with(XMLOutput out, Closure c) {
        XMLOutput old = this.setOutput(out);
        try {
            c.setDelegate((Object)this);
            Object object = c.call();
            return object;
        }
        finally {
            this.setOutput(old);
        }
    }

    public Element redirectToDom(Closure c) {
        SAXContentHandler sc = new SAXContentHandler();
        this.with(new XMLOutput((ContentHandler)sc), c);
        return sc.getDocument().getRootElement();
    }

    public Object getProperty(String property) {
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            Object r = this.context.getVariableWithDefaultValue(property, MISSING);
            if (r == MISSING) {
                throw e;
            }
            return r;
        }
    }

    public void set(String var, Object value) {
        this.context.setVariable(var, value);
    }

    public Object getMy() {
        return this.context.getVariable("it");
    }

    public void text(Object o) throws SAXException {
        if (o != null) {
            this.output.write(this.escape(o.toString()));
        }
    }

    public void raw(Object o) throws SAXException {
        if (o != null) {
            this.output.write(o.toString());
        }
    }

    private String escape(String v) {
        StringBuilder buf = new StringBuilder(v.length() + 64);
        for (int i = 0; i < v.length(); ++i) {
            char ch = v.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                buf.append("&gt;");
                continue;
            }
            if (ch == '&') {
                buf.append("&amp;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    @SuppressFBWarnings(value={"REFLC_REFLECTION_MAY_INCREASE_ACCESSIBILITY_OF_CLASS"}, justification="TODO needs triage")
    public Object taglib(Class type) throws IllegalAccessException, InstantiationException, IOException, SAXException {
        GroovyClosureScript o = this.taglibs.get(type);
        if (o == null) {
            o = (GroovyClosureScript)((Object)type.newInstance());
            o.setDelegate((GroovyObject)this);
            this.taglibs.put(type, o);
            this.adjunct(type.getName());
        }
        return o;
    }

    public void adjunct(String name) throws IOException, SAXException {
        try {
            AdjunctsInPage aip = AdjunctsInPage.get();
            aip.generate(this.output, new String[]{name});
        }
        catch (NoSuchAdjunctException noSuchAdjunctException) {
            // empty catch block
        }
    }

    public Namespace jelly(Class t) {
        String n = t.getName();
        if (TagLibrary.class.isAssignableFrom(t)) {
            this.context.registerTagLibrary(n, n);
        } else {
            String path = n.replace('.', '/');
            URL res = t.getClassLoader().getResource(path + "/taglib");
            if (res != null) {
                JellyContext parseContext = ((JellyClassLoaderTearOff)MetaClassLoader.get((ClassLoader)t.getClassLoader()).loadTearOff(JellyClassLoaderTearOff.class)).createContext();
                this.context.registerTagLibrary(n, (TagLibrary)new CustomTagLibrary(parseContext, t.getClassLoader(), n, path));
            } else {
                throw new IllegalArgumentException("Cannot find taglib from " + t);
            }
        }
        return new Namespace(this, n, "-");
    }

    public ServletContext getServletContext() {
        return this.getRequest().getServletContext();
    }

    public StaplerRequest getRequest() {
        return this.request;
    }

    public StaplerResponse getResponse() {
        if (this.response == null) {
            this.response = Stapler.getCurrentResponse();
        }
        return this.response;
    }

    public JellyBuilder getBuilder() {
        return this;
    }

    public String getRootURL() {
        if (this.rootURL == null) {
            this.rootURL = this.getRequest().getContextPath();
        }
        return this.rootURL;
    }

    public void img(Object base, String localName) throws SAXException {
        this.output.write("<IMG src='" + this.res(base, localName) + "'>");
    }

    public String res(Object base, String localName) {
        Class<?> c = base instanceof Class ? (Class<?>)base : base.getClass();
        return this.adjunctManager.rootURL + '/' + c.getName().replace('.', '/') + '/' + localName;
    }
}

