/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.array.ObjectArrayMorpher;
import net.sf.ezmorph.bean.BeanMorpher;
import net.sf.ezmorph.object.IdentityObjectMorpher;
import net.sf.json.AbstractJSON;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONString;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonBeanProcessor;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.processors.JsonVerifier;
import net.sf.json.processors.PropertyNameProcessor;
import net.sf.json.util.CycleDetectionStrategy;
import net.sf.json.util.EnumMorpher;
import net.sf.json.util.JSONTokener;
import net.sf.json.util.JSONUtils;
import net.sf.json.util.PropertyFilter;
import net.sf.json.util.PropertySetStrategy;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;

public final class JSONObject
extends AbstractJSON
implements JSON,
Map<String, Object>,
Comparable {
    private static final Logger logger = Logger.getLogger(JSONObject.class.getName());
    private boolean nullObject;
    private Map properties = new LinkedHashMap();

    public static JSONObject fromObject(Object object) {
        return JSONObject.fromObject(object, new JsonConfig());
    }

    public static JSONObject fromObject(Object object, JsonConfig jsonConfig) {
        if (object == null || JSONUtils.isNull(object)) {
            return new JSONObject(true);
        }
        if (object instanceof Enum) {
            throw new JSONException("'object' is an Enum. Use JSONArray instead");
        }
        if (object instanceof Annotation || object.getClass().isAnnotation()) {
            throw new JSONException("'object' is an Annotation.");
        }
        if (object instanceof JSONObject) {
            return JSONObject._fromJSONObject((JSONObject)object, jsonConfig);
        }
        if (object instanceof DynaBean) {
            return JSONObject._fromDynaBean((DynaBean)object, jsonConfig);
        }
        if (object instanceof JSONTokener) {
            return JSONObject._fromJSONTokener((JSONTokener)object, jsonConfig);
        }
        if (object instanceof JSONString) {
            return JSONObject._fromJSONString((JSONString)object, jsonConfig);
        }
        if (object instanceof Map) {
            return JSONObject._fromMap((Map)object, jsonConfig);
        }
        if (object instanceof String) {
            return JSONObject._fromString((String)object, jsonConfig);
        }
        if (JSONUtils.isNumber(object) || JSONUtils.isBoolean(object) || JSONUtils.isString(object)) {
            return new JSONObject();
        }
        if (JSONUtils.isArray(object)) {
            throw new JSONException("'object' is an array. Use JSONArray instead");
        }
        return JSONObject._fromBean(object, jsonConfig);
    }

    public Object toBean() {
        return JSONObject.toBean(this);
    }

    public static Object toBean(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        JsonConfig jsonConfig = new JsonConfig();
        Map props = JSONUtils.getProperties(jsonObject);
        DynaBean dynaBean = JSONUtils.newDynaBean(jsonObject, jsonConfig);
        for (Object o : jsonObject.names(jsonConfig)) {
            String name = (String)o;
            String key = JSONUtils.convertToJavaIdentifier(name, jsonConfig);
            Class type = (Class)props.get(name);
            Object value = jsonObject.get(name);
            try {
                if (!JSONUtils.isNull(value)) {
                    if (value instanceof JSONArray) {
                        dynaBean.set(key, (Object)JSONArray.toCollection((JSONArray)value));
                        continue;
                    }
                    if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type)) {
                        dynaBean.set(key, value);
                        continue;
                    }
                    dynaBean.set(key, JSONObject.toBean((JSONObject)value));
                    continue;
                }
                if (type.isPrimitive()) {
                    logger.log(Level.WARNING, "Tried to assign null value to " + key + ":" + type.getName());
                    dynaBean.set(key, JSONUtils.getMorpherRegistry().morph(type, null));
                    continue;
                }
                dynaBean.set(key, null);
            }
            catch (JSONException jsone) {
                throw jsone;
            }
            catch (Exception e) {
                throw new JSONException("Error while setting property=" + name + " type" + String.valueOf(type), e);
            }
        }
        return dynaBean;
    }

    public Object toBean(Class beanClass) {
        return JSONObject.toBean(this, beanClass);
    }

    public static Object toBean(JSONObject jsonObject, Class beanClass) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(beanClass);
        return JSONObject.toBean(jsonObject, jsonConfig);
    }

    public static Object toBean(JSONObject jsonObject, Class beanClass, Map classMap) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(beanClass);
        jsonConfig.setClassMap(classMap);
        return JSONObject.toBean(jsonObject, jsonConfig);
    }

    public static Object toBean(JSONObject jsonObject, JsonConfig jsonConfig) {
        HashMap bean;
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        Class beanClass = jsonConfig.getRootClass();
        if (beanClass == null) {
            return JSONObject.toBean(jsonObject);
        }
        try {
            if (beanClass.isInterface()) {
                if (!Map.class.isAssignableFrom(beanClass)) {
                    throw new JSONException("beanClass is an interface. " + String.valueOf(beanClass));
                }
                bean = new HashMap();
            } else {
                bean = jsonConfig.getNewBeanInstanceStrategy().newInstance(beanClass, jsonObject);
            }
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return JSONObject.toBean(jsonObject, bean, jsonConfig);
    }

    private static Property getProperty(Class beanClass, Object bean, String key, JsonConfig jsonConfig) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        key = jsonConfig.isSkipJavaIdentifierTransformationInMapKeys() ? key : JSONUtils.convertToJavaIdentifier(key, jsonConfig);
        try {
            if (!jsonConfig.isIgnorePublicFields()) {
                return new FieldProperty(bean.getClass().getField(key));
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)bean, (String)key);
        if (pd != null) {
            return new MethodProperty(pd);
        }
        if (Map.class.isAssignableFrom(beanClass)) {
            return new PropertyOnMap(key);
        }
        return null;
    }

    public static Object toBean(JSONObject jsonObject, Object bean, JsonConfig jsonConfig) {
        Class<?> rootClass;
        if (jsonObject == null || jsonObject.isNullObject() || bean == null) {
            return bean;
        }
        Class<?> beanClass = rootClass = bean.getClass();
        Map classMap = jsonConfig.getClassMap();
        if (classMap == null) {
            classMap = Collections.EMPTY_MAP;
        }
        Map props = JSONUtils.getProperties(jsonObject);
        PropertyFilter javaPropertyFilter = jsonConfig.getJavaPropertyFilter();
        for (Object o : jsonObject.names(jsonConfig)) {
            String name = (String)o;
            Class type = (Class)props.get(name);
            Object value = jsonObject.get(name);
            if (javaPropertyFilter != null && javaPropertyFilter.apply(bean, name, value)) continue;
            String key = Map.class.isAssignableFrom(beanClass) && jsonConfig.isSkipJavaIdentifierTransformationInMapKeys() ? name : JSONUtils.convertToJavaIdentifier(name, jsonConfig);
            PropertyNameProcessor propertyNameProcessor = jsonConfig.findJavaPropertyNameProcessor(beanClass);
            if (propertyNameProcessor != null) {
                key = propertyNameProcessor.processPropertyName(beanClass, key);
            }
            try {
                JsonConfig jsc;
                Property pd = JSONObject.getProperty(rootClass, bean, key, jsonConfig);
                if (pd != null) {
                    if (!pd.isWritable()) {
                        logger.log(Level.INFO, "Property '" + key + "' of " + String.valueOf(bean.getClass()) + " has no write method. SKIPPED.");
                        continue;
                    }
                    if (jsonConfig.getPropertySetStrategy() != null) {
                        pd = new PropertySetterStrategyDecorator(pd, jsonConfig.getPropertySetStrategy());
                    }
                    Class targetType = pd.getPropertyType();
                    if (!JSONUtils.isNull(value)) {
                        if (value instanceof JSONArray) {
                            if (List.class.isAssignableFrom(pd.getPropertyType())) {
                                pd.set(bean, JSONObject.convertPropertyValueToCollection(key, value, jsonConfig, name, classMap, pd.getPropertyType()), jsonConfig);
                                continue;
                            }
                            if (Set.class.isAssignableFrom(pd.getPropertyType())) {
                                pd.set(bean, JSONObject.convertPropertyValueToCollection(key, value, jsonConfig, name, classMap, pd.getPropertyType()), jsonConfig);
                                continue;
                            }
                            pd.set(bean, JSONObject.convertPropertyValueToArray(key, value, targetType, jsonConfig, classMap), jsonConfig);
                            continue;
                        }
                        if (String.class.isAssignableFrom(type) || JSONUtils.isBoolean(type) || JSONUtils.isNumber(type) || JSONUtils.isString(type)) {
                            if (pd != null) {
                                if (jsonConfig.isHandleJettisonEmptyElement() && "".equals(value)) {
                                    pd.set(bean, null, jsonConfig);
                                    continue;
                                }
                                if (!targetType.isInstance(value)) {
                                    pd.set(bean, JSONObject.morphPropertyValue(key, value, type, targetType), jsonConfig);
                                    continue;
                                }
                                pd.set(bean, value, jsonConfig);
                                continue;
                            }
                            if (beanClass == null || bean instanceof Map) {
                                pd.set(bean, value, jsonConfig);
                                continue;
                            }
                            logger.log(Level.WARNING, "Tried to assign property " + key + ":" + type.getName() + " to bean of class " + bean.getClass().getName());
                            continue;
                        }
                        if (jsonConfig.isHandleJettisonSingleElementArray()) {
                            JSONArray array = new JSONArray().element(value, jsonConfig);
                            Class newTargetClass = JSONObject.resolveClass(classMap, key, name, type);
                            JsonConfig jsc2 = jsonConfig.copy();
                            jsc2.setRootClass(newTargetClass);
                            jsc2.setClassMap(classMap);
                            if (targetType.isArray()) {
                                pd.set(bean, JSONArray.toArray(array, jsc2), jsonConfig);
                                continue;
                            }
                            if (JSONArray.class.isAssignableFrom(targetType)) {
                                pd.set(bean, array, jsonConfig);
                                continue;
                            }
                            if (List.class.isAssignableFrom(targetType) || Set.class.isAssignableFrom(targetType)) {
                                jsc2.setCollectionType(targetType);
                                pd.set(bean, JSONArray.toCollection(array, jsc2), jsonConfig);
                                continue;
                            }
                            pd.set(bean, JSONObject.toBean((JSONObject)value, jsc2), jsonConfig);
                            continue;
                        }
                        if (targetType == Object.class || targetType.isInterface()) {
                            Class targetTypeCopy = targetType;
                            targetType = JSONObject.findTargetClass(key, classMap);
                            targetType = targetType == null ? JSONObject.findTargetClass(name, classMap) : targetType;
                            targetType = targetType == null && targetTypeCopy.isInterface() ? targetTypeCopy : targetType;
                        }
                        jsc = jsonConfig.copy();
                        jsc.setRootClass(targetType);
                        jsc.setClassMap(classMap);
                        pd.set(bean, JSONObject.toBean((JSONObject)value, jsc), jsonConfig);
                        continue;
                    }
                    if (type.isPrimitive()) {
                        logger.log(Level.WARNING, "Tried to assign null value to " + key + ":" + type.getName());
                        pd.set(bean, JSONUtils.getMorpherRegistry().morph(type, null), jsonConfig);
                        continue;
                    }
                    pd.set(bean, null, jsonConfig);
                    continue;
                }
                if (!JSONUtils.isNull(value)) {
                    if (value instanceof JSONArray) {
                        JSONObject.setProperty(bean, name, JSONObject.convertPropertyValueToCollection(key, value, jsonConfig, name, classMap, List.class), jsonConfig);
                        continue;
                    }
                    if (String.class.isAssignableFrom(type) || JSONUtils.isBoolean(type) || JSONUtils.isNumber(type) || JSONUtils.isString(type)) {
                        if (beanClass == null || bean instanceof Map || jsonConfig.getPropertySetStrategy() != null || !jsonConfig.isIgnorePublicFields()) {
                            JSONObject.setProperty(bean, name, value, jsonConfig);
                            continue;
                        }
                        logger.log(Level.WARNING, "Tried to assign property " + key + ":" + type.getName() + " to bean of class " + bean.getClass().getName());
                        continue;
                    }
                    if (jsonConfig.isHandleJettisonSingleElementArray()) {
                        Class newTargetClass = JSONObject.resolveClass(classMap, key, name, type);
                        jsc = jsonConfig.copy();
                        jsc.setRootClass(newTargetClass);
                        jsc.setClassMap(classMap);
                        JSONObject.setProperty(bean, name, JSONObject.toBean((JSONObject)value, jsc), jsonConfig);
                        continue;
                    }
                    JSONObject.setProperty(bean, name, value, jsonConfig);
                    continue;
                }
                if (type.isPrimitive()) {
                    logger.log(Level.WARNING, "Tried to assign null value to " + key + ":" + type.getName());
                    JSONObject.setProperty(bean, name, JSONUtils.getMorpherRegistry().morph(type, null), jsonConfig);
                    continue;
                }
                JSONObject.setProperty(bean, name, null, jsonConfig);
            }
            catch (JSONException jsone) {
                throw jsone;
            }
            catch (Exception e) {
                throw new JSONException("Error while setting property=" + name + " type " + String.valueOf(type), e);
            }
        }
        return bean;
    }

    private static JSONObject _fromBean(Object bean, JsonConfig jsonConfig) {
        if (!JSONObject.addInstance(bean)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(bean);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(bean);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(bean);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONObject.fireObjectStartEvent(jsonConfig);
        JsonBeanProcessor processor = jsonConfig.findJsonBeanProcessor(bean.getClass());
        if (processor != null) {
            JSONObject json = null;
            try {
                json = processor.processBean(bean, jsonConfig);
                if (json == null && (json = (JSONObject)jsonConfig.findDefaultValueProcessor(bean.getClass()).getDefaultValue(bean.getClass())) == null) {
                    json = new JSONObject(true);
                }
                JSONObject.removeInstance(bean);
                JSONObject.fireObjectEndEvent(jsonConfig);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(bean);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(bean);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            return json;
        }
        JSONObject jsonObject = JSONObject.defaultBeanProcessing(bean, jsonConfig);
        JSONObject.removeInstance(bean);
        JSONObject.fireObjectEndEvent(jsonConfig);
        return jsonObject;
    }

    private static JSONObject defaultBeanProcessing(Object bean, JsonConfig jsonConfig) {
        Class<?> beanClass = bean.getClass();
        PropertyNameProcessor propertyNameProcessor = jsonConfig.findJsonPropertyNameProcessor(beanClass);
        Collection exclusions = jsonConfig.getMergedExcludes(beanClass);
        JSONObject jsonObject = new JSONObject();
        try {
            PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors((Object)bean);
            PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
            for (PropertyDescriptor pd : pds) {
                boolean bypass = false;
                String key = pd.getName();
                if (exclusions.contains(key) || jsonConfig.isIgnoreTransientFields() && JSONObject.isTransientField(key, beanClass, jsonConfig)) continue;
                Class<?> type = pd.getPropertyType();
                try {
                    pd.getReadMethod();
                }
                catch (Exception e) {
                    String warning = "Property '" + key + "' of " + String.valueOf(beanClass) + " has no read method. SKIPPED";
                    JSONObject.fireWarnEvent(warning, jsonConfig);
                    logger.log(Level.INFO, warning);
                    continue;
                }
                if (pd.getReadMethod() != null) {
                    if (JSONObject.isTransient(pd.getReadMethod(), jsonConfig)) continue;
                    Object value = PropertyUtils.getProperty((Object)bean, (String)key);
                    if (jsonPropertyFilter != null && jsonPropertyFilter.apply(bean, key, value)) continue;
                    JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(beanClass, type, key);
                    if (jsonValueProcessor != null) {
                        value = jsonValueProcessor.processObjectValue(key, value, jsonConfig);
                        bypass = true;
                        if (!JsonVerifier.isValidJsonValue(value)) {
                            throw new JSONException("Value is not a valid JSON value. " + String.valueOf(value));
                        }
                    }
                    if (propertyNameProcessor != null) {
                        key = propertyNameProcessor.processPropertyName(beanClass, key);
                    }
                    JSONObject.setValue(jsonObject, key, value, type, jsonConfig, bypass);
                    continue;
                }
                String warning = "Property '" + key + "' of " + String.valueOf(beanClass) + " has no read method. SKIPPED";
                JSONObject.fireWarnEvent(warning, jsonConfig);
                logger.log(Level.INFO, warning);
            }
            try {
                if (!jsonConfig.isIgnorePublicFields()) {
                    Field[] fields;
                    for (Field item : fields = beanClass.getFields()) {
                        boolean bypass = false;
                        Field field = item;
                        String key = field.getName();
                        if (exclusions.contains(key) || Modifier.isStatic(field.getModifiers()) || jsonConfig.isIgnoreTransientFields() && JSONObject.isTransientField(field, jsonConfig)) continue;
                        Class<?> type = field.getType();
                        Object value = field.get(bean);
                        if (jsonPropertyFilter != null && jsonPropertyFilter.apply(bean, key, value)) continue;
                        JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(beanClass, type, key);
                        if (jsonValueProcessor != null) {
                            value = jsonValueProcessor.processObjectValue(key, value, jsonConfig);
                            bypass = true;
                            if (!JsonVerifier.isValidJsonValue(value)) {
                                throw new JSONException("Value is not a valid JSON value. " + String.valueOf(value));
                            }
                        }
                        if (propertyNameProcessor != null) {
                            key = propertyNameProcessor.processPropertyName(beanClass, key);
                        }
                        JSONObject.setValue(jsonObject, key, value, type, jsonConfig, bypass);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "Couldn't read public fields.", e);
            }
        }
        catch (JSONException jsone) {
            JSONObject.removeInstance(bean);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        catch (Exception e) {
            JSONObject.removeInstance(bean);
            JSONException jsone = new JSONException(e);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        return jsonObject;
    }

    private static JSONObject _fromDynaBean(DynaBean bean, JsonConfig jsonConfig) {
        if (bean == null) {
            JSONObject.fireObjectStartEvent(jsonConfig);
            JSONObject.fireObjectEndEvent(jsonConfig);
            return new JSONObject(true);
        }
        if (!JSONObject.addInstance(bean)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(bean);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(bean);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(bean);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONObject.fireObjectStartEvent(jsonConfig);
        JSONObject jsonObject = new JSONObject();
        try {
            DynaProperty[] props = bean.getDynaClass().getDynaProperties();
            Collection exclusions = jsonConfig.getMergedExcludes();
            PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
            for (DynaProperty prop : props) {
                boolean bypass = false;
                DynaProperty dynaProperty = prop;
                String key = dynaProperty.getName();
                if (exclusions.contains(key)) continue;
                Class type = dynaProperty.getType();
                Object value = bean.get(dynaProperty.getName());
                if (jsonPropertyFilter != null && jsonPropertyFilter.apply(bean, key, value)) continue;
                JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(type, key);
                if (jsonValueProcessor != null) {
                    value = jsonValueProcessor.processObjectValue(key, value, jsonConfig);
                    bypass = true;
                    if (!JsonVerifier.isValidJsonValue(value)) {
                        throw new JSONException("Value is not a valid JSON value. " + String.valueOf(value));
                    }
                }
                JSONObject.setValue(jsonObject, key, value, type, jsonConfig, bypass);
            }
        }
        catch (JSONException jsone) {
            JSONObject.removeInstance(bean);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        catch (RuntimeException e) {
            JSONObject.removeInstance(bean);
            JSONException jsone = new JSONException(e);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        JSONObject.removeInstance(bean);
        JSONObject.fireObjectEndEvent(jsonConfig);
        return jsonObject;
    }

    private static JSONObject _fromJSONObject(JSONObject object, JsonConfig jsonConfig) {
        if (object == null || object.isNullObject()) {
            JSONObject.fireObjectStartEvent(jsonConfig);
            JSONObject.fireObjectEndEvent(jsonConfig);
            return new JSONObject(true);
        }
        if (!JSONObject.addInstance(object)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(object);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(object);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(object);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONObject.fireObjectStartEvent(jsonConfig);
        JSONArray sa = object.names(jsonConfig);
        Collection exclusions = jsonConfig.getMergedExcludes();
        JSONObject jsonObject = new JSONObject();
        PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
        for (Object k : sa) {
            if (k == null) {
                throw new JSONException("JSON keys cannot be null.");
            }
            if (!(k instanceof String) && !jsonConfig.isAllowNonStringKeys()) {
                throw new ClassCastException("JSON keys must be strings.");
            }
            String key = String.valueOf(k);
            if ("null".equals(key)) {
                throw new NullPointerException("JSON keys must not be null nor the 'null' string.");
            }
            if (exclusions.contains(key)) continue;
            Object value = object.opt(key);
            if (jsonPropertyFilter != null && jsonPropertyFilter.apply(object, key, value)) continue;
            if (jsonObject.properties.containsKey(key)) {
                jsonObject.accumulate(key, value, jsonConfig);
                JSONObject.firePropertySetEvent(key, value, true, jsonConfig);
                continue;
            }
            jsonObject.setInternal(key, value, jsonConfig);
            JSONObject.firePropertySetEvent(key, value, false, jsonConfig);
        }
        JSONObject.removeInstance(object);
        JSONObject.fireObjectEndEvent(jsonConfig);
        return jsonObject;
    }

    private static JSONObject _fromJSONString(JSONString string, JsonConfig jsonConfig) {
        return JSONObject._fromJSONTokener(new JSONTokener(string.toJSONString()), jsonConfig);
    }

    private static JSONObject _fromJSONTokener(JSONTokener tokener, JsonConfig jsonConfig) {
        try {
            if (tokener.startsWith("null")) {
                JSONObject.fireObjectStartEvent(jsonConfig);
                JSONObject.fireObjectEndEvent(jsonConfig);
                return new JSONObject(true);
            }
            if (tokener.nextClean() != '{') {
                throw tokener.syntaxError("A JSONObject text must begin with '{'");
            }
            JSONObject.fireObjectStartEvent(jsonConfig);
            Collection exclusions = jsonConfig.getMergedExcludes();
            PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
            JSONObject jsonObject = new JSONObject();
            block14: while (true) {
                char c = tokener.nextClean();
                switch (c) {
                    case '\u0000': {
                        throw tokener.syntaxError("A JSONObject text must end with '}'");
                    }
                    case '}': {
                        JSONObject.fireObjectEndEvent(jsonConfig);
                        return jsonObject;
                    }
                }
                tokener.back();
                String key = tokener.nextValue(jsonConfig).toString();
                c = tokener.nextClean();
                if (c == '=') {
                    if (tokener.next() != '>') {
                        tokener.back();
                    }
                } else if (c != ':') {
                    throw tokener.syntaxError("Expected a ':' after a key");
                }
                Object v = tokener.nextValue(jsonConfig);
                if (exclusions.contains(key)) {
                    switch (tokener.nextClean()) {
                        case ',': 
                        case ';': {
                            if (tokener.nextClean() == '}') {
                                JSONObject.fireObjectEndEvent(jsonConfig);
                                return jsonObject;
                            }
                            tokener.back();
                            continue block14;
                        }
                        case '}': {
                            JSONObject.fireObjectEndEvent(jsonConfig);
                            return jsonObject;
                        }
                    }
                    throw tokener.syntaxError("Expected a ',' or '}'");
                }
                if (jsonPropertyFilter == null || !jsonPropertyFilter.apply(tokener, key, v)) {
                    if (jsonObject.properties.containsKey(key)) {
                        jsonObject.accumulate(key, v, jsonConfig);
                        JSONObject.firePropertySetEvent(key, v, true, jsonConfig);
                    } else {
                        jsonObject.element(key, v, jsonConfig);
                        JSONObject.firePropertySetEvent(key, v, false, jsonConfig);
                    }
                }
                switch (tokener.nextClean()) {
                    case ',': 
                    case ';': {
                        if (tokener.nextClean() == '}') {
                            JSONObject.fireObjectEndEvent(jsonConfig);
                            return jsonObject;
                        }
                        tokener.back();
                        continue block14;
                    }
                    case '}': {
                        JSONObject.fireObjectEndEvent(jsonConfig);
                        return jsonObject;
                    }
                }
                break;
            }
            throw tokener.syntaxError("Expected a ',' or '}'");
        }
        catch (JSONException jsone) {
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
    }

    private static JSONObject _fromMap(Map map, JsonConfig jsonConfig) {
        if (map == null) {
            JSONObject.fireObjectStartEvent(jsonConfig);
            JSONObject.fireObjectEndEvent(jsonConfig);
            return new JSONObject(true);
        }
        if (!JSONObject.addInstance(map)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(map);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(map);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(map);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONObject.fireObjectStartEvent(jsonConfig);
        Collection exclusions = jsonConfig.getMergedExcludes();
        JSONObject jsonObject = new JSONObject();
        PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
        try {
            for (Map.Entry o : map.entrySet()) {
                boolean bypass = false;
                Map.Entry entry = o;
                Object k = entry.getKey();
                if (k == null) {
                    throw new JSONException("JSON keys cannot be null.");
                }
                if (!(k instanceof String) && !jsonConfig.isAllowNonStringKeys()) {
                    throw new ClassCastException("JSON keys must be strings.");
                }
                String key = String.valueOf(k);
                if ("null".equals(key)) {
                    throw new NullPointerException("JSON keys must not be null nor the 'null' string.");
                }
                if (exclusions.contains(key)) continue;
                Object value = entry.getValue();
                if (jsonPropertyFilter != null && jsonPropertyFilter.apply(map, key, value)) continue;
                if (value != null) {
                    JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(value.getClass(), key);
                    if (jsonValueProcessor != null) {
                        value = jsonValueProcessor.processObjectValue(key, value, jsonConfig);
                        bypass = true;
                        if (!JsonVerifier.isValidJsonValue(value)) {
                            throw new JSONException("Value is not a valid JSON value. " + String.valueOf(value));
                        }
                    }
                    JSONObject.setValue(jsonObject, key, value, value.getClass(), jsonConfig, bypass);
                    continue;
                }
                if (jsonObject.properties.containsKey(key)) {
                    jsonObject.accumulate(key, JSONNull.getInstance());
                    JSONObject.firePropertySetEvent(key, JSONNull.getInstance(), true, jsonConfig);
                    continue;
                }
                jsonObject.element(key, JSONNull.getInstance());
                JSONObject.firePropertySetEvent(key, JSONNull.getInstance(), false, jsonConfig);
            }
        }
        catch (JSONException jsone) {
            JSONObject.removeInstance(map);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        catch (RuntimeException e) {
            JSONObject.removeInstance(map);
            JSONException jsone = new JSONException(e);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        JSONObject.removeInstance(map);
        JSONObject.fireObjectEndEvent(jsonConfig);
        return jsonObject;
    }

    private static JSONObject _fromString(String str, JsonConfig jsonConfig) {
        if (str == null || "null".equals(str)) {
            JSONObject.fireObjectStartEvent(jsonConfig);
            JSONObject.fireObjectEndEvent(jsonConfig);
            return new JSONObject(true);
        }
        return JSONObject._fromJSONTokener(new JSONTokener(str), jsonConfig);
    }

    private static Object convertPropertyValueToArray(String key, Object value, Class targetType, JsonConfig jsonConfig, Map classMap) {
        Class innerType = JSONUtils.getInnerComponentType(targetType);
        Class targetInnerType = JSONObject.findTargetClass(key, classMap);
        if (innerType.equals(Object.class) && targetInnerType != null && !targetInnerType.equals(Object.class)) {
            innerType = targetInnerType;
        }
        JsonConfig jsc = jsonConfig.copy();
        jsc.setRootClass(innerType);
        jsc.setClassMap(classMap);
        Object array = JSONArray.toArray((JSONArray)value, jsc);
        if (innerType.isPrimitive() || JSONUtils.isNumber(innerType) || Boolean.class.isAssignableFrom(innerType) || JSONUtils.isString(innerType)) {
            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
        } else if (!array.getClass().equals(targetType) && !targetType.equals(Object.class)) {
            Morpher morpher = JSONUtils.getMorpherRegistry().getMorpherFor(Array.newInstance(innerType, 0).getClass());
            if (IdentityObjectMorpher.getInstance().equals(morpher)) {
                ObjectArrayMorpher beanMorpher = new ObjectArrayMorpher(new BeanMorpher(innerType, JSONUtils.getMorpherRegistry()));
                JSONUtils.getMorpherRegistry().registerMorpher(beanMorpher);
            }
            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
        }
        return array;
    }

    private static List convertPropertyValueToList(String key, Object value, JsonConfig jsonConfig, String name, Map classMap) {
        Class targetClass = JSONObject.findTargetClass(key, classMap);
        targetClass = targetClass == null ? JSONObject.findTargetClass(name, classMap) : targetClass;
        JsonConfig jsc = jsonConfig.copy();
        jsc.setRootClass(targetClass);
        jsc.setClassMap(classMap);
        List list = (List)JSONArray.toCollection((JSONArray)value, jsc);
        return list;
    }

    private static Collection convertPropertyValueToCollection(String key, Object value, JsonConfig jsonConfig, String name, Map classMap, Class collectionType) {
        Class targetClass = JSONObject.findTargetClass(key, classMap);
        targetClass = targetClass == null ? JSONObject.findTargetClass(name, classMap) : targetClass;
        JsonConfig jsc = jsonConfig.copy();
        jsc.setRootClass(targetClass);
        jsc.setClassMap(classMap);
        jsc.setCollectionType(collectionType);
        return JSONArray.toCollection((JSONArray)value, jsc);
    }

    private static Class resolveClass(Map classMap, String key, String name, Class type) {
        Class<ArrayList> targetClass = JSONObject.findTargetClass(key, classMap);
        if (targetClass == null) {
            targetClass = JSONObject.findTargetClass(name, classMap);
        }
        if (targetClass == null && type != null) {
            if (List.class.equals((Object)type)) {
                targetClass = ArrayList.class;
            } else if (Map.class.equals((Object)type)) {
                targetClass = LinkedHashMap.class;
            } else if (Set.class.equals((Object)type)) {
                targetClass = LinkedHashSet.class;
            } else if (!type.isInterface() && !Object.class.equals((Object)type)) {
                targetClass = type;
            }
        }
        return targetClass;
    }

    private static Class findTargetClass(String key, Map<String, Class> classMap) {
        Class targetClass = classMap.get(key);
        if (targetClass == null) {
            for (Map.Entry<String, Class> entry : classMap.entrySet()) {
                if (!Pattern.compile(entry.getKey()).matcher(key).matches()) continue;
                targetClass = entry.getValue();
                break;
            }
        }
        return targetClass;
    }

    private static boolean isTransientField(String name, Class beanClass, JsonConfig jsonConfig) {
        try {
            return JSONObject.isTransientField(beanClass.getDeclaredField(name), jsonConfig);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error while inspecting field " + String.valueOf(beanClass) + "." + name + " for transient status.", e);
            return false;
        }
    }

    private static boolean isTransientField(Field field, JsonConfig jsonConfig) {
        try {
            if ((field.getModifiers() & 0x80) == 128) {
                return true;
            }
            return JSONObject.isTransient(field, jsonConfig);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error while inspecting field " + String.valueOf(field) + " for transient status.", e);
            return false;
        }
    }

    private static boolean isTransient(AnnotatedElement element, JsonConfig jsonConfig) {
        Iterator annotations = jsonConfig.getIgnoreFieldAnnotations().iterator();
        while (annotations.hasNext()) {
            try {
                String annotationClassName = (String)annotations.next();
                if (element.getAnnotation(Class.forName(annotationClassName)) == null) continue;
                return true;
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Error while inspecting " + String.valueOf(element) + " for transient status.", e);
            }
        }
        return false;
    }

    private static Object morphPropertyValue(String key, Object value, Class type, Class targetType) {
        Morpher morpher = JSONUtils.getMorpherRegistry().getMorpherFor(targetType);
        if (IdentityObjectMorpher.getInstance().equals(morpher)) {
            logger.log(Level.WARNING, "Can't transform property '" + key + "' from " + type.getName() + " into " + targetType.getName() + ". Will register a default Morpher");
            if (Enum.class.isAssignableFrom(targetType)) {
                JSONUtils.getMorpherRegistry().registerMorpher(new EnumMorpher(targetType));
            } else {
                JSONUtils.getMorpherRegistry().registerMorpher(new BeanMorpher(targetType, JSONUtils.getMorpherRegistry()));
            }
        }
        value = JSONUtils.getMorpherRegistry().morph(targetType, value);
        return value;
    }

    private static void setProperty(Object bean, String key, Object value, JsonConfig jsonConfig) throws Exception {
        PropertySetStrategy propertySetStrategy = jsonConfig.getPropertySetStrategy() != null ? jsonConfig.getPropertySetStrategy() : PropertySetStrategy.DEFAULT;
        propertySetStrategy.setProperty(bean, key, value, jsonConfig);
    }

    private static void setValue(JSONObject jsonObject, String key, Object value, Class type, JsonConfig jsonConfig, boolean bypass) {
        boolean accumulated = false;
        if (value == null && !JsonVerifier.isValidJsonValue(value = jsonConfig.findDefaultValueProcessor(type).getDefaultValue(type))) {
            throw new JSONException("Value is not a valid JSON value. " + String.valueOf(value));
        }
        if (jsonObject.properties.containsKey(key)) {
            if (String.class.isAssignableFrom(type)) {
                Object o = jsonObject.opt(key);
                if (o instanceof JSONArray) {
                    ((JSONArray)o).addString((String)value);
                } else {
                    jsonObject.properties.put(key, new JSONArray().element(o).addString((String)value));
                }
            } else {
                jsonObject.accumulate(key, value, jsonConfig);
            }
            accumulated = true;
        } else if (bypass || String.class.isAssignableFrom(type)) {
            jsonObject.properties.put(key, value);
        } else {
            jsonObject.setInternal(key, value, jsonConfig);
        }
        value = jsonObject.opt(key);
        if (accumulated) {
            JSONArray array = (JSONArray)value;
            value = array.get(array.size() - 1);
        }
        JSONObject.firePropertySetEvent(key, value, accumulated, jsonConfig);
    }

    public JSONObject() {
    }

    public JSONObject(boolean isNull) {
        this();
        this.nullObject = isNull;
    }

    public JSONObject accumulate(String key, boolean value) {
        return this._accumulate(key, value ? Boolean.TRUE : Boolean.FALSE, new JsonConfig());
    }

    public JSONObject accumulate(String key, double value) {
        return this._accumulate(key, value, new JsonConfig());
    }

    public JSONObject accumulate(String key, int value) {
        return this._accumulate(key, value, new JsonConfig());
    }

    public JSONObject accumulate(String key, long value) {
        return this._accumulate(key, value, new JsonConfig());
    }

    public JSONObject accumulate(String key, Object value) {
        return this._accumulate(key, value, new JsonConfig());
    }

    public JSONObject accumulate(String key, Object value, JsonConfig jsonConfig) {
        return this._accumulate(key, value, jsonConfig);
    }

    public void accumulateAll(Map map) {
        this.accumulateAll(map, new JsonConfig());
    }

    public void accumulateAll(Map map, JsonConfig jsonConfig) {
        if (map instanceof JSONObject) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.accumulate(key, value, jsonConfig);
            }
        } else {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                this.accumulate(key, value, jsonConfig);
            }
        }
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    public int compareTo(Object obj) {
        if (obj != null && obj instanceof JSONObject) {
            int size2;
            JSONObject other = (JSONObject)obj;
            int size1 = this.size();
            if (size1 < (size2 = other.size())) {
                return -1;
            }
            if (size1 > size2) {
                return 1;
            }
            if (this.equals(other)) {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(value, new JsonConfig());
    }

    public boolean containsValue(Object value, JsonConfig jsonConfig) {
        try {
            value = this.processValue(value, jsonConfig);
        }
        catch (JSONException e) {
            return false;
        }
        return this.properties.containsValue(value);
    }

    public JSONObject discard(String key) {
        this.verifyIsNull();
        this.properties.remove(key);
        return this;
    }

    public JSONObject element(String key, boolean value) {
        this.verifyIsNull();
        return this.element(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONObject element(String key, Collection value) {
        return this.element(key, value, new JsonConfig());
    }

    public JSONObject element(String key, Collection value, JsonConfig jsonConfig) {
        if (!(value instanceof JSONArray)) {
            value = JSONArray.fromObject(value, jsonConfig);
        }
        return this.setInternal(key, value, jsonConfig);
    }

    public JSONObject element(String key, double value) {
        this.verifyIsNull();
        Double d = value;
        JSONUtils.testValidity(d);
        return this.element(key, d);
    }

    public JSONObject element(String key, int value) {
        this.verifyIsNull();
        return this.element(key, (Object)value);
    }

    public JSONObject element(String key, long value) {
        this.verifyIsNull();
        return this.element(key, (Object)value);
    }

    public JSONObject element(String key, Map value) {
        return this.element(key, value, new JsonConfig());
    }

    public JSONObject element(String key, Map value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (value instanceof JSONObject) {
            return this.setInternal(key, value, jsonConfig);
        }
        return this.element(key, JSONObject.fromObject(value, jsonConfig), jsonConfig);
    }

    public JSONObject element(String key, Object value) {
        return this.element(key, value, new JsonConfig());
    }

    public JSONObject element(String key, Object value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            value = this.processValue(key, value, jsonConfig);
            this._setInternal(key, value, jsonConfig);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject elementOpt(String key, Object value) {
        return this.elementOpt(key, value, new JsonConfig());
    }

    public JSONObject elementOpt(String key, Object value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (key != null && value != null) {
            this.element(key, value, jsonConfig);
        }
        return this;
    }

    @Override
    public Set entrySet() {
        return Collections.unmodifiableSet(this.properties.entrySet());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONObject)) {
            return false;
        }
        JSONObject other = (JSONObject)obj;
        if (this.isNullObject()) {
            return other.isNullObject();
        }
        if (other.isNullObject()) {
            return false;
        }
        if (other.size() != this.size()) {
            return false;
        }
        for (Object o : this.properties.keySet()) {
            String key = (String)o;
            if (!other.properties.containsKey(key)) {
                return false;
            }
            Object o1 = this.properties.get(key);
            Object o2 = other.properties.get(key);
            if (JSONNull.getInstance().equals(o1)) {
                if (JSONNull.getInstance().equals(o2)) continue;
                return false;
            }
            if (JSONNull.getInstance().equals(o2)) {
                return false;
            }
            if (o1 instanceof JSONObject && o2 instanceof JSONObject) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof JSONArray && o2 instanceof JSONArray) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof String) {
                if (o1.equals(String.valueOf(o2))) continue;
                return false;
            }
            if (o2 instanceof String) {
                if (o2.equals(String.valueOf(o1))) continue;
                return false;
            }
            Morpher m1 = JSONUtils.getMorpherRegistry().getMorpherFor(o1.getClass());
            Morpher m2 = JSONUtils.getMorpherRegistry().getMorpherFor(o2.getClass());
            if (!(m1 != null && m1 != IdentityObjectMorpher.getInstance() ? !o1.equals(JSONUtils.getMorpherRegistry().morph(o1.getClass(), o2)) : (m2 != null && m2 != IdentityObjectMorpher.getInstance() ? !JSONUtils.getMorpherRegistry().morph(o1.getClass(), o1).equals(o2) : !o1.equals(o2)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            return this.get((String)key);
        }
        return null;
    }

    public Object get(String key) {
        this.verifyIsNull();
        return this.properties.get(key);
    }

    public boolean getBoolean(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
                return false;
            }
            if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
                return true;
            }
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            try {
                return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
            }
            catch (Exception e) {
                throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
            }
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
    }

    public int getInt(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
    }

    public JSONArray getJSONArray(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null && o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (JSONNull.getInstance().equals(o)) {
            return new JSONObject(true);
        }
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(key);
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
    }

    public String getString(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            return o.toString();
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] not found.");
    }

    public boolean has(String key) {
        this.verifyIsNull();
        return this.properties.containsKey(key);
    }

    @Override
    public int hashCode() {
        int hashcode = 19;
        if (this.isNullObject()) {
            return hashcode + JSONNull.getInstance().hashCode();
        }
        Iterator iterator = this.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            hashcode += key.hashCode() + JSONUtils.hashCode(value);
        }
        return hashcode;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean isNullObject() {
        return this.nullObject;
    }

    public Iterator<String> keys() {
        this.verifyIsNull();
        return this.keySet().iterator();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public JSONArray names() {
        this.verifyIsNull();
        JSONArray ja = new JSONArray();
        Iterator<String> keys = this.keys();
        while (keys.hasNext()) {
            ja.element((Object)keys.next());
        }
        return ja;
    }

    public JSONArray names(JsonConfig jsonConfig) {
        this.verifyIsNull();
        JSONArray ja = new JSONArray();
        Iterator<String> keys = this.keys();
        while (keys.hasNext()) {
            ja.element((Object)keys.next(), jsonConfig);
        }
        return ja;
    }

    public Object opt(String key) {
        this.verifyIsNull();
        return key == null ? null : this.properties.get(key);
    }

    public boolean optBoolean(String key) {
        this.verifyIsNull();
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        this.verifyIsNull();
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(String key) {
        this.verifyIsNull();
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        this.verifyIsNull();
        try {
            Object o = this.opt(key);
            return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        this.verifyIsNull();
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        this.verifyIsNull();
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(String key) {
        this.verifyIsNull();
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        this.verifyIsNull();
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        this.verifyIsNull();
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        Object previous = this.properties.get(key);
        this.element(String.valueOf(key), value);
        return previous;
    }

    @Override
    public void putAll(Map map) {
        this.putAll(map, new JsonConfig());
    }

    public void putAll(Map map, JsonConfig jsonConfig) {
        if (map instanceof JSONObject) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.properties.put(key, value);
            }
        } else {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                this.element(key, value, jsonConfig);
            }
        }
    }

    @Override
    public Object remove(Object key) {
        return this.properties.remove(key);
    }

    public Object remove(String key) {
        this.verifyIsNull();
        return this.properties.remove(key);
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    public JSONArray toJSONArray(JSONArray names) {
        this.verifyIsNull();
        if (names == null || names.size() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.size(); ++i) {
            ja.element(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        try {
            Iterator<String> keys = this.keys();
            StringBuilder sb = new StringBuilder("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                String o = keys.next();
                sb.append(JSONUtils.quote(o.toString()));
                sb.append(':');
                sb.append(JSONUtils.valueToString(this.properties.get(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String toString(int indentFactor) {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        if (indentFactor == 0) {
            return this.toString();
        }
        return this.toString(indentFactor, 0);
    }

    @Override
    public String toString(int indentFactor, int indent) {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        int n = this.size();
        if (n == 0) {
            return "{}";
        }
        if (indentFactor == 0) {
            return this.toString();
        }
        Iterator<String> keys = this.keys();
        StringBuilder sb = new StringBuilder("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            String o = keys.next();
            sb.append(JSONUtils.quote(o.toString()));
            sb.append(": ");
            sb.append(JSONUtils.valueToString(this.properties.get(o), indentFactor, indent));
        } else {
            int i;
            while (keys.hasNext()) {
                String o = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(JSONUtils.quote(o.toString()));
                sb.append(": ");
                sb.append(JSONUtils.valueToString(this.properties.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
            for (i = 0; i < indent; ++i) {
                sb.insert(0, ' ');
            }
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Collection values() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    @Override
    protected void write(Writer writer, AbstractJSON.WritingVisitor visitor) throws IOException {
        try {
            if (this.isNullObject()) {
                writer.write(JSONNull.getInstance().toString());
            }
            boolean b = false;
            Iterator keys = visitor.keySet(this).iterator();
            writer.write(123);
            while (keys.hasNext()) {
                if (b) {
                    writer.write(44);
                }
                Object k = keys.next();
                writer.write(JSONUtils.quote(k.toString()));
                writer.write(58);
                Object v = this.properties.get(k);
                if (v instanceof JSON) {
                    visitor.on((JSON)v, writer);
                } else {
                    visitor.on(v, writer);
                }
                b = true;
            }
            writer.write(125);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    private JSONObject _accumulate(String key, Object value, JsonConfig jsonConfig) {
        if (this.isNullObject()) {
            throw new JSONException("Can't accumulate on null object");
        }
        if (!this.has(key)) {
            this.setInternal(key, value, jsonConfig);
        } else {
            Object o = this.opt(key);
            if (o instanceof JSONArray) {
                ((JSONArray)o).element(value, jsonConfig);
            } else {
                this.setInternal(key, new JSONArray().element(o).element(value, jsonConfig), jsonConfig);
            }
        }
        return this;
    }

    @Override
    protected Object _processValue(Object value, JsonConfig jsonConfig) {
        if (value instanceof JSONTokener) {
            return JSONObject._fromJSONTokener((JSONTokener)value, jsonConfig);
        }
        if (value != null && Enum.class.isAssignableFrom(value.getClass())) {
            return ((Enum)value).name();
        }
        return super._processValue(value, jsonConfig);
    }

    private JSONObject _setInternal(String key, Object value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (JSONUtils.isString(value) && JSONUtils.mayBeJSON(String.valueOf(value))) {
            this.properties.put(key, value);
        } else if (CycleDetectionStrategy.IGNORE_PROPERTY_OBJ != value && CycleDetectionStrategy.IGNORE_PROPERTY_ARR != value) {
            this.properties.put(key, value);
        }
        return this;
    }

    private Object processValue(Object value, JsonConfig jsonConfig) {
        JsonValueProcessor processor;
        if (value != null && (processor = jsonConfig.findJsonValueProcessor(value.getClass())) != null && !JsonVerifier.isValidJsonValue(value = processor.processObjectValue(null, value, jsonConfig))) {
            throw new JSONException("Value is not a valid JSON value. " + String.valueOf(value));
        }
        return this._processValue(value, jsonConfig);
    }

    private Object processValue(String key, Object value, JsonConfig jsonConfig) {
        JsonValueProcessor processor;
        if (value != null && (processor = jsonConfig.findJsonValueProcessor(value.getClass(), key)) != null && !JsonVerifier.isValidJsonValue(value = processor.processObjectValue(null, value, jsonConfig))) {
            throw new JSONException("Value is not a valid JSON value. " + String.valueOf(value));
        }
        return this._processValue(value, jsonConfig);
    }

    private JSONObject setInternal(String key, Object value, JsonConfig jsonConfig) {
        return this._setInternal(key, this.processValue(key, value, jsonConfig), jsonConfig);
    }

    private void verifyIsNull() {
        if (this.isNullObject()) {
            throw new JSONException("null object");
        }
    }

    private static class FieldProperty
    implements Property {
        private final Field f;

        private FieldProperty(Field f) {
            this.f = f;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public Class getPropertyType() {
            return this.f.getType();
        }

        @Override
        public String name() {
            return this.f.getName();
        }

        @Override
        public void set(Object bean, Object value, JsonConfig jsonConfig) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
            this.f.set(bean, value);
        }
    }

    private static class MethodProperty
    implements Property {
        private final PropertyDescriptor pd;

        private MethodProperty(PropertyDescriptor pd) {
            this.pd = pd;
        }

        @Override
        public boolean isWritable() {
            return this.pd.getWriteMethod() != null;
        }

        @Override
        public String name() {
            return this.pd.getName();
        }

        @Override
        public Class getPropertyType() {
            return this.pd.getPropertyType();
        }

        @Override
        public void set(Object bean, Object value, JsonConfig jsonConfig) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
            PropertyUtils.setSimpleProperty((Object)bean, (String)this.pd.getName(), (Object)value);
        }
    }

    private static class PropertyOnMap
    implements Property {
        private final String name;

        private PropertyOnMap(String name) {
            this.name = name;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class getPropertyType() {
            return Object.class;
        }

        @Override
        public void set(Object bean, Object value, JsonConfig jsonConfig) {
            ((Map)bean).put(this.name, value);
        }
    }

    private static interface Property {
        public boolean isWritable();

        public Class getPropertyType();

        public String name();

        public void set(Object var1, Object var2, JsonConfig var3) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException;
    }

    private static class PropertySetterStrategyDecorator
    implements Property {
        private final Property inner;
        private final PropertySetStrategy strategy;

        private PropertySetterStrategyDecorator(Property inner, PropertySetStrategy strategy) {
            this.inner = inner;
            this.strategy = strategy;
        }

        @Override
        public boolean isWritable() {
            return this.inner.isWritable();
        }

        @Override
        public Class getPropertyType() {
            return this.inner.getPropertyType();
        }

        @Override
        public String name() {
            return this.inner.name();
        }

        @Override
        public void set(Object bean, Object value, JsonConfig jsonConfig) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
            this.strategy.setProperty(bean, this.name(), value, jsonConfig);
        }
    }
}

