/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Writer;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public final class JSONNull
implements JSON {
    private static JSONNull instance = new JSONNull();

    public static JSONNull getInstance() {
        return instance;
    }

    private JSONNull() {
    }

    @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"}, justification="TODO needs triage")
    public boolean equals(Object object) {
        return object == null || object == this || object == instance || object instanceof JSONObject && ((JSONObject)object).isNullObject();
    }

    public int hashCode() {
        return 37 + "null".hashCode();
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        throw new JSONException("Object is null");
    }

    @Override
    public int size() {
        throw new JSONException("Object is null");
    }

    public String toString() {
        return "null";
    }

    @Override
    public String toString(int indentFactor) {
        return this.toString();
    }

    @Override
    public String toString(int indentFactor, int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        sb.append(this.toString());
        return sb.toString();
    }

    @Override
    public Writer write(Writer writer) throws IOException {
        writer.write(this.toString());
        return writer;
    }

    @Override
    public Writer writeCanonical(Writer w) throws IOException {
        return this.write(w);
    }
}

