/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.bean;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.MorphUtils;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.bean.MorphDynaClass;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public final class MorphDynaBean
implements DynaBean,
Serializable {
    private static final long serialVersionUID = -605547389232706344L;
    private MorphDynaClass dynaClass;
    private Map<String, Object> dynaValues = new HashMap<String, Object>();
    private MorpherRegistry morpherRegistry;

    public MorphDynaBean() {
        this(null);
    }

    public MorphDynaBean(MorpherRegistry morpherRegistry) {
        this.setMorpherRegistry(morpherRegistry);
    }

    public boolean contains(String name, String key) {
        DynaProperty dynaProperty = this.getDynaProperty(name);
        Class type = dynaProperty.getType();
        if (!Map.class.isAssignableFrom(type)) {
            throw new MorphException("Non-Mapped property name: " + name + " key: " + key);
        }
        HashMap value = this.dynaValues.get(name);
        if (value == null) {
            value = new HashMap();
            this.dynaValues.put(name, value);
        }
        return ((Map)value).containsKey(key);
    }

    public boolean equals(Object obj) {
        DynaProperty[] props;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MorphDynaBean)) {
            return false;
        }
        MorphDynaBean other = (MorphDynaBean)obj;
        if (!Objects.equals(this.dynaClass, other.dynaClass)) {
            return false;
        }
        if (this.dynaClass.getDynaProperties().length != other.dynaClass.getDynaProperties().length) {
            return false;
        }
        for (DynaProperty prop : props = this.dynaClass.getDynaProperties()) {
            if (Objects.equals(this.dynaValues.get(prop.getName()), other.dynaValues.get(prop.getName()))) continue;
            return false;
        }
        return true;
    }

    public Object get(String name) {
        Object value = this.dynaValues.get(name);
        if (value != null) {
            return value;
        }
        Class type = this.getDynaProperty(name).getType();
        if (!type.isPrimitive()) {
            return value;
        }
        return this.morpherRegistry.morph(type, value);
    }

    public Object get(String name, int index) {
        DynaProperty dynaProperty = this.getDynaProperty(name);
        Class type = dynaProperty.getType();
        if (!type.isArray() && !List.class.isAssignableFrom(type)) {
            throw new MorphException("Non-Indexed property name: " + name + " index: " + index);
        }
        Object value = this.dynaValues.get(name);
        if (value.getClass().isArray()) {
            value = Array.get(value, index);
        } else if (value instanceof List) {
            value = ((List)value).get(index);
        }
        return value;
    }

    public Object get(String name, String key) {
        DynaProperty dynaProperty = this.getDynaProperty(name);
        Class type = dynaProperty.getType();
        if (!Map.class.isAssignableFrom(type)) {
            throw new MorphException("Non-Mapped property name: " + name + " key: " + key);
        }
        HashMap value = this.dynaValues.get(name);
        if (value == null) {
            value = new HashMap();
            this.dynaValues.put(name, value);
        }
        return ((Map)value).get(key);
    }

    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    public MorpherRegistry getMorpherRegistry() {
        return this.morpherRegistry;
    }

    public int hashCode() {
        DynaProperty[] props;
        int result = Objects.hashCode(this.dynaClass);
        for (DynaProperty prop : props = this.dynaClass.getDynaProperties()) {
            result = 31 * result + Objects.hashCode(this.dynaValues.get(prop.getName()));
        }
        return result;
    }

    public void remove(String name, String key) {
        DynaProperty dynaProperty = this.getDynaProperty(name);
        Class type = dynaProperty.getType();
        if (!Map.class.isAssignableFrom(type)) {
            throw new MorphException("Non-Mapped property name: " + name + " key: " + key);
        }
        HashMap value = this.dynaValues.get(name);
        if (value == null) {
            value = new HashMap();
            this.dynaValues.put(name, value);
        }
        ((Map)value).remove(key);
    }

    public void set(String name, int index, Object value) {
        DynaProperty dynaProperty = this.getDynaProperty(name);
        Class type = dynaProperty.getType();
        if (!type.isArray() && !List.class.isAssignableFrom(type)) {
            throw new MorphException("Non-Indexed property name: " + name + " index: " + index);
        }
        ArrayList prop = this.dynaValues.get(name);
        if (prop == null) {
            prop = List.class.isAssignableFrom(type) ? new ArrayList() : Array.newInstance(type.getComponentType(), index + 1);
            this.dynaValues.put(name, prop);
        }
        if (prop.getClass().isArray()) {
            if (index >= Array.getLength(prop)) {
                Object tmp = Array.newInstance(type.getComponentType(), index + 1);
                System.arraycopy(prop, 0, tmp, 0, Array.getLength(prop));
                prop = tmp;
                this.dynaValues.put(name, tmp);
            }
            Array.set(prop, index, value);
        } else if (prop instanceof List) {
            List l = prop;
            if (index >= l.size()) {
                for (int i = l.size(); i <= index + 1; ++i) {
                    l.add(null);
                }
            }
            ((List)prop).set(index, value);
        }
    }

    public void set(String name, Object value) {
        DynaProperty property = this.getDynaProperty(name);
        if (value == null || !this.isDynaAssignable(property.getType(), value.getClass())) {
            value = this.morpherRegistry.morph(property.getType(), value);
        }
        this.dynaValues.put(name, value);
    }

    public void set(String name, String key, Object value) {
        DynaProperty dynaProperty = this.getDynaProperty(name);
        Class type = dynaProperty.getType();
        if (!Map.class.isAssignableFrom(type)) {
            throw new MorphException("Non-Mapped property name: " + name + " key: " + key);
        }
        HashMap prop = this.dynaValues.get(name);
        if (prop == null) {
            prop = new HashMap();
            this.dynaValues.put(name, prop);
        }
        ((Map)prop).put(key, value);
    }

    public synchronized void setDynaBeanClass(MorphDynaClass dynaClass) {
        if (this.dynaClass == null) {
            this.dynaClass = dynaClass;
        }
    }

    public void setMorpherRegistry(MorpherRegistry morpherRegistry) {
        if (morpherRegistry == null) {
            this.morpherRegistry = new MorpherRegistry();
            MorphUtils.registerStandardMorphers(this.morpherRegistry);
        } else {
            this.morpherRegistry = morpherRegistry;
        }
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]");
        for (Map.Entry<String, Object> entry : this.dynaValues.entrySet()) {
            joiner.add(entry.getKey() + "=" + String.valueOf(entry.getValue()));
        }
        return joiner.toString();
    }

    protected DynaProperty getDynaProperty(String name) {
        DynaProperty property = this.getDynaClass().getDynaProperty(name);
        if (property == null) {
            throw new MorphException("Unspecified property for " + name);
        }
        return property;
    }

    protected boolean isDynaAssignable(Class dest, Class src) {
        boolean assignable = dest.isAssignableFrom(src);
        if (assignable) {
            return true;
        }
        assignable = dest == Boolean.TYPE && src == Boolean.class ? true : assignable;
        assignable = dest == Byte.TYPE && src == Byte.class ? true : assignable;
        assignable = dest == Character.TYPE && src == Character.class ? true : assignable;
        assignable = dest == Short.TYPE && src == Short.class ? true : assignable;
        assignable = dest == Integer.TYPE && src == Integer.class ? true : assignable;
        assignable = dest == Long.TYPE && src == Long.class ? true : assignable;
        assignable = dest == Float.TYPE && src == Float.class ? true : assignable;
        boolean bl = assignable = dest == Double.TYPE && src == Double.class ? true : assignable;
        if (src == Double.TYPE || Double.class.isAssignableFrom(src)) {
            boolean bl2 = assignable = this.isByte(dest) || this.isShort(dest) || this.isInteger(dest) || this.isLong(dest) || this.isFloat(dest) ? true : assignable;
        }
        if (src == Float.TYPE || Float.class.isAssignableFrom(src)) {
            boolean bl3 = assignable = this.isByte(dest) || this.isShort(dest) || this.isInteger(dest) || this.isLong(dest) ? true : assignable;
        }
        if (src == Long.TYPE || Long.class.isAssignableFrom(src)) {
            boolean bl4 = assignable = this.isByte(dest) || this.isShort(dest) || this.isInteger(dest) ? true : assignable;
        }
        if (src == Integer.TYPE || Integer.class.isAssignableFrom(src)) {
            boolean bl5 = assignable = this.isByte(dest) || this.isShort(dest) ? true : assignable;
        }
        if (src == Short.TYPE || Short.class.isAssignableFrom(src)) {
            assignable = this.isByte(dest) ? true : assignable;
        }
        return assignable;
    }

    private boolean isByte(Class clazz) {
        return Byte.class.isAssignableFrom(clazz) || clazz == Byte.TYPE;
    }

    private boolean isFloat(Class clazz) {
        return Float.class.isAssignableFrom(clazz) || clazz == Float.TYPE;
    }

    private boolean isInteger(Class clazz) {
        return Integer.class.isAssignableFrom(clazz) || clazz == Integer.TYPE;
    }

    private boolean isLong(Class clazz) {
        return Long.class.isAssignableFrom(clazz) || clazz == Long.TYPE;
    }

    private boolean isShort(Class clazz) {
        return Short.class.isAssignableFrom(clazz) || clazz == Short.TYPE;
    }
}

