/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.array;

import java.lang.reflect.Array;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.array.AbstractArrayMorpher;
import net.sf.ezmorph.primitive.ShortMorpher;

public final class ShortArrayMorpher
extends AbstractArrayMorpher {
    private static final Class SHORT_ARRAY_CLASS = short[].class;
    private short defaultValue;

    public ShortArrayMorpher() {
        super(false);
    }

    public ShortArrayMorpher(short defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShortArrayMorpher)) {
            return false;
        }
        ShortArrayMorpher other = (ShortArrayMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public short getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(this.getDefaultValue());
        }
        return 17;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (SHORT_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return (short[])array;
        }
        if (array.getClass().isArray()) {
            ShortMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = this.createDimensions(dims, length);
            Object result = Array.newInstance(Short.TYPE, dimensions);
            ShortMorpher shortMorpher = morpher = this.isUseDefault() ? new ShortMorpher(this.defaultValue) : new ShortMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.setShort(result, index, morpher.morph(Array.get(array, index)));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + String.valueOf(array.getClass()));
    }

    @Override
    public Class morphsTo() {
        return SHORT_ARRAY_CLASS;
    }
}

